/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.util.ldiff;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseNotFoundException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.util.ldiff.Block;
import com.sleepycat.je.rep.util.ldiff.DiffRecordAnalyzer;
import com.sleepycat.je.rep.util.ldiff.LDiff;
import com.sleepycat.je.rep.util.ldiff.LDiffConfig;
import com.sleepycat.je.rep.util.ldiff.LDiffRecordRequestException;
import com.sleepycat.je.rep.util.ldiff.Protocol;
import com.sleepycat.je.rep.util.ldiff.Record;
import com.sleepycat.je.rep.utilint.BinaryProtocol;
import com.sleepycat.je.rep.utilint.ServiceDispatcher;
import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;

public class LDiffService
extends ServiceDispatcher.ExecutingService {
    public static final String NAME = "LDiff";
    private final AtomicBoolean busy = new AtomicBoolean(false);
    private final RepImpl repImpl;
    private final ServiceDispatcher dispatcher;

    public LDiffService(ServiceDispatcher dispatcher, RepImpl repImpl) {
        super(NAME, dispatcher);
        this.repImpl = repImpl;
        this.dispatcher = dispatcher;
        dispatcher.register(this);
    }

    public void shutdown() {
        this.dispatcher.cancel(NAME);
    }

    public boolean isBusy() {
        return this.busy.get();
    }

    public Runnable getRunnable(SocketChannel socketChannel) {
        if (!this.busy.compareAndSet(false, true)) {
            throw EnvironmentFailureException.unexpectedState("Service is already busy");
        }
        return new LDiffServiceRunnable(socketChannel);
    }

    class LDiffServiceRunnable
    implements Runnable {
        final SocketChannel channel;
        private ReplicatedEnvironment env;
        private DatabaseConfig dbConfig = new DatabaseConfig();

        LDiffServiceRunnable(SocketChannel socketChannel) {
            this.channel = socketChannel;
            this.dbConfig.setReadOnly(true);
            this.dbConfig.setAllowCreate(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void runLDiff(Protocol.DbBlocks request, Protocol protocol) throws IOException {
            Database db;
            block11: {
                db = null;
                Cursor cursor = null;
                try {
                    block10: {
                        try {
                            db = this.env.openDatabase(null, request.getDbName(), this.dbConfig);
                            protocol.write((BinaryProtocol.Message)protocol.new Protocol.BlockListStart(), this.channel);
                            LDiffConfig cfg = new LDiffConfig();
                            cfg.setBlockSize(request.getBlockSize());
                            LDiff ldf = new LDiff(cfg);
                            Iterator<Block> blocks = ldf.iterator(db);
                            while (blocks.hasNext()) {
                                Protocol protocol2 = protocol;
                                protocol2.getClass();
                                protocol.write((BinaryProtocol.Message)protocol2.new Protocol.BlockInfo(blocks.next()), this.channel);
                            }
                            protocol.write((BinaryProtocol.Message)protocol.new Protocol.BlockListEnd(), this.channel);
                            BinaryProtocol.Message msg = protocol.read(this.channel);
                            if (msg.getOp() == Protocol.REMOTE_DIFF_REQUEST) {
                                cursor = db.openCursor(null, null);
                                this.sendDiffArea(cursor, (Protocol.RemoteDiffRequest)msg, protocol);
                                this.runDiffAnalysis(cursor, protocol);
                                break block10;
                            }
                            if (msg.getOp() != Protocol.DONE) {
                                Protocol protocol3 = protocol;
                                protocol3.getClass();
                                protocol.write((BinaryProtocol.Message)(BinaryProtocol)protocol3.new BinaryProtocol.ProtocolError("Invalid message: " + msg), this.channel);
                            }
                        }
                        catch (DatabaseNotFoundException e) {
                            Protocol protocol4 = protocol;
                            protocol4.getClass();
                            protocol.write((BinaryProtocol.Message)protocol4.new Protocol.DbMismatch(e.getMessage()), this.channel);
                            Object var10_11 = null;
                            if (cursor != null) {
                                cursor.close();
                            }
                            if (db == null) return;
                            db.close();
                            return;
                        }
                    }
                    Object var10_10 = null;
                    if (cursor == null) break block11;
                }
                catch (Throwable throwable) {
                    Object var10_12 = null;
                    if (cursor != null) {
                        cursor.close();
                    }
                    if (db == null) throw throwable;
                    db.close();
                    throw throwable;
                }
                cursor.close();
            }
            if (db == null) return;
            db.close();
        }

        private void runDiffAnalysis(Cursor cursor, Protocol protocol) throws IOException {
            block1: {
                BinaryProtocol.Message msg;
                while ((msg = protocol.read(this.channel)).getOp() == Protocol.REMOTE_DIFF_REQUEST) {
                    this.sendDiffArea(cursor, (Protocol.RemoteDiffRequest)msg, protocol);
                }
                if (msg.getOp() == Protocol.DONE) break block1;
                Protocol protocol2 = protocol;
                protocol2.getClass();
                protocol.write((BinaryProtocol.Message)(BinaryProtocol)protocol2.new BinaryProtocol.ProtocolError("Invalid message: " + msg), this.channel);
            }
        }

        private void sendDiffArea(Cursor cursor, Protocol.RemoteDiffRequest request, Protocol protocol) throws IOException {
            HashSet<Record> records = null;
            try {
                records = DiffRecordAnalyzer.getDiffArea(cursor, request);
            }
            catch (Exception e) {
                Protocol protocol2 = protocol;
                protocol2.getClass();
                protocol.write((BinaryProtocol.Message)protocol2.new Protocol.Error(e.getMessage()), this.channel);
                throw new LDiffRecordRequestException(e.getMessage());
            }
            protocol.write((BinaryProtocol.Message)protocol.new Protocol.DiffAreaStart(), this.channel);
            for (Record record : records) {
                Protocol protocol3 = protocol;
                protocol3.getClass();
                protocol.write((BinaryProtocol.Message)protocol3.new Protocol.RemoteRecord(record), this.channel);
            }
            protocol.write((BinaryProtocol.Message)protocol.new Protocol.DiffAreaEnd(), this.channel);
        }

        public void runEnvDiff(Protocol.EnvDiff request, Protocol protocol) throws IOException {
            Protocol protocol2 = protocol;
            protocol2.getClass();
            protocol.write((BinaryProtocol.Message)protocol2.new Protocol.EnvInfo(this.env.getDatabaseNames().size()), this.channel);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block19: {
                try {
                    try {
                        block18: {
                            this.env = LDiffService.this.repImpl.makeEnvironment();
                            Protocol protocol = new Protocol(new NameIdPair("Ldiff", -1), LDiffService.this.repImpl);
                            try {
                                block17: {
                                    try {
                                        this.channel.configureBlocking(true);
                                        BinaryProtocol.Message msg = protocol.read(this.channel);
                                        if (msg.getOp() == Protocol.DB_BLOCKS) {
                                            this.runLDiff((Protocol.DbBlocks)msg, protocol);
                                            break block17;
                                        }
                                        if (msg.getOp() != Protocol.ENV_DIFF) break block17;
                                        this.runEnvDiff((Protocol.EnvDiff)msg, protocol);
                                    }
                                    catch (BinaryProtocol.ProtocolException e) {
                                        Protocol protocol2 = protocol;
                                        protocol2.getClass();
                                        protocol.write((BinaryProtocol.Message)(BinaryProtocol)protocol2.new BinaryProtocol.ProtocolError(e.getMessage()), this.channel);
                                        Object var4_6 = null;
                                        if (this.channel.isOpen()) {
                                            this.channel.close();
                                        }
                                        break block18;
                                    }
                                }
                                Object var4_5 = null;
                            }
                            catch (Throwable throwable) {
                                Object var4_7 = null;
                                if (!this.channel.isOpen()) throw throwable;
                                this.channel.close();
                                throw throwable;
                            }
                            if (this.channel.isOpen()) {
                                this.channel.close();
                            }
                        }
                        Object var6_9 = null;
                        if (this.env == null) break block19;
                    }
                    catch (IOException iOException) {
                        Object var6_10 = null;
                        if (this.env != null) {
                            this.env.close();
                        }
                        if (LDiffService.this.busy.compareAndSet(true, false)) return;
                        throw EnvironmentFailureException.unexpectedState("Service is not busy");
                    }
                }
                catch (Throwable throwable) {
                    Object var6_11 = null;
                    if (this.env != null) {
                        this.env.close();
                    }
                    if (LDiffService.this.busy.compareAndSet(true, false)) throw throwable;
                    throw EnvironmentFailureException.unexpectedState("Service is not busy");
                }
                this.env.close();
            }
            if (LDiffService.this.busy.compareAndSet(true, false)) return;
            throw EnvironmentFailureException.unexpectedState("Service is not busy");
        }
    }
}

