/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.impl;

import com.sleepycat.je.JEVersion;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.rep.NodeState;
import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.utilint.BinaryProtocol;
import java.nio.ByteBuffer;

public class BinaryNodeStateProtocol
extends BinaryProtocol {
    public static final int VERSION = 1;
    public static final BinaryProtocol.MessageOp BIN_NODE_STATE_REQ = new BinaryProtocol.MessageOp(1, BinaryNodeStateRequest.class);
    public static final BinaryProtocol.MessageOp BIN_NODE_STATE_RESP = new BinaryProtocol.MessageOp(2, BinaryNodeStateResponse.class);

    public BinaryNodeStateProtocol(NameIdPair nameIdPair, RepImpl repImpl) {
        super(nameIdPair, 1, 1, repImpl);
        this.initializeMessageOps(new BinaryProtocol.MessageOp[]{BIN_NODE_STATE_REQ, BIN_NODE_STATE_RESP});
    }

    public class BinaryNodeStateResponse
    extends BinaryProtocol.SimpleMessage {
        private final String nodeName;
        private final String groupName;
        private final String masterName;
        private final JEVersion jeVersion;
        private final long joinTime;
        private final ReplicatedEnvironment.State nodeState;
        private final long commitVLSN;
        private final long masterCommitVLSN;
        private final int activeFeeders;
        private final int logVersion;
        private final byte[] appState;
        private final double systemLoad;

        public BinaryNodeStateResponse(String nodeName, String groupName, String masterName, JEVersion jeVersion, long joinTime, ReplicatedEnvironment.State nodeState, long commitVLSN, long masterCommitVLSN, int activeFeeders, int logVersion, byte[] appState, double systemLoad) {
            this.nodeName = nodeName;
            this.groupName = groupName;
            this.masterName = masterName;
            this.jeVersion = jeVersion;
            this.joinTime = joinTime;
            this.nodeState = nodeState;
            this.commitVLSN = commitVLSN;
            this.masterCommitVLSN = masterCommitVLSN;
            this.activeFeeders = activeFeeders;
            this.logVersion = logVersion;
            this.appState = appState;
            this.systemLoad = systemLoad;
        }

        public BinaryNodeStateResponse(ByteBuffer buffer) {
            this.nodeName = BinaryNodeStateProtocol.this.getString(buffer);
            this.groupName = BinaryNodeStateProtocol.this.getString(buffer);
            this.masterName = BinaryNodeStateProtocol.this.getString(buffer);
            this.jeVersion = new JEVersion(BinaryNodeStateProtocol.this.getString(buffer));
            this.joinTime = LogUtils.readLong(buffer);
            this.nodeState = this.getEnum(ReplicatedEnvironment.State.class, buffer);
            this.commitVLSN = LogUtils.readLong(buffer);
            this.masterCommitVLSN = LogUtils.readLong(buffer);
            this.activeFeeders = LogUtils.readInt(buffer);
            this.logVersion = LogUtils.readInt(buffer);
            this.appState = this.getByteArray(buffer);
            this.systemLoad = this.getDouble(buffer);
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public String getGroupName() {
            return this.groupName;
        }

        public String getMasterName() {
            return this.masterName;
        }

        public JEVersion getJEVersion() {
            return this.jeVersion;
        }

        public long getJoinTime() {
            return this.joinTime;
        }

        public ReplicatedEnvironment.State getNodeState() {
            return this.nodeState;
        }

        public long getCommitVLSN() {
            return this.commitVLSN;
        }

        public long getKnownMasterCommitVLSN() {
            return this.masterCommitVLSN;
        }

        public int getActiveFeeders() {
            return this.activeFeeders;
        }

        public int getLogVersion() {
            return this.logVersion;
        }

        public byte[] getAppState() {
            if (this.appState.length == 0) {
                return null;
            }
            return this.appState;
        }

        public double getSystemLoad() {
            return this.systemLoad;
        }

        public BinaryProtocol.MessageOp getOp() {
            return BIN_NODE_STATE_RESP;
        }

        public ByteBuffer wireFormat() {
            byte[] realAppState = this.appState == null ? new byte[]{} : this.appState;
            return this.wireFormat(new Object[]{this.nodeName, this.groupName, this.masterName, this.jeVersion.toString(), this.joinTime, this.nodeState, this.commitVLSN, this.masterCommitVLSN, this.activeFeeders, this.logVersion, realAppState, this.systemLoad});
        }

        public NodeState convertToNodeState() {
            return new NodeState(this.nodeName, this.groupName, this.nodeState, this.masterName, this.jeVersion, this.joinTime, this.commitVLSN, this.masterCommitVLSN, this.activeFeeders, this.logVersion, this.getAppState(), this.systemLoad);
        }
    }

    public class BinaryNodeStateRequest
    extends BinaryProtocol.SimpleMessage {
        private final String nodeName;
        private final String groupName;

        public BinaryNodeStateRequest(String nodeName, String groupName) {
            this.nodeName = nodeName;
            this.groupName = groupName;
        }

        public BinaryNodeStateRequest(ByteBuffer buffer) {
            this.nodeName = BinaryNodeStateProtocol.this.getString(buffer);
            this.groupName = BinaryNodeStateProtocol.this.getString(buffer);
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public String getGroupName() {
            return this.groupName;
        }

        public BinaryProtocol.MessageOp getOp() {
            return BIN_NODE_STATE_REQ;
        }

        public ByteBuffer wireFormat() {
            return this.wireFormat(this.nodeName, this.groupName);
        }
    }
}

