### TempCov: Toolkit for investigating temperature covert channels
### Copyright (C) 2006 Steven J. Murdoch <http://www.cl.cam.ac.uk/users/sjm217/>
###
### This program is free software; you can redistribute it and/or modify
### it under the terms of the GNU General Public License as published by
### the Free Software Foundation; either version 2 of the License, or
### (at your option) any later version.
###
### This program is distributed in the hope that it will be useful,
### but WITHOUT ANY WARRANTY; without even the implied warranty of
### MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
### GNU General Public License for more details.
###
### You should have received a copy of the GNU General Public License along
### with this program; if not, write to the Free Software Foundation, Inc.,
### 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
###
### $Id: example.R 3381 2006-12-25 18:07:55Z sjm217 $

source("util.R")
source("common.R")

#####
## Colours
#####

coOffsetSlope <- "#35b409" # Green
coTemperature <- "#c28730" # Orange
coSkew <- "#2b6bcc"        # Blue
coOffset <- "grey"
coOnOff <- "darkgrey"

#####
## Load environment variables
#####

fnPrefix <- Sys.getenv("FNPREFIX")     # Input file prefix
fnOutPrefix <- Sys.getenv("OUTPREFIX") # Output file prefix
HostNames <- Sys.getenv("HOSTS")       # IP address(es)

#####
## Plotting options
#####

doOnOff <- Sys.getenv("PLOTONOFF")=="1" # Plot load induction (from *_burn.data)
doTemperature <- Sys.getenv("PLOTTEMP")=="1" # Plot temperature (from *_temp.data)
tPiece=2400*1000000 # Width of a piece in ms

#####
## Clock frequency of hosts (TCP timestamp, ICMP timestamp, TCP sequence number)
#####

Clocks <- function(host) {
    if (host=="xx.xx.xx.xx") {
      ## A Linux 2.6.17 SMP PREEMPT host
      return (c(250, 1000, 1000000))
    }
    else if (host=="xx.xx.xx.xx") {
      ## A Linux 2.4.18 host
      return (c(100, 1000, 1000000))
    }
    else {
      ## Common on Linux 2.6.x hosts
      return (c(1000, 1000, 1000000))
    }
}

#####
## Allow calling script to alter the axes (handy for leaving space for labels)
#####

tweakRange <- function(iAxis, xyLim){
  a <- xyLim[1]
  b <- xyLim[2]
  d <- b-a

  if (iAxis==1) {
    ## X Axis
    a <- a + 3/8*d
  }
  else {
    ## Y Axis
    a <- a - 0.1*d
  }

  return(c(a,b))
}

#####
## Do the plotting
#####
for (iAnimStep in (0:0)) {
  ## iAnimStep is how much of the graph to draw
  ## For papers (where space is limited)
  ##  0: Draw it all, including small text
  ## For animations in presentations
  ##  1: Draw only offset samples
  ##  2: Draw (1) + estimated offset
  ##  3: Draw (2) + skew estimate
  ##  4: Draw (3) + temperature

  ## Output filename
  filename <- paste("example", fnOutPrefix, iAnimStep, ".pdf", sep="")
  pdf(file=filename, width=inFromCm(8.45), height=inFromCm(7),
      pointsize=7)

  ## Load the plotting code
  source("plot_offset_skew.R")

  ## Flush and close the output buffer
  dev.off()
}
