# Usage: python TestResults.py RESULTS.res MSGFILE.msg
import sys
RESFILE = sys.argv[1]
MSGFILE = sys.argv[2]

print 'Testing results in %s against message file %s' % (RESFILE, MSGFILE)

# Parse results file
fres = file(RESFILE,'r')
RES = {}
for line in fres:
    (idin, idout) = line[:-1].split(',')[:2]
    # Make sure no white space remains
    (idin, idout) = (idin.strip(), idout.strip())
    # Record correspondances
    RES[idin] = idout
fres.close()

# Parse message file and calculate statistics
TOTAL = 0
ATTEMPTED = 0
SOLVED = 0

fmsg = file(MSGFILE,'r')
fmsg.readline()
for line in fmsg:
    TOTAL += 1
    (idin, idout) = line[:-1].split(',')[:2]
    # Make sure no white space remains
    (idin, idout) = (idin.strip(), idout.strip())
    if idin in RES:
        # Attempted
        ATTEMPTED += 1
        if RES[idin] == idout:
            # Solved!!!
            SOLVED += 1
fmsg.close()

# Print some prety results
print "\nTOTAL: %s\tATTEMPTED:%s\tSOLVED: %s" % (TOTAL, ATTEMPTED, SOLVED)
print "Attempted Score: %s\tTotal Score: %s\n" % (float(SOLVED)/ATTEMPTED,  float(SOLVED)/TOTAL)
