(**************************************************************************)
(*         x86 Multiprocessor Machine Code Semantics: HOL sources         *)
(*                                                                        *)
(*                                                                        *)
(*  Susmit Sarkar (1), Peter Sewell (1), Francesco Zappa Nardelli (2),    *)
(*  Scott Owens (1), Tom Ridge (1), Thomas Braibant (2),                  *)
(*  Magnus Myreen (1), Jade Alglave (2)                                   *)
(*                                                                        *)
(*   (1) Computer Laboratory, University of Cambridge                     *)
(*   (2) Moscova project, INRIA Paris-Rocquencourt                        *)
(*                                                                        *)
(*    Copyright 2007-2008                                                 *)
(*                                                                        *)
(*  Redistribution and use in source and binary forms, with or without    *)
(*  modification, are permitted provided that the following conditions    *)
(*  are met:                                                              *)
(*                                                                        *)
(*  1. Redistributions of source code must retain the above copyright     *)
(*     notice, this list of conditions and the following disclaimer.      *)
(*  2. Redistributions in binary form must reproduce the above copyright  *)
(*     notice, this list of conditions and the following disclaimer in    *)
(*     the documentation and/or other materials provided with the         *)
(*     distribution.                                                      *)
(*  3. The names of the authors may not be used to endorse or promote     *)
(*     products derived from this software without specific prior         *)
(*     written permission.                                                *)
(*                                                                        *)
(*  THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS    *)
(*  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED     *)
(*  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE    *)
(*  ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY       *)
(*  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL    *)
(*  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE     *)
(*  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS         *)
(*  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,          *)
(*  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING             *)
(*  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS    *)
(*  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.          *)
(*                                                                        *)
(**************************************************************************)

open HolKernel boolLib Parse bossLib pairLib;
open pred_setTheory computeLib;
open utilLib utilTheory;
open x86_axiomatic_modelTheory;
open x86_typesTheory x86_event_opsem_wfTheory x86_programTheory x86_decoderTheory;

open HolDoc;
val _ = new_theory "x86_program_event_structure_wf";

val ex_w_eip_check_iiid_thm = Q.prove (
`!ii inst len eip E e.
  locked_has_mem_load_instr inst /\
  E IN (x86_execute_with_eip_check ii inst len eip) /\
  e IN E.events
  ==>
  (e.iiid = ii)`,
RWTAC [x86_execute_with_eip_check_def, LET_THM] THEN
METIS_TAC [well_formedM_def, x86_execute_well_formedM_thm,
           x86_event_execute_def]);

val ex_w_eip_check_proc_thm = Q.prove (
`!ii inst len eip E.
  locked_has_mem_load_instr inst /\
  E IN (x86_execute_with_eip_check ii inst len eip)
  ==>
  (E.procs SUBSET {ii.proc})`,
RWTAC [x86_execute_with_eip_check_def, LET_THM] THEN
IMP_RES_TAC x86_execute_well_formedM_thm THEN
FSTAC [well_formedM_def, x86_event_execute_def] THEN
RWTAC [SUBSET_DEF] THEN
RWTAC [] THEN
RES_TAC THEN
FSTAC [] THEN
METIS_TAC []);


val ex_w_eip_check_well_formed_thm = Q.prove (
`!ii inst len eip E.
  locked_has_mem_load_instr inst /\
  E IN (x86_execute_with_eip_check ii inst len eip)
  ==>
  well_formed_event_structure E`,
RWTAC [x86_execute_with_eip_check_def, LET_THM] THEN
METIS_TAC [well_formedM_def, x86_execute_well_formedM_thm,
           x86_event_execute_def]);

val decode_locked_has_mem_load_lem = Q.prove (
`!b inst r. (x86_decode b = SOME (inst, r)) ==> locked_has_mem_load_instr inst`,
RWTAC [x86_decode_def, LET_THM] THEN
Cases_on `x86_decode_prefixes b` THEN
FSTAC [] THEN
Cases_on `r'` THEN
FSTAC [] THEN
Cases_on `x86_decode_aux r''` THEN
FSTAC [] THEN
Cases_on `x` THEN
FSTAC [] THEN
Cases_on `~(q = Xlock) \/ x86_lock_ok q''` THEN
FSTAC [] THEN
RWTAC [] THEN
Cases_on `q` THEN
FSTAC [locked_has_mem_load_instr_def]);

val decode_locked_has_mem_load_thm = Q.prove (
`!prog_word8 prog_Xinst eip inst n.
  decode_program_rel prog_word8 prog_Xinst /\
  (prog_Xinst eip = SOME (inst, n)) 
  ==>
  locked_has_mem_load_instr inst`,
RWTAC [decode_program_rel_def] THEN
Q.PAT_ASSUM `!a. P a` (MP_TAC o Q.SPEC `eip`) THEN
RWTAC [decode_program_fun_def] THEN
Cases_on `x86_decode_bytes (MAP THE (read_mem_bytes 20 eip prog_word8))` THEN
FSTAC [LET_THM] THEN
Cases_on `x` THEN
FSTAC [] THEN
Cases_on `EVERY (\x. ~(x = NONE)) (read_mem_bytes (20 - LENGTH r DIV 8) eip prog_word8)` THEN
FULL_SIMP_TAC std_ss [] THEN
RWTAC [] THEN
FSTAC [x86_decoderTheory.x86_decode_bytes_def] THEN
METIS_TAC [decode_locked_has_mem_load_lem]);

val lem1 = Q.prove (
`!Es. BIGUNION {es.procs | es IN Es} = {p | ?es. p IN es.procs /\ es IN Es}`,
RWTAC [EXTENSION] THEN
METIS_TAC []);

val x86_program_well_formed_event_structure_thm = Q.store_thm ("x86_program_well_formed_event_structure_thm",
`!prog_Xinst rs. 
  decode_program_rel prog_word8 prog_Xinst /\
  run_skeleton_wf (DOMAIN prog_Xinst) rs 
  ==>
  !E. 
    E IN event_structures_of_run_skeleton prog_Xinst rs 
    ==> 
    well_formed_event_structure E`,
RWTAC [event_structures_of_run_skeleton_def, LET_THM, all_choices_def,
       GSYM LEFT_FORALL_IMP_THM] THEN
MATCH_MP_TAC es_bigunion_well_formed_thm THEN
REWRITE_TAC [lem1] THEN
RWTAC [] THENL
[`locked_has_mem_load_instr inst /\ locked_has_mem_load_instr inst'` by 
          METIS_TAC [decode_locked_has_mem_load_thm] THEN
     RES_TAC THEN
     IMP_RES_TAC ex_w_eip_check_iiid_thm THEN
     FSTAC [] THEN
     RWTAC [] THEN
     `SOME (inst, n) = SOME (inst', n')` by METIS_TAC [] THEN
     FSTAC [],
 FSTAC [run_skeleton_wf_def] THEN
     `{p | ?es. p IN es.procs /\ ?x. (es = choice x) /\ 
           ?p i inst n eip. (x = x86_execute_with_eip_check <|proc := p; program_order_index := i|> inst (n2w n) eip) /\ 
                            (rs p i = SOME eip) /\ (SOME (inst,n) = prog_Xinst eip)}
      SUBSET
      {p | ?i a. rs p i = SOME a}` by
              (RWTAC [SUBSET_DEF] THEN
               RES_TAC THEN
               Q.ABBREV_TAC `E = choice (x86_execute_with_eip_check <|proc := p; program_order_index := i|> 
                                                                    inst (n2w n) eip)` THEN
               IMP_RES_TAC ex_w_eip_check_proc_thm THEN
               RWTAC [proc_def] THEN
               `locked_has_mem_load_instr inst` by METIS_TAC [decode_locked_has_mem_load_thm] THEN
               FSTAC [SUBSET_DEF] THEN
               METIS_TAC []) THEN
     METIS_TAC [SUBSET_FINITE],
 METIS_TAC [ex_w_eip_check_well_formed_thm, decode_locked_has_mem_load_thm]]);

val _ = export_theory ();

