(**************************************************************************)
(*         x86 Multiprocessor Machine Code Semantics: HOL sources         *)
(*                                                                        *)
(*                                                                        *)
(*  Susmit Sarkar (1), Peter Sewell (1), Francesco Zappa Nardelli (2),    *)
(*  Scott Owens (1), Tom Ridge (1), Thomas Braibant (2),                  *)
(*  Magnus Myreen (1), Jade Alglave (2)                                   *)
(*                                                                        *)
(*   (1) Computer Laboratory, University of Cambridge                     *)
(*   (2) Moscova project, INRIA Paris-Rocquencourt                        *)
(*                                                                        *)
(*    Copyright 2007-2008                                                 *)
(*                                                                        *)
(*  Redistribution and use in source and binary forms, with or without    *)
(*  modification, are permitted provided that the following conditions    *)
(*  are met:                                                              *)
(*                                                                        *)
(*  1. Redistributions of source code must retain the above copyright     *)
(*     notice, this list of conditions and the following disclaimer.      *)
(*  2. Redistributions in binary form must reproduce the above copyright  *)
(*     notice, this list of conditions and the following disclaimer in    *)
(*     the documentation and/or other materials provided with the         *)
(*     distribution.                                                      *)
(*  3. The names of the authors may not be used to endorse or promote     *)
(*     products derived from this software without specific prior         *)
(*     written permission.                                                *)
(*                                                                        *)
(*  THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS    *)
(*  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED     *)
(*  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE    *)
(*  ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY       *)
(*  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL    *)
(*  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE     *)
(*  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS         *)
(*  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,          *)
(*  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING             *)
(*  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS    *)
(*  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.          *)
(*                                                                        *)
(**************************************************************************)

open HolKernel boolLib Parse bossLib pred_setLib pred_setTheory relationTheory;
open res_quanLib pairTheory;
open x86_axiomatic_modelTheory utilTheory utilLib;

open HolDoc;
val _ = new_theory "x86_axiomatic_model_thms";

val get_l_stores_lem = Q.prove (
`!x E l l'. x IN get_l_stores E l /\ x IN get_l_stores E l' ==> (l = l')`,
RWTAC [get_l_stores_def] THEN 
FSTAC []);

val lem1 = Q.prove (
`!r l x y choice. 
   (!xs. (?l. xs = {r | strict_linear_order r (get_l_stores E l)}) ==> choice xs IN xs)
   ==>
   ((?l'. (x, y) IN choice {r | strict_linear_order r (get_l_stores E l')} /\
          x IN get_l_stores E l /\ y IN get_l_stores E l) =
    (x, y) IN choice {r | strict_linear_order r (get_l_stores E l)})`,
RWTAC [] THEN 
EQ_TAC THEN 
RWTAC [] THENL
[Q.PAT_ASSUM `!xs. P xs` (MP_TAC o Q.SPEC `{r | strict_linear_order r (get_l_stores E l')}`) THEN
     RWTAC [] THEN 
     FSTAC [GSYM LEFT_FORALL_IMP_THM] THEN
     Q.PAT_ASSUM `!l'. P l'` (MP_TAC o Q.SPEC `l'`) THEN 
     RWTAC [] THEN 
     METIS_TAC [RQ strict_linear_order_dom_rng_lem, get_l_stores_lem],
 Q.PAT_ASSUM `!xs. P xs` (MP_TAC o Q.SPEC `{r | strict_linear_order r (get_l_stores E l)}`) THEN
     RWTAC [] THEN 
     FSTAC [GSYM LEFT_FORALL_IMP_THM] THEN
     Q.PAT_ASSUM `!l'. P l'` (MP_TAC o Q.SPEC `l`) THEN 
     RWTAC [] THEN 
     METIS_TAC [RQ strict_linear_order_dom_rng_lem, get_l_stores_lem]]);

val lem2 = Q.prove (
`!s (x::s). (!y. y IN s ==> (x = y)) ==> (x = CHOICE s)`,
RWTAC [] THEN
METIS_TAC [UNIQUE_MEMBER_SING, CHOICE_SING]);

val lem3 = Q.prove (
`!s t. ~(s INTER t = {}) ==> CHOICE (s INTER t) IN s`,
RWTAC [] THEN
IMP_RES_TAC CHOICE_DEF THEN
FSTAC []);

val wsc_lem = Q.prove (
`!E r.
   r IN write_serialization_candidates_old E = write_serialization_candidates E r`,
RWTAC [write_serialization_candidates_old_def, write_serialization_candidates_def] THEN
RWTAC [Abbr `choices`,
       Abbr `per_location_store_set_linearisations`,
       Abbr `per_location_store_sets`] THEN
EQ_TAC THEN 
RWTAC [] THENL
[FSTAC [IN_BIGUNION] THEN 
     IMP_RES_TAC all_choices_thm THEN
     RWTAC [] THEN 
     FSTAC [strict_linearisations_def, strict_linear_order_def] THEN
     RWTAC [] THEN 
     FSTAC [SUBSET_DEF, DOM_def, RANGE_def] THEN
     METIS_TAC [],
 FSTAC [RRESTRICT_def, all_choices_def, strict_linearisations_def, BIGUNION] THEN
     RWTAC [] THEN
     FSTAC [GSYM RIGHT_EXISTS_AND_THM, GSYM LEFT_EXISTS_AND_THM, INTER_DEF] THEN
     RWTAC [lem1, LAMBDA_PROD] THEN
     POP_ASSUM (MP_TAC o Q.SPEC `{r | strict_linear_order r (get_l_stores E l)}`) THEN
     RWTAC [] THEN 
     METIS_TAC [],
 Q.EXISTS_TAC `{RRESTRICT r (get_l_stores E l) | l | T}` THEN 
     RWTAC [BIGUNION, RRESTRICT_def, LAMBDA_PROD] THENL
     [RWTAC [REXTENSION] THEN 
          EQ_TAC THEN 
          RWTAC [] THENL
          [RES_TAC THEN 
               Q.EXISTS_TAC `RRESTRICT r (get_l_stores E l)` THEN 
               RWTAC [RRESTRICT_def] THEN 
               METIS_TAC [get_l_stores_lem],
           RES_TAC THEN 
               FSTAC [RRESTRICT_def]],
      RWTAC [all_choices_def, strict_linearisations_def, GSYM RIGHT_EXISTS_AND_THM] THEN
          Q.EXISTS_TAC `\s. CHOICE (s INTER {RRESTRICT r (get_l_stores E l) | l | T})` THEN
          RWTAC [] THENL
          [RWTAC [Once EXTENSION] THEN
               EQ_TAC THEN
               RWTAC [GSYM RIGHT_EXISTS_AND_THM, strict_linearisations_def, INTER_DEF] THENL
               [Q.EXISTS_TAC `l` THEN
                    RWTAC [RRESTRICT_def] THEN
                    MATCH_MP_TAC (RQ lem2) THEN
                    RWTAC [] THEN
                    FSTAC [RRESTRICT_def, REXTENSION, LAMBDA_PROD] THEN1 
                    METIS_TAC [] THEN
                    Cases_on `?x y. (x,y) IN (RRESTRICT r (get_l_stores E l''))` THEN
                    FSTAC [RRESTRICT_def] THENL
                    [IMP_RES_TAC (RQ strict_linear_order_dom_rng_lem) THEN
                         FSTAC [] THEN
                         METIS_TAC [get_l_stores_lem],
                     FSTAC [strict_linear_order_def] THEN
                         METIS_TAC []],
                Q.EXISTS_TAC `l` THEN
                    RWTAC [RRESTRICT_def] THEN
                    MATCH_MP_TAC (GSYM (RQ lem2)) THEN
                    RWTAC [] THEN
                    FSTAC [RRESTRICT_def, REXTENSION, LAMBDA_PROD] THEN1 
                    METIS_TAC [] THEN
                    Cases_on `?x y. (x,y) IN (RRESTRICT r (get_l_stores E l'))` THEN
                    FSTAC [RRESTRICT_def] THENL
                    [IMP_RES_TAC (RQ strict_linear_order_dom_rng_lem) THEN
                         FSTAC [] THEN 
                         METIS_TAC [get_l_stores_lem],
                     FSTAC [strict_linear_order_def] THEN
                         METIS_TAC []]],
           MATCH_MP_TAC lem3 THEN
               RWTAC [Once EXTENSION] THEN
               FSTAC [RRESTRICT_def, GSYM RIGHT_EXISTS_AND_THM] THEN
               METIS_TAC []]]]);

val write_serialization_candidates_thm = Q.store_thm ("write_serialization_candidates_thm",
`write_serialization_candidates_old = write_serialization_candidates`,
RWTAC [FUN_EQ_THM] THEN
METIS_TAC [wsc_lem, SPECIFICATION]);

val rfc_lem = Q.prove (`
!E rfmap. rfmap IN reads_from_map_candidates_old E = reads_from_map_candidates E rfmap`,
RWTAC [reads_from_map_candidates_old_def, reads_from_map_candidates_def] THEN 
RWTAC [Abbr `reads_and_their_possible_writes`] THEN 
EQ_TAC THEN
RWTAC [SUBSET_DEF, DOM_def, RANGE_def] THEN 
RES_TAC THEN 
RWTAC [] THEN
FSTAC [GSPECIFICATION]);

val reads_from_map_candidates_thm = Q.store_thm ("reads_from_map_candidates_thm",
`reads_from_map_candidates_old = reads_from_map_candidates`,
RWTAC [FUN_EQ_THM] THEN
METIS_TAC [rfc_lem, SPECIFICATION]);

val _ = export_theory ();
