(**************************************************************************)
(*         x86 Multiprocessor Machine Code Semantics: HOL sources         *)
(*                                                                        *)
(*                                                                        *)
(*  Susmit Sarkar (1), Peter Sewell (1), Francesco Zappa Nardelli (2),    *)
(*  Scott Owens (1), Tom Ridge (1), Thomas Braibant (2),                  *)
(*  Magnus Myreen (1), Jade Alglave (2)                                   *)
(*                                                                        *)
(*   (1) Computer Laboratory, University of Cambridge                     *)
(*   (2) Moscova project, INRIA Paris-Rocquencourt                        *)
(*                                                                        *)
(*    Copyright 2007-2008                                                 *)
(*                                                                        *)
(*  Redistribution and use in source and binary forms, with or without    *)
(*  modification, are permitted provided that the following conditions    *)
(*  are met:                                                              *)
(*                                                                        *)
(*  1. Redistributions of source code must retain the above copyright     *)
(*     notice, this list of conditions and the following disclaimer.      *)
(*  2. Redistributions in binary form must reproduce the above copyright  *)
(*     notice, this list of conditions and the following disclaimer in    *)
(*     the documentation and/or other materials provided with the         *)
(*     distribution.                                                      *)
(*  3. The names of the authors may not be used to endorse or promote     *)
(*     products derived from this software without specific prior         *)
(*     written permission.                                                *)
(*                                                                        *)
(*  THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS    *)
(*  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED     *)
(*  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE    *)
(*  ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY       *)
(*  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL    *)
(*  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE     *)
(*  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS         *)
(*  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,          *)
(*  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING             *)
(*  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS    *)
(*  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.          *)
(*                                                                        *)
(**************************************************************************)

open HolKernel boolLib bossLib Parse;
open wordsTheory bit_listTheory listTheory pred_setTheory;


open x86_coretypesTheory (* ia32_monadtypesTheory*) ;


open utilTheory ;
open x86_typesTheory;
 
(* open ia32_monadtypesTheory; *)
open HolDoc;

val _ = new_theory "x86_lts_ops";


val _ = Hol_datatype ` lts_state = Leaf of value | Left of lts_state | Right of lts_state | Pair of lts_state => lts_state`;


(* for an lts from a single-processor instruction, it's convenient to track eip accesses so that we know where to find the next instruction *)

val _ = Define `(eip_tracked_lts : ('s,'a,lts_monad_visible_label) LTS -> address -> program_order_index -> (address # program_order_index #'s,'a,lts_monad_visible_label) LTS) lts eip_initial po_initial =
   <| states := { (eip,po,s) | eip IN UNIV /\ (po=po_initial) /\ s IN lts.states};
      initial := (eip_initial,po_initial,lts.initial);
      final := { ((eip,po_initial,s),x) | eip IN UNIV /\ (s,x) IN lts.final};
      trans := { ((eip,po_initial,s),l,(eip',po_initial,s')) | (s,l,s') IN lts.trans /\ 
            (!lmvl p v. ((l=Vis lmvl) /\ (lmvl.lmvl_action=Access R (Location_reg p RegEIP) v)) ==> ((eip=v) /\ (eip'=eip))) /\
            (!lmvl p v. ((l=Vis lmvl) /\ (lmvl.lmvl_action=Access W (Location_reg p RegEIP) v)) ==> (eip'=eip)) /\
            ( ( ~ (? lmvl p v d. (l = Vis lmvl) /\ (lmvl.lmvl_action=Access d (Location_reg p RegEIP) v))) ==> (eip'=eip))  (* frame *)
} |> `;
 

(* would it generally be more convenient to lift to transition relations _over_ LTSs? *)

val _ = Define `(eip_tracked_lts_initial : address -> (address # program_order_index # lts_state,unit,lts_monad_visible_label) LTS) eip =
   let s = (eip,0,Leaf 0w) in
      <| states := { s };
         initial := s;
         final := { (s,()) };
         trans := {} |> `;


val lts_parallel_def = Define `
  (lts_parallel: ('s1,'a1,'vl) LTS -> ('s2,'a2,'vl) LTS -> (('s1 # 's2), ('a1#'a2),'vl) LTS ) lts1 lts2 = 
    <| states := { (s1,s2) | s1 IN lts1.states /\ s2 IN lts2.states};
       initial :=  (lts1.initial,lts2.initial);
       final := { ((s1,s2),(x1,x2)) | (s1,x1) IN lts1.final /\ (s2,x2) IN lts2.final };
       trans := { ((s1,s2),Tau,(s1',s2)) | (s1,Tau,s1') IN lts1.trans /\ s2 IN lts2.states } UNION
                { ((s1,s2),Tau,(s1,s2')) | (s2,Tau,s2') IN lts2.trans /\ s1 IN lts1.states } UNION
                { ((s1,s2),l,(s1',s2')) | (s1,l,s1') IN lts1.trans /\ (s2,l,s2') IN lts2.trans /\ ~(l=Tau) } 
     |>`;

val traces_of_lts_def = Define `
   (traces_of_lts : ('s,'v,'vl) LTS -> ('s # (num -> (('vl label)#'s) option)) set) lts =
     { (x,t) | (x=lts.initial) /\ (!l' s'. (t 0 = SOME(l',s')) ==> (lts.initial,l',s') IN lts.trans) /\
                         (!i l' s'. (t (i+1) = SOME(l',s')) ==> ? l s. (t i = SOME(l,s)) /\ (s,l',s') IN lts.trans) }`;

val completed_traces_of_lts_def = Define `
   (completed_traces_of_lts : ('s,'v,'vl) LTS -> ('s # (num -> ((('vl label)#'s) option))) set) lts =
     { (x,t) | (x=lts.initial) /\ 
               (!l' s'. (t 0 = SOME(l',s')) ==> (lts.initial,l',s') IN lts.trans) /\
               ((t 0 = NONE) ==> ~ (? l' s'. (lts.initial,l',s') IN lts.trans)) /\
               (!i l' s'. (t (i+1) = SOME(l',s')) ==> ? l s. (t i = SOME(l,s)) /\ (s,l',s') IN lts.trans)  /\
               (!i l s. (t i = SOME(l,s)) ==> (t (i+1) = NONE) ==> ~ (? l' s'. (s,l',s') IN lts.trans))}`;


val states_of_trace_def = Define `
  (states_of_trace (trs : ('s # (num -> ((('vl label)#'s) option))) set) : 's set) =
     { s | ? n l tr. tr IN trs /\ ((SND tr) n = SOME (l,s)) } 
     UNION
     { FST tr | tr IN trs } `;

(*
  seqT_lts (parT_lts (read_mem_lts (a+0w)) (parT_lts (read_mem_lts (a+1w)) 
           (parT_lts (read_mem_lts (a+2w)) (read_mem_lts (a+3w)))))
       (\(x0,x1,x2,x3). constT_lts (bytes2word [x0;x1;x2;x3]))`;
*)


(*
val m_lts_def = Define ` m_lts = 
  <| 
  constT                        := constT_lts;  
  failureT			:= failureT_lts; 
  addT				:= addT_lts; 
  parT_unit			:= parT_unit_lts; 
  parT          		:= parT_lts;
  seqT          		:= seqT_lts; 
  lockT                       	:= lockT_lts;                       
  write_reg   			:= write_reg_lts  ;
  read_reg    			:= read_reg_lts   ;
  write_eip   			:= write_eip_lts  ;
  read_eip    			:= read_eip_lts   ;
  write_eflag 			:= write_eflag_lts;
  read_eflag  			:= read_eflag_lts ;
  read_m32    			:= read_m32_lts   ;
  write_m32   			:= write_m32_lts  
|>`;  
*)

(* a rewriter-friendly theorem *)

(*

val option_apply_def = Define `
  (option_apply NONE f = NONE) /\
  (option_apply (SOME x) f = f x)`;

val monad_simp_thm = store_thm("monad_simp_thm",
  ``(constT_lts x = \y. SOME (x,y)) /\ (failureT_lts = \y. NONE) /\  (lockT_lts s = s) /\
    (addT_lts q s = \y. option_apply (s y) (\t. SOME ((q,FST t),SND t))) /\
    (seqT_lts s f = \y. option_apply (s y) (\t. f (FST t) (SND t))) /\
    (parT_lts s t = \y. option_apply (s y) (\z. 
                    option_apply (t (SND z)) (\x. SOME ((FST z,FST x),SND x))))``,
  SRW_TAC [] [parT_lts_def,seqT_lts_def,failureT_lts_def,lockT_lts_def,addT_lts_def,constT_lts_def,FUN_EQ_THM]
  THEN Cases_on `s y` THEN POP_ASSUM MP_TAC THEN SRW_TAC [] [option_apply_def]
  THEN Cases_on `x` THEN POP_ASSUM MP_TAC THEN SRW_TAC [] [option_apply_def]
  THEN Cases_on `t r` THEN SRW_TAC [] [option_apply_def]
  THEN Cases_on `x` THEN SRW_TAC [] [option_apply_def]);
*)

val _ = export_theory ();
