(**************************************************************************)
(*         x86 Multiprocessor Machine Code Semantics: HOL sources         *)
(*                                                                        *)
(*                                                                        *)
(*  Susmit Sarkar (1), Peter Sewell (1), Francesco Zappa Nardelli (2),    *)
(*  Scott Owens (1), Tom Ridge (1), Thomas Braibant (2),                  *)
(*  Magnus Myreen (1), Jade Alglave (2)                                   *)
(*                                                                        *)
(*   (1) Computer Laboratory, University of Cambridge                     *)
(*   (2) Moscova project, INRIA Paris-Rocquencourt                        *)
(*                                                                        *)
(*    Copyright 2007-2008                                                 *)
(*                                                                        *)
(*  Redistribution and use in source and binary forms, with or without    *)
(*  modification, are permitted provided that the following conditions    *)
(*  are met:                                                              *)
(*                                                                        *)
(*  1. Redistributions of source code must retain the above copyright     *)
(*     notice, this list of conditions and the following disclaimer.      *)
(*  2. Redistributions in binary form must reproduce the above copyright  *)
(*     notice, this list of conditions and the following disclaimer in    *)
(*     the documentation and/or other materials provided with the         *)
(*     distribution.                                                      *)
(*  3. The names of the authors may not be used to endorse or promote     *)
(*     products derived from this software without specific prior         *)
(*     written permission.                                                *)
(*                                                                        *)
(*  THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS    *)
(*  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED     *)
(*  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE    *)
(*  ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY       *)
(*  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL    *)
(*  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE     *)
(*  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS         *)
(*  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,          *)
(*  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING             *)
(*  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS    *)
(*  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.          *)
(*                                                                        *)
(**************************************************************************)

open HolKernel boolLib bossLib Parse;
open wordsTheory bit_listTheory (* opmonTheory*);

open x86_coretypesTheory x86_astTheory x86_opsemTheory x86_seq_monadTheory x86_decoderTheory ;

open HolDoc;
val _ = new_theory "x86_";

(* ---------------------------------------------------------------------------------- *>

  Here the decoder from x86_decoderTheory is put together with x86_execute
  from x86_opsemTheory and the sequential monad from x86_seq_monadTheory.

<* ---------------------------------------------------------------------------------- *)

val iiid_dummy_def = Define `iiid_dummy = <| proc:=0; program_order_index:=0 |>`;

val x86_execute_some_def = Define `
  x86_execute_some i w s = option_apply (x86_execute iiid_dummy i w s) (\t. SOME (SND t))`;

val X86_NEXT_def = Define `
  X86_NEXT s = 
    let e = XREAD_EIP s in                                   (* read eip *)
    let xs = MAP THE (XREAD_MEM_BYTES 20 e s) in             (* read next 20 bytes *)
    let m = x86_decode_bytes xs in                           (* attempt to decode *)
      if m = NONE then NONE else                             (* if decoded fail, return NONE *)
        let (i,w) = THE m in                                 (* otherwise extract content *)
        let n = 20 - (LENGTH w DIV 8) in                     (* calc length of instruction *)
          if EVERY (\x. ~(x = NONE)) (XREAD_MEM_BYTES n e s) (* check that the memory is there *)
          then x86_execute_some i (n2w n) s else NONE        (* execute the instruction *)`; 


(* help to evaluate X86_NEXT *)

val X86_NEXT_THM = store_thm("X86_NEXT_THM",
  ``(x86_decode xs = SOME (i,w)) ==>
    (FOLDR APPEND [] (MAP w2bits (MAP THE (XREAD_MEM_BYTES 20 (XREAD_EIP s) s))) = xs) ==>
    (EVERY (\x. ~(x = NONE)) (XREAD_MEM_BYTES (20 - (LENGTH w DIV 8)) (XREAD_EIP s) s)) ==>
    (x86_execute iiid_dummy i (n2w (20 - (LENGTH w DIV 8))) s = SOME (tt,s')) ==>
    (X86_NEXT s = SOME s')``,
  SIMP_TAC std_ss [X86_NEXT_def,LET_DEF,XREAD_REG_def,x86_decode_bytes_def,
    x86_execute_some_def,option_apply_def]);


val _ = export_theory ();
