(***********************************************************************)
(*                                                                     *)
(*                           Objective Caml                            *)
(*                                                                     *)
(*            Xavier Leroy, projet Cristal, INRIA Rocquencourt         *)
(*                                                                     *)
(*  Copyright 1996 Institut National de Recherche en Informatique et   *)
(*  en Automatique.  All rights reserved.  This file is distributed    *)
(*  under the terms of the GNU Library General Public License, with    *)
(*  the special exception on linking described in file LICENSE-OCAML.  *)
(*                                                                     *)
(***********************************************************************)

(* $Id: agraphics.ml,v 1.503 2004/12/22 15:27:09 zappa Exp $
 *                                                                *
*** Copyright 2002-2004 The Acute Team

  Allen-Williams, Mair
  Bishop, Steven
  Fairbairn, Matthew
  Habouzit, Pierre [*]
  Leifer, James [*]
  Sewell, Peter
  Sjberg, Vilhelm
  Steinruecken, Christian
  Vafeiadis, Viktor
  Wansbrough, Keith
  Zappa Nardelli, Francesco [*]
  Institut National de Recherche en Informatique et en Automatique (INRIA)

  Contributions of authors marked [*] are copyright INRIA.

All rights reserved.

This file is distributed under the terms of the GNU Lesser General
Public License, with the special exception on linking described in
file NEW-LICENSE.

***
 * -=-- ---------------------------------------------------- --=- *)



(* A wrapper around the Ocaml Graphics module, to make it free of datatypes
   (for use in Acute).  Changes marked `A:', queries marked `XXX' *)

(* NB: nullary functions (constants) are not handled by Acute yet, because
   of the lack of module initialisation.  We thunkify them. *)

(* XXX don't know how this is handled *)
(*A: exception Graphic_failure of string *)

let open_graph : string -> unit
  = Graphics.open_graph

let close_graph : unit -> unit
  = Graphics.close_graph

let set_window_title : string -> unit
  = Graphics.set_window_title

let clear_graph : unit -> unit
  = Graphics.clear_graph

let size_x : unit -> int
  = Graphics.size_x

let size_y : unit -> int
  = Graphics.size_y

(*A: type color = int *) (* A: s/color/int *)

let rgb : int -> int -> int -> int(*A:color*)
  = Graphics.rgb

let set_color : int(*A:color*) -> unit
  = Graphics.set_color

let background : (*A:nullary*)unit -> int(*A:color*)
  = fun () -> Graphics.background

let foreground : (*A:nullary*)unit -> int(*A:color*)
  = fun () -> Graphics.foreground

let black : (*A:nullary*)unit -> int(*A:color*)
  = fun () -> Graphics.black
let white : (*A:nullary*)unit -> int(*A:color*)
  = fun () -> Graphics.white
let red : (*A:nullary*)unit -> int(*A:color*)
  = fun () -> Graphics.red
let green : (*A:nullary*)unit -> int(*A:color*)
  = fun () -> Graphics.green
let blue : (*A:nullary*)unit -> int(*A:color*)
  = fun () -> Graphics.blue
let yellow : (*A:nullary*)unit -> int(*A:color*)
  = fun () -> Graphics.yellow
let cyan : (*A:nullary*)unit -> int(*A:color*)
  = fun () -> Graphics.cyan
let magenta : (*A:nullary*)unit -> int(*A:color*)
  = fun () -> Graphics.magenta

let plot : int -> int -> unit
  = Graphics.plot

let plots : (int * int) list(*A:array*) -> unit
  = fun ps -> Graphics.plots (Array.of_list ps)

let point_color : int -> int -> int(*A:color*)
  = Graphics.point_color

let moveto : int -> int -> unit
  = Graphics.moveto

let rmoveto : int -> int -> unit
  = Graphics.rmoveto

let current_x : unit -> int
  = Graphics.current_x

let current_y : unit -> int
  = Graphics.current_y

let current_point : unit -> int * int
  = Graphics.current_point

let lineto : int -> int -> unit
  = Graphics.lineto

let rlineto : int -> int -> unit
  = Graphics.rlineto

let curveto : int * int -> int * int -> int * int -> unit
  = Graphics.curveto

let draw_rect : int -> int -> int -> int -> unit
  = Graphics.draw_rect

let draw_poly_line : (int * int) list(*A:array*) -> unit
  = fun ps -> Graphics.draw_poly_line (Array.of_list ps)

let draw_poly : (int * int) list(*A:array*) -> unit
  = fun ps -> Graphics.draw_poly (Array.of_list ps)

let draw_segments : (int * int * int * int) list(*A:array*) -> unit
  = fun ps -> Graphics.draw_segments (Array.of_list ps)

let draw_arc : int -> int -> int -> int -> int -> int -> unit
  = Graphics.draw_arc

let draw_ellipse : int -> int -> int -> int -> unit
  = Graphics.draw_ellipse

let draw_circle : int -> int -> int -> unit
  = Graphics.draw_circle

let set_line_width : int -> unit
  = Graphics.set_line_width

let draw_char : char -> unit
  = Graphics.draw_char

let draw_string : string -> unit
  = Graphics.draw_string

let set_font : string -> unit
  = Graphics.set_font

let set_text_size : int -> unit
  = Graphics.set_text_size

let text_size : string -> int * int
  = Graphics.text_size

let fill_rect : int -> int -> int -> int -> unit
  = Graphics.fill_rect

let fill_poly : (int * int) list(*A:array*) -> unit
  = fun ps -> Graphics.fill_poly (Array.of_list ps)

let fill_arc : int -> int -> int -> int -> int -> int -> unit
  = Graphics.fill_arc

let fill_ellipse : int -> int -> int -> int -> unit
  = Graphics.fill_ellipse

let fill_circle : int -> int -> int -> unit
  = Graphics.fill_circle

(*A: type image = Graphics.image *)
(* XXX can't handle this AFAICS (could refer to them by integer indices
   into an internal cache, but doubt we'll use this anyway so can't be bothered) *)

let transp : (*A:nullary*)unit -> int(*A:color*)
  = fun () -> Graphics.transp

(*A:
 * let make_image : int(*A:color*) list(*A:array*) list(*A:array*) -> image
 *   = Graphics.make_image
 *
 * let dump_image : image -> int(*A:color*) list(*A:array*) list(*A:array*)
 *   = Graphics.dump_image
 *
 * let draw_image : image -> int -> int -> unit
 *   = Graphics.draw_image
 *
 * let get_image : int -> int -> int -> int -> image
 *   = Graphics.get_image
 *
 * let create_image : int -> int -> image
 *   = Graphics.create_image
 *
 * let blit_image : image -> int -> int -> unit
 *   = Graphics.blit_image
 *)

(*A:
 * type status =  (* A: replace with tuple *)
 *   { mouse_x : int;
 *     mouse_y : int;
 *     button : bool;
 *     keypressed : bool;
 *     key : char; (* A: string *)
 *   }
 *
 * type event =  (* A: replace with integer index *)
 *     Button_down  (* 0 *)
 *   | Button_up    (* 1 *)
 *   | Key_pressed  (* 2 *)
 *   | Mouse_motion (* 3 *)
 *   | Poll         (* 4 *)
 *)

let wait_next_event : int(*A:event*) list -> (int*int*bool*bool*char)(*A:status*)
  = fun evl ->
    let st = Graphics.wait_next_event
        (List.map
           (fun n -> [|Graphics.Button_down; Graphics.Button_up; Graphics.Key_pressed; Graphics.Mouse_motion; Graphics.Poll|].(n))
           evl) in
    (st.Graphics.mouse_x, st.Graphics.mouse_y, st.Graphics.button, st.Graphics.keypressed, st.Graphics.key);;

let mouse_pos : unit -> int * int
  = Graphics.mouse_pos

let button_down : unit -> bool
  = Graphics.button_down

let read_key : unit -> char
  = Graphics.read_key

let key_pressed : unit -> bool
  = Graphics.key_pressed

let sound : int -> int -> unit
  = Graphics.sound

let auto_synchronize : bool -> unit
  = Graphics.auto_synchronize

let synchronize : unit -> unit
  = Graphics.synchronize

let display_mode : bool -> unit
  = Graphics.display_mode

let remember_mode : bool -> unit
  = Graphics.remember_mode
