(* -=-- ---------------------------------------------------- --=- *
 *                                                                *
 * Interface: Type checker support                                *
 *                                                                *
 * Version: $Id: tysupp.mli,v 1.512 2004/12/22 12:23:32 zappa Exp $
 *                                                                *
*** Copyright 2002-2004 The Acute Team

  Allen-Williams, Mair
  Bishop, Steven
  Fairbairn, Matthew
  Habouzit, Pierre [*]
  Leifer, James [*]
  Sewell, Peter
  Sjberg, Vilhelm
  Steinruecken, Christian
  Vafeiadis, Viktor
  Wansbrough, Keith
  Zappa Nardelli, Francesco [*]
  Institut National de Recherche en Informatique et en Automatique (INRIA)

  Contributions of authors marked [*] are copyright INRIA.

All rights reserved.

This file is distributed under the terms of the GNU Lesser General
Public License, with the special exception on linking described in
file NEW-LICENSE.

***
 * -=-- ---------------------------------------------------- --=- *)


open Ast
open Util

val h_eq : hash -> hash -> bool
val typ_eq : typ -> typ -> bool
val typ_eq0_with : tysubst -> internal_typname ITypnameMap.t -> internal_typname ITypnameMap.t -> typ -> typ -> bool
val typ_eq_with : tysubst -> typ -> typ -> bool
val k_eq : kind -> kind -> bool
val mnetn_eq : modname * external_typname -> modname * external_typname -> bool
val hetn_eq : hash * external_typname -> hash * external_typname -> bool
val xetn_eq : hash_or_modname * external_typname -> hash_or_modname * external_typname -> bool
val x_eq : hash_or_modname -> hash_or_modname -> bool
val xetn_mem_eqs : hash_or_modname * external_typname -> eqs -> bool
val lookup_eqs_xetn : eqs -> hash_or_modname * external_typname -> typ option
val s_eq : signature -> signature -> bool
val eqn_eq : eqn -> eqn -> bool
val canonicalise_eqs : eqs -> eqs
val eqs_eq : eqs -> eqs -> bool

val selfify_signature : hash_or_modname -> signature -> signature
val type_flatten_sign : signature -> signature
val type_flatten_str  : structure -> structure
val type_really_flatten_sign : hash_or_modname -> signature -> signature

val collect_args : expr -> (expr * expr list)
val apply_args : expr * expr list -> expr

val prim_collect_args : prim_expr -> (prim_expr * prim_expr list)
val prim_apply_args : prim_expr * prim_expr list -> prim_expr

val is_value_like : (prim_expr -> bool option) -> (bool * bool) -> eqs -> prim_expr -> bool
val isvalue : (bool * bool) -> eqs -> prim_expr -> bool

val collect_argtys : int -> typ -> (typ list * typ) option

val tTup : Ast.typ list -> Ast.typ
val tSum : Ast.typ list -> Ast.typ
val tFunc : Ast.typ -> Ast.typ -> Ast.typ
val eMod : Ast.modname * Ast.external_typname * Ast.typ -> Ast.eqn
val collect_argtys : int -> Ast.typ -> (Ast.typ list * Ast.typ) option

(* get type of expression without doing any actual typechecking.
   Useful in evaluator for preserving types *)

val typeof_C0 : Ast.con0 -> Ast.typ
val typeof_C1 : Ast.con1 -> (Ast.typ * Ast.typ)
val typeof_Op : Ast.op -> Ast.typ
val typeof_op_or_econst : op_or_econst -> typ
val info_of_op_or_econst : op_or_econst -> (typ list * typ)
val patty : pat -> typ
val matchty : (pat * 'a) list -> typ  (* mtch or prim_mtch *)
val sugared : prim_expr -> bool

val vc_subseteq_vc : Ast.version_constraint -> Ast.version_constraint -> bool
val vn_isin_vc : Ast.version -> Ast.version_constraint -> bool
val vn_h_satisfies_vc : Ast.version -> Ast.hash -> Ast.version_constraint -> bool

(* raises Bad_version_test if you apply it to a VCHashEqual version
constraint, or use any non-value forms.  The Ast doesn't match the
spec grammar here, so it's hard to be nicer *)

val tt : op -> int -> typ
val tt_inv : typ -> op -> typ


val lookup_typeenv_iident : typeenv -> internal_ident -> typ option
val lookup_typeenv_location : typeenv -> location -> typ option
val lookup_typeenv_modname : typeenv -> modname -> signature option
val lookup_typeenv_modname_ext : typeenv -> modname -> (signature * typeenv) option
val lookup_typeenv_modname_val : typeenv -> modname -> external_ident -> typ option option
val lookup_typeenv_modname_typ : typeenv -> modname -> external_typname -> kind option option
val lookup_typeenv_itypname : typeenv -> internal_typname -> kind option

val modname_of_typeenv_entry : typeenv_entry -> modname option

val iident_mem_typeenv : internal_ident -> typeenv -> bool
val location_mem_typeenv : location -> typeenv -> bool
val modname_mem_typeenv : modname -> typeenv -> bool
val itypname_mem_typeenv : internal_typname -> typeenv -> bool

(* make type environment *)

val emptytypeenv : typeenv
val  emptynametypeenv : nametypeenv
val addtypeenv : typeenv_entry -> typeenv -> typeenv
val mktypeenv : typeenv_list -> typeenv
val appendtypeenv : typeenv -> typeenv -> typeenv
val concattypeenv : typeenv list -> typeenv

val env0_of_defs : definitions -> typeenv
val env1_of_defs : definitions -> typeenv


val econst_env : typeenv
