/* ns_sockets_int.h
 *
 * $Id: ns_sockets_int.h,v 1.504 2004/12/22 12:23:34 zappa Exp $
 *
*** Copyright 2002-2004 The Netsem Team

    * Steve Bishop
    * Michael Compton
    * Matthew Fairbairn
    * Michael Norrish
    * Andrei Serjantov
    * Peter Sewell
    * Michael Smith
    * Keith Wansbrough

All rights reserved.

This file is distributed under the terms of the GNU Lesser General
Public License, with the special exception on linking described in
file NEW-LICENSE.

***
 *
*** Copyright 2002-2004 The Acute Team

  Allen-Williams, Mair
  Bishop, Steven
  Fairbairn, Matthew
  Habouzit, Pierre [*]
  Leifer, James [*]
  Sewell, Peter
  Sjberg, Vilhelm
  Steinruecken, Christian
  Vafeiadis, Viktor
  Wansbrough, Keith
  Zappa Nardelli, Francesco [*]
  Institut National de Recherche en Informatique et en Automatique (INRIA)

  Contributions of authors marked [*] are copyright INRIA.

All rights reserved.

This file is distributed under the terms of the GNU Lesser General
Public License, with the special exception on linking described in
file NEW-LICENSE.

***
 * -=-- ---------------------------------------------------- --=- */

#ifndef ns_sockets_int_h
#define ns_sockets_int_h

extern char *geterrmsg(char *dest, int errcode);

#if defined(SO_ACCEPTCON) && !defined(SO_ACCEPTCONN)
#define SO_ACCEPTCONN SO_ACCEPTCON
#endif

#ifndef WIN32
extern int min(int a, int b);
#endif

#ifdef NS_LOGGING
extern void delimit_print(char *dest, unsigned int destsize,
			 const unsigned char *buf, size_t len);
extern void print(char *str);
extern int calc_iovec_len(struct iovec *vec, size_t iovlen);
extern void iovec_print(char *buf, unsigned int buflen,
			struct iovec *vec, size_t iovlen);
extern void iovec_printtail(char *buf, unsigned int buflen,
			    struct iovec *vec, size_t iovlen,
			    unsigned int start);
extern char *ns_getcurrenttime_first(char *dest, int size);
extern char *ns_getcurrenttime_last(char *dest, int size);
#else /* !NS_LOGGING */
#define delimit_print(dest,destsize,buf,len) /*empty*/
#define print(s) /*empty*/
#define calc_iovec_len(vec,iovlen) 0
#define iovec_print(buf,buflen,vec,iovlen) /*empty*/
#define iovec_printtail(bug,buflen,vec,iovlen,start) /*empty*/
#define ns_getcurrenttime_first(dest,size) ""
#define ns_getcurrenttime_last(dest,size) ""
#endif /* NS_LOGGING */

#endif
