(* -=-- ---------------------------------------------------- --=- *
 *                                                                *
 * parsetools.mli                                                 *
 *                                                                *
 * Version: $Id: parsetools.mli,v 1.504 2004/12/22 12:23:32 zappa Exp $
 *                                                                *
*** Copyright 2002-2004 The Acute Team

  Allen-Williams, Mair
  Bishop, Steven
  Fairbairn, Matthew
  Habouzit, Pierre [*]
  Leifer, James [*]
  Sewell, Peter
  Sjberg, Vilhelm
  Steinruecken, Christian
  Vafeiadis, Viktor
  Wansbrough, Keith
  Zappa Nardelli, Francesco [*]
  Institut National de Recherche en Informatique et en Automatique (INRIA)

  Contributions of authors marked [*] are copyright INRIA.

All rights reserved.

This file is distributed under the terms of the GNU Lesser General
Public License, with the special exception on linking described in
file NEW-LICENSE.

***
 * -=-- ---------------------------------------------------- --=- *)

open Parsertypes

exception Wrapped_parse_error of string

type filename = string

val parse_compilation_unit_from_filename :  filename -> parser_state Ast.compilation_unit
val parse_compilation_unit_from_string : string -> parser_state Ast.compilation_unit

val parse_compiled_unit_from_filename : filename -> parser_state -> Ast.compiled_unit * parser_state
val parse_compiled_unit_from_uri :  Uri.uri -> parser_state -> Ast.compiled_unit * parser_state
val parse_compiled_unit_from_string : string -> parser_state -> Ast.compiled_unit * parser_state
val parse_marshalled_value_from_string :  string -> parser_state -> Ast.marshalled_value

