(* -=-- ---------------------------------------------------- --=- *
 *                                                                *
 * parser_hack_script_ml.ml                                       *
 *                                                                *
 * Version: $Id: parser_hack_script_ml.ml,v 1.503 2004/12/22 12:23:32 zappa Exp $
 *                                                                *
*** Copyright 2002-2004 The Acute Team

  Allen-Williams, Mair
  Bishop, Steven
  Fairbairn, Matthew
  Habouzit, Pierre [*]
  Leifer, James [*]
  Sewell, Peter
  Sjberg, Vilhelm
  Steinruecken, Christian
  Vafeiadis, Viktor
  Wansbrough, Keith
  Zappa Nardelli, Francesco [*]
  Institut National de Recherche en Informatique et en Automatique (INRIA)

  Contributions of authors marked [*] are copyright INRIA.

All rights reserved.

This file is distributed under the terms of the GNU Lesser General
Public License, with the special exception on linking described in
file NEW-LICENSE.

***
 * -=-- ---------------------------------------------------- --=- *)

open Str;;
open Sys;;
open Unix;;

exception Fatal of string;;

let _ =
 (* Accept filename from commandline where the token type lives *)
 let filename =
    let len = Array.length argv in
    if(len < 2) then
      raise(Fatal("Incorrect arguments: must specify a filename "))
    else
      Array.get argv 1
  in

  (* Create an input channel for the ml file *)
  let ml_fd = stdin in
  let ml_ch = in_channel_of_descr ml_fd in
  let ml_len = in_channel_length ml_ch in
  let ml_str = String.create ml_len in

  (* Input the ml file into a string buffer *)
  let _ = really_input ml_ch ml_str 0 ml_len in

  (* Do some global search and replaces *)
  let ml_str = global_replace (regexp "\\bParsing\\b") "Myparsing" ml_str in
  let ml_str = global_replace (regexp "\\bLexing\\b") "Mylexing" ml_str in
  let ml_str = global_replace (regexp "\\byyparse\\b") "yyparse envp" ml_str in
  let ml_str = global_replace
      (regexp "^\\(let \\)\\([a-z_][a-zA-Z_]*\\)\\( (lexfun\\b\\)")
      "and \\2 (envp : Myparsing.envp)\\3" ml_str in
  let ml_str = global_replace
      (regexp "\\bparser_env\\b") "yy_envp" ml_str in

(*  (* make the parser recursive *)
  let ml_str = global_replace
      (regexp "^let yyact =") "let rec yyact =" ml_str in
  let ml_str = global_replace
      (regexp "^let yytables =\\(.*\n\\(^[^;][^;].*\n\\)*\\);;")
      "let yytables =\\1  " ml_str in (* delete the ;; so that the trailer can mutually recurse with parser *)
  let ml_str = global_replace
      (regexp "^let yytables =") "and yytables =" ml_str in
  let ml_str = global_replace (regexp "^let yytables =") "and yytables =" ml_str in
*)

  let ml_str = global_replace
      (regexp "^let yytables =") "let rec yytables =" ml_str in

  (* delete the token type declaration (it will go in a separate file) *)
  let type_token_regexp =  regexp "^type token =\n\\(.+\n\\)*" in
  let ml_str = global_replace type_token_regexp "" ml_str in
  let ml_str = "type token = " ^ String.capitalize filename ^ ".token\n" ^ ml_str in

  let _ = close ml_fd in

  (* Write the modified files back out *)
  let ml_fd = stdout in
  let ml_ch = out_channel_of_descr ml_fd in
  let _ = output ml_ch ml_str 0 (String.length ml_str) in
  ();;

