(* -=-- ---------------------------------------------------- --=- *
 *                                                                *
 * Evaluator support code                                         *
 *                                                                *
 * Version: $Id: evalsupp.mli,v 1.514 2004/12/22 12:23:31 zappa Exp $
 *                                                                *
*** Copyright 2002-2004 The Acute Team

  Allen-Williams, Mair
  Bishop, Steven
  Fairbairn, Matthew
  Habouzit, Pierre [*]
  Leifer, James [*]
  Sewell, Peter
  Sjberg, Vilhelm
  Steinruecken, Christian
  Vafeiadis, Viktor
  Wansbrough, Keith
  Zappa Nardelli, Francesco [*]
  Institut National de Recherche en Informatique et en Automatique (INRIA)

  Contributions of authors marked [*] are copyright INRIA.

All rights reserved.

This file is distributed under the terms of the GNU Lesser General
Public License, with the special exception on linking described in
file NEW-LICENSE.

***
 * -=-- ---------------------------------------------------- --=- *)

open Ast

(* bracket optimisations *)
val maybe_col : eqs -> prim_expr * eqs * typ -> prim_expr
val maybe_col_eqeq : prim_expr * eqs * typ -> prim_expr
val maybe_cons_bs : eqs -> (eqs * typ) -> bracket_seq -> bracket_seq


(* esub_expr perform a simultaneous internal ident to term expression
substitution on an expression; doesn't go inside hashes. *)
val esub_expr : (esubst * tysubst) -> eqs -> prim_expr -> prim_expr

(* applying a bracket_seq *)
val apply_bs : bracket_seq -> prim_expr -> prim_expr

(* rewrite all closures in a definition *)
val def_flatten_all_closures : definition -> definition

(* rewrite all closures in an expression *)
val flatten_all_closures : eqs -> prim_expr -> prim_expr

(* rewrite all closures in an expression *)
val subst_and_flatten_all_closures : (esubst * tysubst) -> eqs -> prim_expr -> prim_expr


val size_of_prim_expr : prim_expr -> int

val free_names : prim_expr -> name_value list

val reachable_locs : prim_expr -> store -> location list

val evalcfresh : nameenv * expr -> nameenv * expr
val evalcfresh_str : nameenv * structure -> nameenv * structure
val evalcfresh_sdef : nameenv * source_definition -> nameenv * source_definition

val merge_nameenv : nameenv * nameenv -> nameenv

val get_typ : etysubst -> eqs -> typ -> typ
val get_val : etysubst -> eqs -> prim_expr -> prim_expr

