(* -=-- ---------------------------------------------------- --=- *
 *                                                                *
 * econst.mli                                                     *
 *                                                                *
 * Version: $Id: econst.mli,v 1.510 2004/12/22 12:23:31 zappa Exp $
 *                                                                *
*** Copyright 2002-2004 The Acute Team

  Allen-Williams, Mair
  Bishop, Steven
  Fairbairn, Matthew
  Habouzit, Pierre [*]
  Leifer, James [*]
  Sewell, Peter
  Sjberg, Vilhelm
  Steinruecken, Christian
  Vafeiadis, Viktor
  Wansbrough, Keith
  Zappa Nardelli, Francesco [*]
  Institut National de Recherche en Informatique et en Automatique (INRIA)

  Contributions of authors marked [*] are copyright INRIA.

All rights reserved.

This file is distributed under the terms of the GNU Lesser General
Public License, with the special exception on linking described in
file NEW-LICENSE.

***
 * -=-- ---------------------------------------------------- --=- *)

(* Notes on E_const

* The parser will automatically recognise the external forms of
  E_const constants if in a parser_mode containing Econsts_allowed.
  One should *not* put these in the ei_map of a parser_state

* The pretty printer will automatically recognise the internal forms
  of E_const constants and print them appropriately.  One should *not*
  put these in in the ei_map of a printer_state.

* Typechecking should do nothing special with respect to external
  constants with one exception: it uses Econst.econst_env, per the
  document.

* P: genlib has an econst_of_eident made up out of thin air that must
  match the parsed/prettyprinted form

*)

(* parsing and printing external constants *)
val ident_of_string : string -> Ast.internal_ident
(* can raise Not_found *)

val string_of_ident : Ast.internal_ident -> string
(* can raise Not_found *)

(* the arity of an external constant *)
val arity_of_ident : Ast.internal_ident -> int
(* can raise Not_found *)

(* the type of an external constant *)
val type_of_ident : Ast.internal_ident -> Ast.typ

(* the initial type external environment *)
val econst_env_list : Ast.typeenv_list

(* apply an external constant *)
val apply : Ast.internal_ident -> Ast.name_value -> Ast.prim_expr list ->  Ast.prim_expr
(* can raise Not_found or Wrong_number_of_arguments *)

(* ident is in Econst *)
val in_econst : Ast.internal_ident -> bool

(* A hack to get around OCaml's non-recursive module system
   Call from eval.ml before starting to do stuff *)
(* val register_eval : (Ast.nameenv -> Ast.esubst -> Ast.eqs -> Ast.exp_configuration -> Ast.exp_configuration * Ast.prim_exr) -> unit *)
