(* -=-- ---------------------------------------------------- --=- *
 *                                                                *
 * debug.ml                                                       *
 *                                                                *
 * Version: $Id: debug.ml,v 1.505 2004/12/22 12:23:31 zappa Exp $
 *                                                                *
*** Copyright 2002-2004 The Acute Team

  Allen-Williams, Mair
  Bishop, Steven
  Fairbairn, Matthew
  Habouzit, Pierre [*]
  Leifer, James [*]
  Sewell, Peter
  Sjberg, Vilhelm
  Steinruecken, Christian
  Vafeiadis, Viktor
  Wansbrough, Keith
  Zappa Nardelli, Francesco [*]
  Institut National de Recherche en Informatique et en Automatique (INRIA)

  Contributions of authors marked [*] are copyright INRIA.

All rights reserved.

This file is distributed under the terms of the GNU Lesser General
Public License, with the special exception on linking described in
file NEW-LICENSE.

***
 * -=-- ---------------------------------------------------- --=- *)

let safe_open_out to_outfile =
  let ch_out = match to_outfile, !Opts.output_filename_opt with
  | (false,_)
  | (_,None) -> stderr
  | (true,Some output_filename) -> open_out output_filename in
  ch_out

let out_chan = ref None

let get_out_chan = function () -> match (!out_chan) with
  None -> let ch = (safe_open_out true) in out_chan := Some ch; ch
| Some ch -> ch

let safe_close_out = function () -> let ch = get_out_chan () in if ch <> stderr then close_out ch

let safe_open_err to_outfile =
  let ch_out = match to_outfile, !Opts.err_filename_opt with
  | (false,_)
  | (_,None) -> stderr
  | (true,Some output_filename) -> open_out output_filename in
  ch_out

let err_chan = ref None

let get_err_chan = function () -> match (!err_chan) with
  None -> let ch = (safe_open_err true) in err_chan := Some ch; ch
| Some ch -> ch

let safe_close_err = function () -> let ch = get_err_chan () in if ch <> stderr then close_out ch




let print' cls string_cons =
  if !Opts.debug && List.mem cls !Opts.debugs then ( let ch_out = get_err_chan () in output_string ch_out ((string_cons ())^"\n") ; flush ch_out )
  else ()

let print string_cons =
  print' Opts.DBC_default string_cons

let print_string_really s =
  let ch_out = get_out_chan () in
  (output_string ch_out s; flush ch_out)




let dbgassert expr_cons =
  if (!Opts.debug) then  assert (expr_cons ())

let thread_exit_hook : (Ast.prim_expr option -> unit) ref = ref (function _ -> ())

(*
 * open Unix
 *
 * let print_times ()
 *   = let pt = times () in
 *     Printf.printf "Process times: U:%3.3fs S:%3.3fs Uc:%3.3fs Sc:%3.3fs\n"
 *       pt.tms_utime pt.tms_stime pt.tms_cutime pt.tms_cstime
 *)


