 
/*****************************************************************************/
/*
   Definitionen
*/

#define  GF_IMPL         1
#define  GF_INT          2
#define  GF_NAME         3
#define  TRUE            1
#define  FALSE           0

/*****************************************************************************/
/*
   Die Routine sucht die Optionen aus einer Kommandozeile und uebergibt
   sie in zugewiesenen Variablen, laesst aber alle anderen Parameter
   der Zeile in Takt, und zwar in der Art, wie man es bei C gewohnt ist.
   Return-Wert ist "TRUE", wenn alle Flags benutzt werden konnten.
 
   getflags (argc,argv,fmt,arglist)

   input : argc    -   Anzahl Strings in Befehlszeile
           argv    -   Pointer auf Strings
           fmt     -   Welche Flags sind bekannt z.B. "x,y=*,z=#,?"
                       x      <-- normales Flag
                       x=*    <-- Flag mit Stringeingabe
                       x=#    <-- Flag mit Integereingabe
           arglist -   Pointer auf Variable fuer die Rueckgabe
   return: TRUE    -   wenn alle Flags in der Zeile verwendet werden konnten
           FALSE   -   im anderen Fall

   moeglicher Aufruf:
   ------------------
   int  help ,
        bf   ,
        y    ,
        cf   ;
   char *p   ;

     if(!(getflags(&argc,&argv,"?,b,x=*,y=#,c",&help,&bf,&p,&y,&cf)))
       puts("Flags fehlerhaft !") ;
     else
       AUSWERTUNG_DER_FLAGS() ;

*/

getflags (argc,argv,fmt,arglist)
unsigned int *argc      ;
char         ***argv    ,
             *fmt       ;
unsigned int arglist    ;
{
char         flag[32]   ,
             *fmtstr    ;
unsigned int *pal       ;
short int    mode       ,
             EXTRFMT()  ;
int          consumed   ,
             *parg      ,
             stat       ,
             FINDFLAG() ;

  do
    {
      consumed = FALSE ;
      fmtstr = fmt ;
      pal = &arglist ;
      while (*fmtstr)
        {
          mode = EXTRFMT(flag,&fmtstr) ;
          parg = (int *)*pal++ ;
          if (FINDFLAG(argc,argv,mode,flag,parg))
            consumed = TRUE ;
          else
            {
              if (mode == GF_IMPL && *parg != 1)  /* Bad Flags --> FALSE */
                *parg = FALSE ;
            }
        }
    }
  while (consumed) ;
  if (FINDFLAG(argc,argv,GF_IMPL,"-",&stat) ||
      FINDFLAG(argc,argv,GF_IMPL,"+",&stat))
    return(FALSE) ;
  else
    return(TRUE) ;
}

/*****************************************************************************/
/*
   Ein Flag wird in der Liste gesucht
*/

FINDFLAG (argc,argv,mode,flag,parg)
unsigned int *argc      ;
char         ***argv    ;
short int    mode       ;
char         *flag      ;
int          *parg      ;
{
char         *arg       ,
             **av       ,
             *STRFIND() ;
unsigned int ac         ,
             argn       ;
int          stat       ;

  ac = *argc ;
  av = *argv ;
  argn = 0 ;
  while (!(int)(arg = STRFIND(*av,flag)) && argn < ac)
    {
      ++argn ;
      ++av ;
    }
  if ((int)(arg))
    {
      stat = TRUE ;
      switch (mode)
        {
          case GF_NAME:
            if (!*arg)
              {
                PACKARG(argc,argv,argn) ;
                arg = *av ;
              }
            *parg = (int) arg ;
            PACKARG(argc,argv,argn) ;
            break  ;
          case GF_INT:
            if (!*arg)
              {
                PACKARG(argc,argv,argn) ;
                arg = *av ;
              }
            *parg = atoi(arg) ;
            PACKARG(argc,argv,argn) ;
            break  ;
          case GF_IMPL:
            *parg = TRUE ;
            if (*arg)
              {
                *av = arg - 1 ;
                **av = '-' ;
              }
            else
              PACKARG(argc,argv,argn) ;
            break  ;
        }
    }
  else
    stat = FALSE  ;
  return(stat) ;
}

/*****************************************************************************/
/*
   Sucht ein Muster in einem String
*/

char *STRFIND (s,p)
char *s ,
     *p ;
{
  if (s == 0 || p == 0)
    return(FALSE) ;
  while (*s++ == *p++)
    if (*p == '\0')
      return(s) ;
  return(FALSE) ;
}

/*****************************************************************************/
/*
   Eine Formatanweisung wird extrahiert
*/

short int EXTRFMT (b,pfmt)
char      *b     ,
          **pfmt ;
{
char      *pb    ,
          *pf    ;
short int stat   ;

  pf = *pfmt ;
  pb = b ;
  if(*pf != '+')
    *pb++ = '-'  ;
  stat = GF_IMPL ;
  while (*pf != ',' && *pf != '\0')
    {
      switch (*pf)
        {
          case '*':
            stat = GF_NAME ;
            ++pf  ;
            break  ;
          case '#':
            stat = GF_INT ;
            ++pf  ;
            break  ;
          default:
            *pb++ = *pf++ ;
            break  ;
        }
    }
  *pb = '\0' ;
  *pfmt = (*pf==',') ? ++pf : pf ;
  return(stat) ;
}

/*****************************************************************************/
/*
   Loescht Argumente aus der Befehlszeile, die als Option erkannt wurden
*/
 
PACKARG (argc,argv,argn)
unsigned int *argc   ;
char         ***argv ;
unsigned int argn    ;
{
unsigned int ac      ;
char         **av    ;

  ac = *argc ;
  av = *argv ;
  if (ac)
    {
      while (argn < ac)
        {
          *(av+argn) = *(av+(argn+1)) ;
          ++argn ;
        }
      *argc = *argc - 1  ;
    }
}
