module Monad :
  sig
    type 'a t = Error of Camlp4.PreCast.Loc.t * string | Ok of 'a
    val return : 'a -> 'a t
    val ( >>= ) : 'a t -> ('a -> 'b t) -> 'b t
    val error_loc : Camlp4.PreCast.Loc.t -> string -> 'a t
    val error : string -> 'a t
    val error_at : Camlp4.PreCast.Loc.t -> 'a t -> 'a t
  end

type env = (Term.var * Term.tp * int) list

val lookup : Camlp4.PreCast.Loc.t -> env -> Term.var -> int -> (Combinators.ast * Term.tp) Monad.t

val check : env -> Term.exp -> Term.tp -> int -> Combinators.ast Monad.t

val synth : env -> Term.exp -> int -> (Combinators.ast * Term.tp) Monad.t

val elaborate :
  Term.exp -> Camlp4.PreCast.Ast.loc -> Camlp4.PreCast.Ast.expr


