open Camlp4.PreCast
open Elaborator
open Monad
open Grammar

let parsetype s = Gram.parse_string mtype Ast.Loc.ghost s
let parsexpr s = Gram.parse_string mexpr Ast.Loc.ghost s

let display s =
  let _loc = Loc.ghost in 
  Printers.OCaml.print_implem <:str_item<let _ = $elaborate (parsexpr s) _loc$>>

let display_ast t = 
  let _loc = Loc.ghost in 
  Printers.OCaml.print_implem <:str_item<let _ = $t$>>

let test_check env term tp j =
  let env = List.map (fun (x, tstr, i) -> (x, parsetype tstr, i)) env in
  let term = parsexpr term in
  let tp = parsetype tp in
  match check env term tp j with
  | Ok e -> display_ast (e "Dsl" Loc.ghost)
  | Error(loc, msg) -> failwith (Printf.sprintf "%s: %s" (Loc.to_string loc) msg)

let test_synth env term j =
  let env = List.map (fun (x, tstr, i) -> (x, parsetype tstr, i)) env in
  let term = parsexpr term in
  match synth env term j with
  | Ok (e,tp) -> display_ast (e "Dsl" Loc.ghost); tp
  | Error(loc, msg) -> failwith (Printf.sprintf "%s: %s" (Loc.to_string loc) msg)

