open(INFILE, shift @ARGV) or die "Can't open input file.";
$subcodes=1; # True if we want to print subfield marks
$fixfld=1; # True if we want to print fixed fields
$xml=0; # True if converting to MARCXML format

while(!eof(INFILE)) {
    read(INFILE, $leader, 24);
    print "\n";
    if(substr($leader, 6, 1) eq "x") {
	print "Holdings record:\n";
    }
    last unless($leader =~ /^\d{5,5}\w/);
    @entries=();
    $nentries=substr($leader, 12, 5);
    $nentries=($nentries-25)/12; # Total number of fields
    for($i=1; $i<=$nentries; $i++) {
	read(INFILE, $dir, 12); # Read directory entry
	($tag, $length, $start)=unpack("A3A4A5", $dir);
#	printf("%s %s %s\n", $tag, $length, $start);
	push @entries, [$tag, $length];
    }
    &printrecord;
    read(INFILE, $data, 2); # Scrap the record terminator
}

sub printrecord {
    my $fld;

    if($xml) {
	print "<record>\n";
	printf("<leader>%s</leader>\n", $leader);
	foreach $fld (@entries) {
	    &printfield_xml($fld);
	}
	print "</record>"
    } else {
        printf("LDR    %s\n", $leader);
	foreach $fld (@entries) {
	    &printfield($fld);
	}
    }
}

sub printfield {
    my($fld)=@_[0];

    read(INFILE, $data, $fld->[1]);
    substr($data, 0, 1)="";
    if($subcodes) {
        $data =~ s/\x1F/\$/g;
    } else {
	$data =~ s/\x1F[0-9a-z]/ /g;
    }
    if($fld->[0] le "009") {
	printf("%s    %s\n", $fld->[0], $data) if($fixfld);
    } else {
	($ind, $fdata)=unpack("a2A*", $data);
	printf("%s %2s %s\n", $fld->[0], $ind, $fdata);
    }
}

sub printfield_xml {
    my($fld)=@_[0];

    read(INFILE, $data, $fld->[1]);
    substr($data, 0, 1)="";
    $data =~ s/\x1F/\$/g;
    if($fld->[0] le "009") {
	printf("<controlfield tag=\"%3s\">", $fld->[0]);
	printf("%s</controlfield>\n", $data);
    } else {
	($ind, $fdata)=unpack("a2A*", $data);
	printf("<datafield tag=\"%3s\" ind1=\"%s\" ind2=\"%s\">\n",
	       $fld->[0], substr($ind, 0, 1), substr($ind, 1, 1));
	&printsubcodes($fdata);
	print "</datafield>\n";
    }
}

# Separate the the field data into subfields and output these in XML

sub printsubcodes {
    my($data)=@_[0];
    my $subcode, $i, $subf;

    substr($data, 0, 1)="";
    while(($i = index($data, "\$")) > -1) {
 	$subcode=substr($data, 0, 1);
	printf("<subfield code=\"%s\">", $subcode);
	$subf=substr($data, 1, $i-1);
	$subf =~ s/([^A-Z])\.$/\1/;
	$subf =~ s/^\((.*)\)?$/\1/;
	$subf =~ s/ ?[,:;\/]$//; # remove ISBD punctuation
	printf("%s</subfield>\n", $subf);
	substr($data, 0, $i+1)="";
    }
    $subcode=substr($data, 0, 1);
    printf("<subfield code=\"%s\">", $subcode);
    $subf=substr($data, 1);
    $subf =~ s/([^A-Z])\.$/\1/;
    $subf =~ s/^\((.*)\)$/\1/; # fewer options for final punctuation
    printf("%s</subfield>\n", $subf);
}
