// This program tries out various methods to reverse a word.
// Implemented in Cintcode BCPL by Martin Richards (c) Feb 2001

GET "libhdr"

LET start() = VALOF
{ LET t = TABLE //             Cintcode instruction executions
 // test data      result   rev  rev1 rev2 rev3 rev4 rev5 rev6 rev7
    #xFFFFFFFF, // FFFFFFFF 647   66  170  209  209  253  168   40 
    #x7FFFFFFF, // FFFFFFFE 647   66  173  213  213  253  168   40 
    #x87654321, // 84C2A6E1 647   66  165  237  237  253  168   40 
    #x7FF23456, // 6A2C4FFE 647   66  191  245  245  253  168   40 
    #x12345678, // 1E6A2C48 647   66  169  237  237  253  168   40 
    #x01234567, // E6A2C480 647   66  168  241  241  253  168   40 
    #x00123456, // 6A2C4800 647   66  171  245  245  253  168   40 
    #x00012345, // A2C48000 647   66  153  237  237  253  168   40 
    #x00001234, // 2C480000 647   66  142  229  229  253  168   40 
    #x00000123, // C4800000 647   66  132  225  225  253  168   40 
    #x00000012, // 48000000 647   66  118  217  217  253  168   40 
    #x00000001, // 80000000 647   66  111  213  213  253  168   40 
    #xF0F0F0F0, // 0F0F0F0F 647   66  220  273  273  253  168   40 
    #x80808080, // 01010101 647   66  132  225  225  253  168   40 
    #x40404040, // 02020202 647   66  132  225  225  253  168   40 
    #x20202020, // 04040404 647   66  132  225  225  253  168   40 
    #x10101010, // 08080808 647   66  136  225  225  253  168   40 
    #x0000FFFF, // FFFF0000 647   66  220  273  273  253  168   40 
    #x00001FFF, // FFF80000 647   66  199  261  261  253  168   40 
    #x00000000  // 00000000 647   66  104  209  209  253  168   40 

  LET w = 0
  LET k = 0
  LET res = 0

  writef("*nTest various implementations of rev*n*n")

  { w := !t
    t := t+1
    res := rev(w)
    writef("%x8 %x8", w, res)
    try(w, rev);  try(w, rev1); try(w, rev2); try(w, rev3)
    try(w, rev4); try(w, rev5); try(w, rev6); try(w, rev7)
    newline()
  } REPEATWHILE w

  writef("*n*nEnd of test*n")
  RESULTIS 0
}

AND try(w, f) BE
  writef(" %i3%c", instrcount(f, w), rev(w)=f(w) -> ' ', '#')

AND rev(w) = VALOF
{ LET res = 0
  LET bit = 1
  WHILE bit DO { res := res<<1 | w&1
                 bit, w := bit<<1, w>>1
               }
  RESULTIS res
}

AND rev1(w) = VALOF
{ w := (w & #xFFFF0000)>>16 | (w&#x0000FFFF)<<16
  w := (w & #xFF00FF00)>>8  | (w&#x00FF00FF)<<8
  w := (w & #xF0F0F0F0)>>4  | (w&#x0F0F0F0F)<<4
  w := (w & #xCCCCCCCC)>>2  | (w&#x33333333)<<2
  w := (w & #xAAAAAAAA)>>1  | (w&#x55555555)<<1
  RESULTIS w
}

AND rev2(w) = VALOF
{ LET m, a, b = 0, ?, ?
  b := #x00018000; a:=w&b; IF a & ((a&(a-1))=0) DO m := m + b
  b := #x00024000; a:=w&b; IF a & ((a&(a-1))=0) DO m := m + b
  b := #x00042000; a:=w&b; IF a & ((a&(a-1))=0) DO m := m + b
  b := #x00081000; a:=w&b; IF a & ((a&(a-1))=0) DO m := m + b
  b := #x00100800; a:=w&b; IF a & ((a&(a-1))=0) DO m := m + b
  b := #x00200400; a:=w&b; IF a & ((a&(a-1))=0) DO m := m + b
  b := #x00400200; a:=w&b; IF a & ((a&(a-1))=0) DO m := m + b
  b := #x00800100; a:=w&b; IF a & ((a&(a-1))=0) DO m := m + b
  b := #x01000080; a:=w&b; IF a & ((a&(a-1))=0) DO m := m + b
  b := #x02000040; a:=w&b; IF a & ((a&(a-1))=0) DO m := m + b
  b := #x04000020; a:=w&b; IF a & ((a&(a-1))=0) DO m := m + b
  b := #x08000010; a:=w&b; IF a & ((a&(a-1))=0) DO m := m + b
  b := #x10000008; a:=w&b; IF a & ((a&(a-1))=0) DO m := m + b
  b := #x20000004; a:=w&b; IF a & ((a&(a-1))=0) DO m := m + b
  b := #x40000002; a:=w&b; IF a & ((a&(a-1))=0) DO m := m + b
  b := #x80000001; a:=w&b; IF a & ((a&(a-1))=0) DO m := m + b

  RESULTIS w NEQV m
}

AND rev3(w) = VALOF
{ UNLESS ((w&#x00010000)=0)=((w&#x00008000)=0) DO w := w NEQV #x00018000
  UNLESS ((w&#x00020000)=0)=((w&#x00004000)=0) DO w := w NEQV #x00024000
  UNLESS ((w&#x00040000)=0)=((w&#x00002000)=0) DO w := w NEQV #x00042000
  UNLESS ((w&#x00080000)=0)=((w&#x00001000)=0) DO w := w NEQV #x00081000
  UNLESS ((w&#x00100000)=0)=((w&#x00000800)=0) DO w := w NEQV #x00100800
  UNLESS ((w&#x00200000)=0)=((w&#x00000400)=0) DO w := w NEQV #x00200400
  UNLESS ((w&#x00400000)=0)=((w&#x00000200)=0) DO w := w NEQV #x00400200
  UNLESS ((w&#x00800000)=0)=((w&#x00000100)=0) DO w := w NEQV #x00800100
  UNLESS ((w&#x01000000)=0)=((w&#x00000080)=0) DO w := w NEQV #x01000080
  UNLESS ((w&#x02000000)=0)=((w&#x00000040)=0) DO w := w NEQV #x02000040
  UNLESS ((w&#x04000000)=0)=((w&#x00000020)=0) DO w := w NEQV #x04000020
  UNLESS ((w&#x08000000)=0)=((w&#x00000010)=0) DO w := w NEQV #x08000010
  UNLESS ((w&#x10000000)=0)=((w&#x00000008)=0) DO w := w NEQV #x10000008
  UNLESS ((w&#x20000000)=0)=((w&#x00000004)=0) DO w := w NEQV #x20000004
  UNLESS ((w&#x40000000)=0)=((w&#x00000002)=0) DO w := w NEQV #x40000002
  UNLESS ((w&#x80000000)=0)=((w&#x00000001)=0) DO w := w NEQV #x80000001

  RESULTIS w
}

AND rev4(w) = VALOF
{ LET x = ?
  x := w&#x00018000; IF x - 2*(x&-x) < 0 DO w := w NEQV #x00018000
  x := w&#x00024000; IF x - 2*(x&-x) < 0 DO w := w NEQV #x00024000
  x := w&#x00042000; IF x - 2*(x&-x) < 0 DO w := w NEQV #x00042000
  x := w&#x00081000; IF x - 2*(x&-x) < 0 DO w := w NEQV #x00081000
  x := w&#x00100800; IF x - 2*(x&-x) < 0 DO w := w NEQV #x00100800
  x := w&#x00200400; IF x - 2*(x&-x) < 0 DO w := w NEQV #x00200400
  x := w&#x00400200; IF x - 2*(x&-x) < 0 DO w := w NEQV #x00400200
  x := w&#x00800100; IF x - 2*(x&-x) < 0 DO w := w NEQV #x00800100
  x := w&#x01000080; IF x - 2*(x&-x) < 0 DO w := w NEQV #x01000080
  x := w&#x02000040; IF x - 2*(x&-x) < 0 DO w := w NEQV #x02000040
  x := w&#x04000020; IF x - 2*(x&-x) < 0 DO w := w NEQV #x04000020
  x := w&#x08000010; IF x - 2*(x&-x) < 0 DO w := w NEQV #x08000010
  x := w&#x10000008; IF x - 2*(x&-x) < 0 DO w := w NEQV #x10000008
  x := w&#x20000004; IF x - 2*(x&-x) < 0 DO w := w NEQV #x20000004
  x := w&#x40000002; IF x - 2*(x&-x) < 0 DO w := w NEQV #x40000002
  x := w&#x80000001; IF x - 2*(x&-x) < 0 DO w := w NEQV #x80000001

  RESULTIS w
}

AND rev5(w) = #x8000 & (w>> 1) | (#x8000 & w)<< 1 |
              #x4000 & (w>> 3) | (#x4000 & w)<< 3 |
              #x2000 & (w>> 5) | (#x2000 & w)<< 5 |
              #x1000 & (w>> 7) | (#x1000 & w)<< 7 |
              #x0800 & (w>> 9) | (#x0800 & w)<< 9 |
              #x0400 & (w>>11) | (#x0400 & w)<<11 |
              #x0200 & (w>>13) | (#x0200 & w)<<13 |
              #x0100 & (w>>15) | (#x0100 & w)<<15 |
              #x0080 & (w>>17) | (#x0080 & w)<<17 |
              #x0040 & (w>>19) | (#x0040 & w)<<19 |
              #x0020 & (w>>21) | (#x0020 & w)<<21 |
              #x0010 & (w>>23) | (#x0010 & w)<<23 |
              #x0008 & (w>>25) | (#x0008 & w)<<25 |
              #x0004 & (w>>27) | (#x0004 & w)<<27 |
              #x0002 & (w>>29) | (#x0002 & w)<<29 |
              #x0001 & (w>>31) | (#x0001 & w)<<31

AND rev6(w) = VALOF
{ LET r = 0
  LET t = TABLE 0, 8, 4,12, 2,10, 6,14, 1, 9, 5,13, 3,11, 7,15
  FOR i = 1 TO 8 DO { r := r<<4 | t!(w&15); w := w>>4 }
  RESULTIS r
}

AND rev7(w) = VALOF
{ LET t = TABLE
       0,128, 64,192, 32,160, 96,224, 16,144, 80,208, 48,176,112,240,
       8,136, 72,200, 40,168,104,232, 24,152, 88,216, 56,184,120,248,
       4,132, 68,196, 36,164,100,228, 20,148, 84,212, 52,180,116,244,
      12,140, 76,204, 44,172,108,236, 28,156, 92,220, 60,188,124,252,
       2,130, 66,194, 34,162, 98,226, 18,146, 82,210, 50,178,114,242,
      10,138, 74,202, 42,170,106,234, 26,154, 90,218, 58,186,122,250,
       6,134, 70,198, 38,166,102,230, 22,150, 86,214, 54,182,118,246,
      14,142, 78,206, 46,174,110,238, 30,158, 94,222, 62,190,126,254,
       1,129, 65,193, 33,161, 97,225, 17,145, 81,209, 49,177,113,241,
       9,137, 73,201, 41,169,105,233, 25,153, 89,217, 57,185,121,249,
       5,133, 69,197, 37,165,101,229, 21,149, 85,213, 53,181,117,245,
      13,141, 77,205, 45,173,109,237, 29,157, 93,221, 61,189,125,253,
       3,131, 67,195, 35,163, 99,227, 19,147, 83,211, 51,179,115,243,
      11,139, 75,203, 43,171,107,235, 27,155, 91,219, 59,187,123,251,
       7,135, 71,199, 39,167,103,231, 23,151, 87,215, 55,183,119,247,
      15,143, 79,207, 47,175,111,239, 31,159, 95,223, 63,191,127,255

  RESULTIS t!(w     & 255) << 24 |
           t!(w>>8  & 255) << 16 |
           t!(w>>16 & 255) << 8  |
           t!(w>>24 & 255)
}
