/* A useful tool */
/* Copyright (c)1999 ADM (andrew@mcdonald.org.uk) */

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <string.h>
#include "stegfs.h"

int main(int argc, char *args[]) {

	struct stegfs_fs fs;
	struct stegfs_fs *fssys = &fs;
	struct inoblocks *inolist[15], *inob;
	int j,l;
	unsigned int *xkey;
	char *cipher;
	int level = 1;

	if (argc < 5 || argc > 6) {
		printf("Usage: %s device btabfile level passphrase [cipher]\n",
		       basename(args[0]));
		exit(1);
	}
	level = atoi(args[3]);
	cipher = argc==6 ? args[5] : "serpent";

	if (!open_fs(fssys, args[1], args[2], cipher, 0)) {
		printf("Failed to open device or file\n");
		exit(2);
	}
	get_skeys(fssys, level, args[4]);

	for(j=0; j<STEGFS_MAX_LEVELS-1; j++)
		inolist[j] = NULL;

	get_stegfs_inodes(fssys, inolist);

	for(l=0; l<level; l++) {
		printf("\nInodes in level %d:\n", l+1);
		xkey = (unsigned int *)(fssys->slkeys[l]);
		printf("key: %08x %08x %08x %08x\n",
		       xkey[0], xkey[1], xkey[2], xkey[3]);
		inob = inolist[l];
		while(inob) {
			printf("%lu:", inob->inode);
			for(j=0; j<STEGFS_MAX_INO_COPIES; j++)
				printf(" %u", inob->block[j]);
			printf("\n");
			inob = inob->next;
		}
	}

	exit(0);
}
