/* $Id: stegfs.h,v 1.9 1999/10/06 17:27:52 adm36 Exp adm36 $ */
#include <stdio.h>
#include <linux/fs.h>
#include <linux/stegfs_fs.h>
#include <ext2fs/ext2fs.h>

/*
struct stegfs_cipher {
	char *id;
	char * (*set_key) (const char *, const unsigned int);
	void (*encrypt) (const char *, const char *, char *);
	void (*decrypt) (const char *l_key, const char *, char *out_blk);
};
*/

#define RAND_DEV	"/dev/urandom"

struct inoblocks {

	ino_t inode;
        blk_t block[STEGFS_MAX_INO_COPIES];
        struct inoblocks * next;

};

struct stegfs_fs {

	ext2_filsys e2fs;
	FILE *btabfile;

	int slevel;
	char *slkeys[STEGFS_MAX_LEVELS-1];

	struct stegfs_cipher *cipher;
};

int open_fs(struct stegfs_fs *fs, char *fsname, char *btabname, char *cipher,
	    int newfs);
int close_fs(struct stegfs_fs *fs);
void get_skeys(struct stegfs_fs *fs, int level, char *pass);
int get_stegfs_inodes(struct stegfs_fs *fs, struct inoblocks **inolist);
void randomize_empties(struct stegfs_fs *fs);
u_int8_t isblockused(struct stegfs_fs *fs, blk_t blocknum);
u_int8_t stegfs_isblockused(struct stegfs_fs *fs, blk_t blocknum);
blk_t get_new_block(struct stegfs_fs *fs);
int get_new_inode_blocks(struct stegfs_fs *fs, int slevel, ino_t ino,
			 int numcopies, blk_t *blocks);
void put_btab(struct stegfs_fs *fs, blk_t bnum,
	      struct stegfs_btable *btab);
void get_btab(struct stegfs_fs *fs, blk_t bnum,
	      struct stegfs_btable *btab);
unsigned int stegfs_chksum(unsigned char * data, int size);
char *make_key(struct stegfs_fs *fs, int level, blk_t blocknum);

void encrypt_cbc(struct stegfs_fs *fs, int level, blk_t bnum,
		 char *data, int size, unsigned short iv);
void encrypt_cbc2(struct stegfs_fs *fs, int level, blk_t bnum,
		  char *data, char *data2, int size, unsigned short iv);
void decrypt_cbc(struct stegfs_fs *fs, int level, blk_t bnum,
		 char *data, int size, unsigned short iv);
void decrypt_cbc2(struct stegfs_fs *fs, int level, blk_t bnum,
		  char *data, char *data2, int size, unsigned short iv);

void encrypt_skey(struct stegfs_fs *, char *passwd, char *skey, char *skeyout);
void decrypt_skey(struct stegfs_fs *, char *passwd, char *skey, char *skeyout);

void encrypt_btab(struct stegfs_fs *fs, int slevel, blk_t bnum,
		  struct stegfs_btable *btab);
void encrypt_btab2(struct stegfs_fs *fs, int slevel, blk_t bnum,
		   struct stegfs_btable *btab, struct stegfs_btable *btab2);
void decrypt_btab(struct stegfs_fs *fs, int slevel, blk_t bnum,
		  struct stegfs_btable *btab);
void decrypt_btab2(struct stegfs_fs *fs, int slevel, blk_t bnum,
		   struct stegfs_btable *btab, struct stegfs_btable *btab2);
void mkroot(struct stegfs_fs *fs, int level, char *passwd, int ic, int bc);
