-------------------------------------------------------------------------------
--
-- Serpent Blockcipher
--
-- Copyright (c) 1998 Markus G. Kuhn <mkuhn@acm.org>. All rights reserved.
--
-- $Id: serpent.ads,v 1.2 1998-06-10 14:22:16+00 mgk25 Exp $
--
-------------------------------------------------------------------------------
--
-- This is the Ada95 reference implementation of the Serpent cipher
-- submitted by Ross Anderson, Eli Biham and Lars Knudson in June 1998 to
-- the NIST Advanced Encryption Standard (AES) contest. Please note that
-- this is a revised algorithm that is not identical to the old version
-- presented at the 1998 Fast Software Encryption Workshop.
-- <http://www.cs.technion.ac.il/~biham/Reports/Serpent/>
--
-- Compiled with GNAT 3.10p under Linux, this implementation encrypts and
-- decrypts with 20.8 Mbit/s on a 300 MHz Pentium II.
--
-------------------------------------------------------------------------------

with Interfaces; use Interfaces;

package Serpent is

   pragma Pure(Serpent);

   type Bytes is array (Integer range <>) of Unsigned_8;
   type Words is array (Integer range <>) of Unsigned_32;
   subtype Block is Bytes (0 .. 15);
   subtype Key   is Bytes (0 .. 31);
   subtype Key_Schedule is Words (-8 .. 131);

   procedure Prepare_Key (K : in Key; W : out Key_Schedule);

   procedure Encrypt (W : in Key_Schedule; Plaintext  :  in Block;
					   Ciphertext : out Block);

   procedure Decrypt (W : in Key_Schedule; Ciphertext :  in Block;
					   Plaintext  : out Block);

   procedure Selftest;

   Implementation_Error : exception;  -- raised if Selftest failed

end Serpent;
