

#ifndef _OSC_H
#define _OSC_H
int
osc_connect(struct in_addr in_addr, short port, char *instr);
int
osc_disconnect(void);
int
osc_write(char *line);
int
osc_instrument(char *line);
int
osc_read(char *buf, int buflen);
int
osc_parse_preamble(char *buf, long *format,
		   long *type, long *points, long *count,
                   double *xincrement, double *xorigin, double *xreference,
                   double *yincrement, double *yorigin, double *yreference);
void
osc_data_to_point(double x, double xinc, double xorig, double xref,
                  double y, double yinc, double yorig, double yref,
                  double *newx, double *newy);
int
osc_waveform_parse(char *buf, int buflen, char **data);
int
osc_waveform_to_text(char *buf, int buflen, unsigned char *data, int datalen,
                     double xinc, double xorig, double xref, double yinc,
                     double yorig, double yref);

#endif

