#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <stdio.h>
#include "osc.h"

void
main(void)
{
	struct in_addr	in_addr;
	struct hostent	*hostent;
	int	i;

	hostent = gethostbyname("infocalypse.al.cl.cam.ac.uk");
	if (!hostent) {
		perror("gethostbyname");
		exit(-1);
	}

	if (hostent->h_addrtype != AF_INET) {
		fprintf(stderr, "gethostbyname returned non-inet address\n");
		exit(-1);
	}

	if (hostent->h_length != sizeof(int)) {
		fprintf(stderr, "gethostbyname did not return an address\n");
		exit(-1);
	}

	in_addr.s_addr = *(int*)*hostent->h_addr_list;

	i = osc_connect(in_addr, 4500, "GPIB0::7::INSTR");
	if (i) {
		perror("osc_connect");
		exit(-1);
	}

	i = osc_write("*rst");
	if (i) {
		perror("osc_write");
		exit(-1);
	}
}
