{ ************************************************************************
  *                                                                      *
  *                         S e m a n t i c                              *
  *                                                                      *
  *                          G r a m m a r                               *
  *                                                                      *
  *                         A n a l y z e r                              *
  *                                                                      *
  ************************************************************************}
{5 Jan 88: replaced select->selector}
{To do--
  prohibit blanks embedded in NAME constants -- goes onto ldf badly
  provide switches to set listing options
  put names of character symbols into syName for error messages
  speed up compDoms?  (only store named domains)
  }
program ga(input,		{input from terminal}
	   output,		{output to terminal}
	   grammar,		{semantic grammar to read and analyze}
	   ldf,			{language description file to write}
	   listing);		{listing file to write}
const
    maxLineLen = 80;          {max length of source line}
    maxResword = 50;           {max number of reserved words}

    maxRuleContent = 600;     {max total symbols in all rules}
    maxItems = 100;            {max number of items in a kernel}

    accessMax = 30;            {nesting limit of structured bound variables}
    maxAttrs = 20;             {max number of attribute names in a rule}

    {**2****ga/ut common constants**************************************}
    tabChar = 11b;             {char code for tab}
    alfaleng = 15;              {max length of var names, keywords, etc.}
    defUname = 1;              {index of 'uniquename' in def}
    maxLambdaDepth = 31;      {nesting limit of lambda-expressions}
    maxDefs = 80;              {max number of definitions}
    maxDoms = 80;              {max number of domain definitions}
    maxSelectors = 60;         {max number of selectors for sum domains}

    maxKernels = 300;          {maximum number of kernels}
    maxNonterms = 80;          {max number of nonterminal symbols}
    maxTerms = 100;            {max number of terminal symbols}
    maxRules = 200;            {max number of semantic rules}
    {*******************************************************************}

type

    {**3****ga/ut common types******************************************}
    xKind = (namedX,attrX,varX,fixX,lambdaX,propX,caseX,
              injX,projX,isX,
              stringX,intX,boolX,botX,              {constants}
              leftX,rightX,notX,                     {unary ops}
              plusX,minusX,timesX,divX,modX,       {binary ops}
              ltX,eqX,applicX,pairX,
              condX,alterX,                           {ternary ops}
              nilX,int2X,stopX);                     {delimeters}

    xPost = packed
    record case kind: xKind of
                namedX,varX,injX,isX,boolX,
                intX: (int: 0..99999999);
                stringX,fixX,lambdaX: (ch1,ch2,ch3,ch4: char);
                int2X,attrX,caseX,projX: (int1,int2: 0..999)
    end;

    {*******************************************************************}


    alfa = packed array [1..alfaleng] of char;

    defIndex = 1..maxDefs;            {index into table of expressions}
    domIndex = 1..maxDoms;            {index into table of domains}
    selIndex = 1..maxSelectors;       {index into table of selectors}

    {lexical symbols; function names must be contiguous}
    symbol = (ifSy,thenSy,elseSy,fiSy,caseSy,ofSy,esacSy,  {keywords}
              letrecSy,letSy,inSy,fixSy,botSy,trueSy,falseSy,isSy,
              leftSy,rightSy,notSy,                {unary funcs}
              divSy,modSy,andSy,orSy,             {keyword operators}
              ltSy,gtSy,eqSy,leSy,geSy,neSy,
              cross,defSy,domSy,propagSy,forwSy,
              resolSy,attrSy,ruleSy,nonassocSy,
              unspecSy,withSy,endSy,nameSy,       {last of the keywords}
              number,stringSy,star,
              lParen,rParen,lBrack,rBrack,lambda,dot,
              equals,lAngle,rAngle,arrow,semicolon,
              colon,comma,plus,minus,bar,eofSy,illCharSy);
    stdFunc = symbol;      {standard functions}

    errorMessage = (illegalChar,wrongSymbol,undeclIdent,
                     noSemicolon,unmatchedQuotes,
                     factorExpected,notAFunction,notASum,notAProduct,
                     notEqDomain,noSuchDomain,
                     domainMismatch,redefinition,attrNum,notDefining,
                     illegalWith,notASelector,
                     wrongSelector,noSuchNonterm,
                     globalErrs,       {separator......}
                     nameTooLong,noDigits,noSuchSym,badTerminal,
                     noStrings,unreachable,conflict,
                     forwRef,lineTooLong,noEndToken);

    expression = ^expNode; {nil represents forward-defined expressions}
    caseList = ^caseNode;
    domain = ^domNode;     {nil represents forward or standard domains}
    summandList = ^summandNode;
    nameTree = ^nameNode;
    attrList = ^attrNode;

    {kinds of defining attributes:
      left-hand-side inherited, right-hand-side synthesized, pseudo}
    attrKind = (lhsAttr,rhsAttr,pseudoAttr);

    constKind = (bot,            {bottom element of domain in lattice}
                  int,            {integer constant, a number}
                  bool,           {boolean constant, true or false}
                  string);        {string constant, a string of characters}

    valueType = record   {representation of constant values}
                     case kind: constKind of
                          int: (i: integer);
                          bool: (b: boolean);
                          string: (s: alfa)
                 end;

    boundVar = packed record name: nameTree; dom: domain end;


    {kinds of expressions}
    expKind = (namedExp,      {reference to defined expression}
                attribute,      {reference to a defining attribute of a rule}
                variable,       {reference to bound var by depth, 0 = local}
                constant,       {constant value}
                fixExp,        {fixedpoint; fix x.y denotes fix(\x.y)}
                lambdaExp,     {abstraction of the body over the bound var}
                applic,         {application of an operator to an operand}
                cond,           {conditional expression}
                caseExp,       {case expression for sum domains}
                pair,           {ordered pair of exprs; element of product}
                unOp,          {unary operator applied to argument}
                binOp,         {infix operator applied to arguments}
                alterExp,      {alteration of function at a point}
                inject,         {injection from summand to sum domain}
                project,        {projection from sum to summand domain}
                isExp);        {test that sum belongs to specified summand}

    expNode = packed
    record  {representation of lambda-expressions}
        dom: domain;          {domain of the expression}
        case kind: expKind of
             namedExp: (di: defIndex);
             attribute: (atKind: attrKind; offset: integer);
             variable: (depth: integer);
             constant: (v: valueType);
             fixExp,lambdaExp:
             (bv: boundVar; body: expression);
             applic: (rator,rand: expression);
             cond: (ifExp,thenExp,elseExp: expression);
             caseExp: (index: expression; cases: caseList);
             pair: (l,r: expression);
             unOp: (uop: stdFunc; u1: expression);
             binOp: (bop: stdFunc; b1,b2: expression);
             alterExp: (t1,t2,t3: expression);
             inject,project,
             isExp:(si: selIndex; silent: boolean; exp: expression)
    end;

    {the silent flag helps prevent error message cascades in the universal
    translator.  silent is true on projections for which a constraint checks
    that the exp has the correct tag si.  if the exp has the wrong tag, then
    the constraint will trigger the error message, but not the projection.  the
    projection will still produce bottom, but the 'silent' version errorExp.
    silent is true only on projections generated implicitly when an injection
    appears in a defined position in a sementic rule (procedure defineAttrs).
    }

    caseNode = packed record  {component of a case expression}
                           next: caseList;
                           si: selIndex;
                           bv: boundVar;
                           body: expression
                       end;


    {kinds of domains}
    domKind = (namedDom,      {reference to defined domain}
                sum,            {sum of several domains}
                prod,           {product of a pair of domains}
                func);          {continuous functions from domain to range}

    domNode = record    {representation of domain}
                   case kind: domKind of
                        namedDom: (di: domIndex);
                        sum: (s: summandList);
                        prod: (l,r: domain);
                        func: (dom,range: domain)
               end;

    summandNode = record   {component of sum domain}
                       next: summandList;
                       si: selIndex;
                       summand: domain
                   end;

    nameNode = record    {'name' of list-structured variable}
                    case leaf: boolean of
                         true: (name:alfa);
                         false: (l,r: nameTree)
                end;

    {attributes of a nonterminal symbol}
    attrNode = record next: attrList; dom: domain; inher: boolean end;

    {binary trees for symbol tables}
    symbolTree = ^treeNode;
    treeNode = record name: alfa;  idx: integer; left,right: symbolTree end;

var
    optListAttrs,listStates: boolean;        {options}


    {variables for 'nextChar'}
    ch: char;                           {the current character}
    endOfLine,                        {end of current line}
    endOfFile: boolean;               {end of source file}


    {the current input line}
    line: record
              count,                    {number of lines so far}
              prevLen,                 {length of previous line}
              col,                      {column last scanned}
              len: integer;             {length of current line}
              prev,                     {previous line}
              buf: packed               {current line}
              array [1..maxLineLen] of char
          end;


    {result variables from scanner 'nextSy'}
    sy: symbol;         {current symbol}
    numVal: integer;   {value of last-scanned number}
    stringVal, varName: alfa;  {last string, variable}

    inDoms,               {currently parsing domain definitions}
    forwAttrs,            {allow forward references to attribute variables}
    listSource: boolean;  {list the source as it is read in}

    lastRuntime,firstRuntime: integer;        {last value of runtime}


    ok: boolean;   {no errors so far in current command}
    err: record
             count: integer;
             {arguments for messages}
             name: alfa; dom1,dom2: domain; sy: symbol; int: integer
         end;

    {variables for symbolTree}
    tree: record
              left: boolean;          {last branch was to left}
              last: symbolTree       {last non-nil tree}
          end;

    {table of reserved words}
    reswordTree: symbolTree;
    reswordCount: 0..maxResword;
    resword: array [1..maxResword] of record name: alfa; sy: symbol end;

    syName: array [symbol] of alfa;    {printing names for all symbols}

    {table of definitions of lambda-expressions}
    defTree: symbolTree;
    forwCount,                {forward-declared}
    defCount: 0..maxDefs;
    def: array [defIndex] of
    record
        name: alfa;             {name of the expression}
        pending: boolean;       {forward-declared and awaiting definition}
        dom: domain;            {domain of the expression; value may be nil}
        value: expression       {expression it is defined to be}
    end;



    {table of domain definitions}
    domTree: symbolTree;
    preDomCount,              {number of predefined domains}
    domCount: 0..maxDoms;     {total number of domains}
    domn: array [domIndex] of packed
    record
        name: alfa;             {name of the domain}
        value: domain;          {the domain it is defined to be}
        pending,                {forward-declared and awaiting definition}
        propagate: boolean      {expand functions over this domain}
    end;



    {table of selectors for sum domains}
    selectTree: symbolTree;
    selectCount: 0..maxSelectors;
    selector: array [selIndex] of
    packed record name: alfa; summand,sum: domain end;



    {named components of attributes used in the current rule}
    attrCount: integer;
    attr: array [1..maxAttrs] of
    record name: alfa; value: expression; dom: domain end;



    {pre-defined expressions and domains}
    errorX: expression;        {dummy value for invalid expressions}
    errorDom: domain;          {dummy domain for patching errors}
    intDom,boolDom,stringDom,voidDom: domain;  {predefined domains}
    boolExp: array [boolean] of expression;  {true and false}

    voidBv: boundVar;     {the bound var 'void'}
    voidExp: expression;   {initialized to bot[void]}
    {empty cases are represented using the domain void, with the single
      element bot[void].  the following syntactic sugar exists:
      the summand [void] need not be written in a case domain.
      the bound variable [void] need not be written in a case expression.
      the expression [bot[void]] need not be written in an injection.
      printout of expressions and domains omits the same void items.}


    {Additional input and output files}
    grammar,			{the semantic grammar being analyzed}
    listing: text;		{listing of errors, etc.}



    {Language Description File for Universal Translator}
    ldf: file of xPost;   
    {format is as follows:
      number of domains
      name of domain 1; ... ; name of domain n

      number of selectors
      name of selector 1; ... ; name of selector n

      number of entries in forward part
      number of definitions
      name, value of def 1; ... ; name, value of def n

      number of nonterminals
      nonterm 1; ... ; nonterm n

      rule 1 semantics; ... ; rule n semantics
      stop; number of rules

      (after this step the rules are sorted to facilitate parser construction)

      rule 1' info; ... ; rule n' info            (using new order)

      number of lalr(1) states
      lalr(1) action table
      terminal goto table (operands of actions)
      nonterminal goto table

      number of terminals
      terminal 1; ... ; terminal n
      <eof>



      *where each nonterminal has the format:
      name of nt
      number of inherited attributes
      number of synthesized attributes


      *each rule semantics entry has the format:
      number of applied exps for rule
      applied expression 1; ... ; applied expression n
      number of pseudo attributes for rule
      value of attr 1; ... ; value of attr n
      number of constraints for rule
      constraint 1; ... ; constraint n
      *note: each expression above is followed by the position in the rule
      of the symbol containing it.

      *each rule info entry has the format:
      rule length; rule number; rewriting symbol


      *each parse table has the format:
      (row width, row count); state->row map; row1; ... ; row n

      *each expression is represented in postfix and is followed by
      the index of its domain in domn -- zero if the domain has no name.
      }


procedure printDom(var f: text; dom: domain);forward;
procedure error(msg: errorMessage); forward;



function min(i,j: integer): integer;
    begin if i<j then min := i
          else min := j
    end;



function max(i,j: integer): integer;
    begin if i>j then max := i
          else max := j
    end;



procedure pointError(var f: text; col: integer);
    {point at an error in the desired column of the current line}
    var i,c: integer;
    begin
    c := 0;          {space skipped by tabs}
    for i := 1 to col-1 do
        if line.buf[i] = chr(tabChar) then c := 8* (1 + c div 8)
        else c := c+1;
    if c>0 then write(f, ' ': c);
    writeln(f, '^')
    end {pointError};



procedure error { (msg: errorMessage) };
    {print an error message. errors may be syntactic, semantic, or internal.
      don't print message unless this is the first for this command or this is
      a 'global error'.}


    procedure printMsg(var f: text; printLine: boolean);



        procedure printSy(s: symbol);
            begin if s < nameSy then writeln(f,syName[s])
            end;

        begin
        with line do begin
            if printLine then begin
                writeln(f, prev:prevLen);
                writeln(f, buf:len)
                end;
            pointError(f,col-2)
            end;
        case msg of
            illegalChar: writeln(f, 'illegal character ',ch);
            nameTooLong: writeln(f, '15 characters maximum');
            noDigits: writeln(f, 'no digits allowed here: ',err.name);
            wrongSymbol: begin writeln(f, 'another symbol expected ');
                printSy(err.sy) end;
            undeclIdent:
                writeln(f, 'undeclared identifier in factor ',err.name);
            noSemicolon: begin writeln(f, 'command improperly terminated ');
                printSy(err.sy) end;
            unmatchedQuotes: writeln(f, 'unmatched quotes');
            lineTooLong: writeln(f, 'line too long -- truncated');
            factorExpected: writeln(f, 'factor expected');
            notAFunction: begin
                writeln(f, 'function required here'); printDom(f, err.dom1);
                writeln(f)
                end;
            notASum: begin
                writeln(f, 'sum domain required here'); printDom(f, err.dom1);
                writeln(f)
                end;
            notAProduct: begin
                writeln(f, 'product domain required here');
                printDom(f, err.dom1); writeln(f)
                end;
            notEqDomain: begin
                writeln(f, 'equality undefined for this domain');
                printDom(f,err.dom1); writeln(f)
                end;
            noSuchDomain: writeln(f, 'no such domain ', err.name);
            domainMismatch: begin
                writeln(f, 'domain mismatch');
                printDom(f, err.dom1); writeln(f);
                printDom(f, err.dom2); writeln(f)
                end;
            redefinition: writeln(f, 'illegal redefinition ',err.name);
            attrNum: writeln(f, 'wrong number of attributes');
            notDefining: writeln(f, 'illegal in a defining position');
            illegalWith: writeln(f, 'with depends on other withs');
            notASelector:
                writeln(f, 'not a selector of a sum domain ',err.name);
            wrongSelector: writeln(f, 'wrong selector for case');
            noSuchNonterm:
                writeln(f, 'no such nonterminal in grammar ',err.name);
            noSuchSym: writeln(f, 'no such symbol in grammar ',err.name);
            badTerminal: writeln(f, 'illegal terminal symbol ');
            noStrings:
                writeln(f, 'no strings generated by nonterminal ',err.name);
            unreachable: writeln(f, 'unreachable nonterminal ', err.name);
            conflict: writeln(f, 'unresolvable conflict in kernel ',err.int:1);
            forwRef: writeln(f, 'unresolved forward reference to ',err.name);
            noEndToken: writeln(f, 'missing final end token')
            end {case};
        end {printMsg};

    begin
    if ok or (msg>globalErrs) then begin
        err.count := err.count+1;
        ok := false;  
        printMsg(listing, not listSource);
        printMsg(output, true);
        writeln(listing,'***********************************************')
        end;
    {erase the arguments so they don't appear in later messages}
    with err do begin dom1 := nil; dom2 := nil;
        name := '               '; sy := eofSy end
    end {error};



procedure treeSearch(t: symbolTree; name: alfa; var idx: integer);
    {look up the 'name' in the tree 't'.  return its 'idx' if found else 0.
      'left' and 'last' tell where in tree to insert new node for 'name'.}
    begin
    idx := 0; tree.last := nil;
    with tree do
        while t <> nil do begin
            last := t;
            if name < t^.name then begin t := t^.left; left := true end
            else if name > t^.name then begin t := t^.right; left := false end
            else begin idx := t^.idx; t := nil end
            end {while}
    end {treeSearch};



procedure treeInsert(var t: symbolTree; name: alfa; idx: integer);
    {insert a new name into the tree, using information in 'tree'
      that was set up by a previous call to 'treeSearch'}
    var next: symbolTree;
    begin
    new(next);
    next^.name := name; next^.idx := idx;
    next^.left := nil;  next^.right := nil;
    with tree do
        if t = nil then t := next
        else if left then last^.left := next
        else last^.right := next
    end {treeInsert};



procedure treeEnter(var t: symbolTree; name: alfa; idx: integer);
    {enter an element into a tree.  signal error if already there.}
    var idx0: integer;
    begin
    treeSearch(t,name,idx0);
    if idx0<>0 then begin err.name := name; error(redefinition) end
    else treeInsert(t,name,idx)
    end {treeEnter};



procedure treeLookup(t: symbolTree; name: alfa; var idx: integer;
                      msg: errorMessage);
    {look up a name in a tree.  issue an error message if not there,
      and set idx:=1 in order to avoid subscript errors later.}
    begin
    treeSearch(t,name,idx);
    if idx=0 then begin err.name := name; error(msg); idx:=1 end
    end {treeLookup};



procedure lookupAttr(name: alfa; var i: integer);
    {look up a nonterminal symbol}
    begin
    attr[attrCount+1].name := name;
    i := 1; while attr[i].name <> name do i := i+1
    end {lookupAttr};



procedure checkNoDigits(name: alfa);
    {check that the name contains no digits}
    var i: integer;  dig: boolean;
    begin
    dig := false;
    for i := 1 to alfaleng do dig := dig or (name[i] in ['0'..'9']);
    if dig then begin err.name := name; error(noDigits) end
    end {checkNoDigits};



procedure readLine(var f: text);
    {read another source line}
    begin
    endOfFile := eof(f);
    with line do begin
        prev := buf;  prevLen := len;  count := count+1;
        buf :=
        '                                                                                ';
        col := 1;
        if eof(f) then len := maxLineLen
        else begin
            len := 1;
            while not eoln(f) and not eof(f) do begin
                if len <= maxLineLen then buf[len] := f^;
                get(f); len := len+1
                end;
            readln(f);
            if len > maxLineLen then begin
                len := maxLineLen;
                error(lineTooLong)
                end
            end;
        if listSource then writeln(listing,buf:len)
        end;
    {line.len is one greater than actual input line}
    end {readLine};



procedure nextChar;
    {read the next character from the line buffer}
    begin
    if line.col > line.len then readLine(grammar);
    ch := line.buf[line.col]; line.col := line.col+1;
    endOfLine := line.col > line.len;
    if ord(ch) = tabChar then ch := ' '        {change tabs to blanks}
    else if ('A' <= ch) and (ch <= 'Z') then    {translate to lower case}
        ch := chr(ord(ch) + ord('a') - ord('A'))
    else if ch < ' ' then begin ch := ' ';  error(illegalChar) end
    end {nextChar};



procedure skipLine;
    {skip the rest of the line (for comment processing) }
    begin line.col := line.len+1; nextChar end {skipLine};



procedure nextSy;
    {lexical scanner.}



    procedure scanWord;
        {scans reserved words and variables}
        var i: integer;  buf: alfa;
        begin
        i := 0;  buf := '               ';
        repeat
            i := i+1;
            if i <= alfaleng then buf[i] := ch;
            nextChar
        until not (ch in ['a'..'z','0'..'9','_']);
        if i > alfaleng then error(nameTooLong);
        varName := buf;
        treeSearch(reswordTree,buf,i);
        if i=0 then sy := nameSy
        else sy := resword[i].sy
        end {scanWord};



    procedure scanString;
        {strings are enclosed in quotes and may not cross line boundaries.}
        {quotes in a string must be written twice;  "a""b" is the string a"b }
        var i: integer;  buf: alfa;  endOfString: boolean;
        begin
        i := 0;  buf := '               ';
        nextChar;  endOfString := false;
        while not (endOfString or endOfFile or endOfLine) do begin
            if ch = '"' then begin
                nextChar;  endOfString := ch <> '"'
                end;
            if not endOfString then begin
                i := i+1;
                if i <= alfaleng then buf[i] := ch;
                nextChar
                end
            end;
        if i > alfaleng then error(nameTooLong);
        if not endOfString then error(unmatchedQuotes);
        stringVal := buf;
        sy := stringSy
        end {scanString};



    procedure scanNumber;
        var i: integer;
        begin
        sy := number;
        i := 0;
        repeat i := 10*i + (ord(ch)-ord('0')); nextChar
        until not (ch in ['0'..'9']);
        numVal := i
        end {scanNumber};



    procedure charSy(s: symbol);
        begin
        sy := s; nextChar
        end {charSy};

    begin
    varName := '               ';
    repeat
        while not endOfFile and (ch = ' ') do nextChar;
        while ch = '#' do skipLine   {'#' starts comment to end-of-line}
    until endOfFile or not (ch in [' ', '#']);
    case ch of
        ' ': sy := eofSy;
        'a','b','c','d','e','f','g','h','i',
        'j','k','l','m','n','o','p','q','r',
        's','t','u','v','w','x','y','z': scanWord;

        '0','1','2','3','4','5','6','7','8','9': scanNumber;

        '"': scanString;
        '(': charSy(lParen);
        ')': charSy(rParen);
        '[': charSy(lBrack);
        ']': charSy(rBrack);
        '<': charSy(lAngle);
        '>': charSy(rAngle);
        '=': charSy(equals);
        '\': charSy(lambda);
        '.': charSy(dot);
        '+': charSy(plus);
        '-':
            begin
            nextChar;
            if ch = '>' then charSy(arrow)
            else sy := minus
            end;
        '*': charSy(star);
        ';': charSy(semicolon);
        ':': charSy(colon);
        ',': charSy(comma);
        '|': charSy(bar);
	'!','$','%','&','''','^','~','@','`','{','}',
	'?':  begin  error(illegalChar);  sy := illCharSy end
        end {case}
    end {nextSy};



procedure checkNextSy(s: symbol);
    {match the input symbol with the expected token 's' and advance}
    begin
    if sy <> s then begin err.sy := s; error(wrongSymbol) end
    else nextSy
    end {checkNextSy};



    { ************************************************
      *    domain   checking   and   manipulation    *
      ************************************************}



function dNoname(dom: domain): domain;
    {get from a name to its definition}
    begin
    if dom<>nil then
        if dom^.kind = namedDom then
            if domn[dom^.di].value <> nil then
                dom := dNoname(domn[dom^.di].value);
    dNoname := dom
    end {dNoname};



function compDoms(d1,d2: domain): boolean;
    {compare 2 domains for compatibility, using mostly structural equivalence.
      it is correct but impractical to use full structural equivalence.}
    const maxSeen = 20;
    var seenCount: integer;
        seen: array [1..maxSeen] of
        record d1,d2: domain end;
        {seen holds all pairs of domains passed as arguments in still-
          pending recursive calls to compDoms.  as an "induction hypothesis"
          they can be assumed compatible.  this prevents recursive calls
          with the same arguments, which would loop.}


    function cd(d1,d2: domain): boolean;
        var i: integer;

        begin
        d1 := dNoname(d1); d2 := dNoname(d2);
        if d1 = d2 then cd := true
        else if (d1=errorDom) or (d2=errorDom) then cd := true
        else
            begin
            seen[seenCount+1].d1 := d1;
            seen[seenCount+1].d2 := d2;
            i := 1;
            while (d1 <> seen[i].d1) or (d2 <> seen[i].d2) do i := i+1;
            if i > seenCount then
                begin
                seenCount := seenCount+1;
                if d1^.kind <> d2^.kind then cd := false
                else
                    case d1^.kind of
                        namedDom: cd := d1^.di = d2^.di;
                        prod: cd := cd(d1^.l, d2^.l)
                            and cd(d1^.r, d2^.r);
                        sum: cd := false;
                        func: cd := cd(d1^.dom, d2^.dom)
                            and cd(d1^.range, d2^.range)
                        end {case};
                seenCount := seenCount-1
                end
            else {already seen} cd := true
            end
        end {cd};

    begin
    seenCount := 0;
    if (d1=nil) or (d2=nil) then compDoms := false
    else compDoms := cd(d1,d2)
    end {compDoms};



procedure checkDoms(d1,d2: domain);
    begin
    if not compDoms(d1,d2) then
        begin err.dom1 := d1; err.dom2 := d2; error(domainMismatch) end
    end {checkDoms};



function eqDom(d: domain): boolean;
    {determines  if equality test is defined for domain d:
      d must not contain a function domain.}
    var
        {set of domains already visited, to avoid looping on recursive domains;
          like 'seen' in compDoms}
        seen: array [1..maxDoms] of boolean;

        di: integer;



    function equal(d: domain): boolean;
        var s: summandList;  eq: boolean;  
        begin
        if d=nil then equal := false
        else case d^.kind of
            namedDom:
                if d^.di <= preDomCount then equal := true
                else if seen[d^.di] then equal := true
                else begin
                    seen[d^.di] := true;
                    equal := equal(domn[d^.di].value);
                    seen[d^.di] := false
                    end;
            prod: equal := equal(d^.l) and equal(d^.r);
            sum: begin
                eq := true;  s := d^.s;
                while eq and (s<>nil) do begin
                    eq := eq and equal(s^.summand);
                    s := s^.next
                    end;
                equal := eq
                end;
            func: equal := false
            end {case}
        end {equal};

    begin
    for di := 1 to domCount do seen[di] := false;
    eqDom := equal(d)
    end {eqDom};



procedure checkFunction(f: domain; var dom,range: domain);
    {check that the domain 'f' is a function domain}
    {return its 'dom' and 'range'                  }
    begin
    f := dNoname(f);
    if f^.kind = func then begin dom := f^.dom; range := f^.range end
    else if f = errorDom then
        begin dom := errorDom;  range := errorDom end
    else begin
        err.dom1 := f; error(notAFunction);
        dom := boolDom; range := boolDom
        end
    end {checkFunction};



    { ******************************************************
      * constructor functions for all list structure forms *
      ******************************************************}


    { *******************************
      *        d o m a i n s        *
      *******************************}


function consNDom(di: domIndex): domain;
    {construct named domain.}
    var dom: domain;
    begin
    new(dom); dom^.kind := namedDom; dom^.di := di; consNDom := dom
    end {consNDom};



function consSum(s: summandList): domain;
    {construct sum domain : discriminated union}
    var dom: domain;
    begin
    new(dom);
    dom^.kind := sum; dom^.s := s;
    consSum := dom
    end {consSum};



function consProd(l,r: domain): domain;
    {construct product domain.}
    var dom: domain;
    begin
    new(dom);
    dom^.kind := prod; dom^.l := l; dom^.r := r;
    consProd := dom
    end {consProd};



function consFunc(d,range: domain): domain;
    {construct function domain}
    var dom: domain;
    begin
    new(dom); dom^.kind := func; dom^.dom := d; dom^.range := range;
    consFunc := dom
    end {consFunc};



    { *******************************
      *    e x p r e s s i o n s    *
      *******************************}




function consX(dom: domain; kind: expKind): expression;
    {construct an expression node and initialize its top-level fields.}
    var x: expression;
    begin new(x); x^.dom := dom; x^.kind := kind; consX := x end {consX};



function consNExp(di: defIndex): expression;
    var x: expression;
    begin
    x := consX(def[di].dom, namedExp); x^.di := di; consNExp := x
    end {consNExp};



function consAttr(dom: domain; atKind: attrKind;
                   offset: integer): expression;
    {construct reference to defining attribute of a rule}
    var x: expression;
    begin
    x := consX(dom,attribute); x^.atKind := atKind; x^.offset := offset;
    consAttr := x
    end {consAttr};



function consConst(dom: domain; c: constKind): expression;
    {construct constant expression.}
    var x: expression;
    begin
    x := consX(dom,constant); x^.v.kind := c;
    consConst := x
    end {consConst};



function consIntConst(i:integer): expression;
    {construct integer constant of value 'i'}
    var x: expression;
    begin
    x := consConst(intDom,int); x^.v.i := i;
    consIntConst := x
    end {consIntConst};



function consVar(dom: domain; depth: integer): expression;
    {construct variable.}
    var x: expression;
    begin
    x := consX(dom,variable); x^.depth := depth;
    consVar := x
    end {consVar};



function consFix(bv: boundVar; body: expression): expression;
    {construct fixed point expression.}
    var x: expression;


    procedure checkFixDom(dom: domain);
        {check that the domain is valid for taking a fixedpoint;
          this system can only handle tuples of functions}
        var d,r: domain;
        begin
        dom := dNoname(dom);
        if dom^.kind = prod then
            begin checkFixDom(dom^.l);  checkFixDom(dom^.r) end
        else checkFunction(dom,d,r)
        end {checkFixDom};

    begin
    checkDoms(bv.dom, body^.dom);  checkFixDom(bv.dom);
    x := consX(bv.dom, fixExp); x^.bv := bv; x^.body := body;
    consFix := x
    end {consFix};



function consLambda(bv: boundVar; body: expression): expression;
    {construct lambda expression, determining domain from arguments.}
    var x: expression;
    begin
    x := consX(consFunc(bv.dom,body^.dom), lambdaExp);
    x^.bv := bv; x^.body := body;
    consLambda := x
    end {consLambda};



function consApplic(rator,rand: expression): expression;
    {construct application, checking domains of operator and operand.}
    var x: expression;  dom,range: domain;
    begin
    checkFunction(rator^.dom,dom,range); checkDoms(dom, rand^.dom);
    x := consX(range,applic); x^.rator := rator; x^.rand := rand;
    consApplic := x
    end {consApplic};



function consCond(ifExp,thenExp,elseExp: expression): expression;
    {construct conditional, checking that both arms have the same domain.}
    var x: expression;
    begin
    checkDoms(ifExp^.dom, boolDom);
    checkDoms(thenExp^.dom, elseExp^.dom);
    x := consX(thenExp^.dom,cond); x^.ifExp := ifExp;
    x^.thenExp := thenExp; x^.elseExp := elseExp;
    consCond := x
    end {consCond};



function consCase(dom: domain; index: expression; cases: caseList)
    : expression;
    {construct a case expression, given its arms.}
    var x: expression;
    begin
    x := consX(dom,caseExp); x^.index := index; x^.cases := cases;
    consCase := x
    end {consCase};



function consPair(l,r: expression): expression;
    {construct a pair : an element of a product domain.}
    var x: expression;
    begin
    x := consX(consProd(l^.dom,r^.dom), pair); x^.l := l; x^.r := r;
    consPair := x
    end {consPair};



function consUnOp(uop: stdFunc; u1: expression): expression;
    {construct a unary operation.}
    var x: expression; d,dom: domain;
    begin
    d := dNoname(u1^.dom);
    case uop of
        leftSy,rightSy:
            if d^.kind = prod then
                if uop = leftSy then dom := d^.l
                else dom := d^.r
            else begin
                err.dom1 := d;
                if d<>errorDom then error(notAProduct);
                dom := errorDom
                end;
        notSy: dom := boolDom
        end {case};
    x := consX(dom,unOp);  x^.uop := uop;  x^.u1 := u1;
    consUnOp := x
    end {consUnOp};



function consBinOp(bop: stdFunc; b1,b2: expression): expression;
    {construct a binary operation.}
    var x: expression;   dom: domain;
    begin
    case bop of
        plus,minus,star,divSy,modSy:
            begin
            checkDoms(b1^.dom,intDom); checkDoms(b2^.dom,intDom);
            dom := intDom
            end;
        andSy,orSy,notSy:
            begin
            checkDoms(b1^.dom,boolDom); checkDoms(b2^.dom,boolDom);
            dom := boolDom
            end;
        ltSy,leSy,gtSy,geSy:
            begin
            checkDoms(b1^.dom,intDom);
            checkDoms(b2^.dom,intDom);
            dom := boolDom
            end;
        eqSy,neSy:
            begin
            checkDoms(b1^.dom, b2^.dom);
            if not eqDom(b1^.dom) then
                begin err.dom1 := b1^.dom; error(notEqDomain) end;
            dom := boolDom
            end
        end {case};
    x := consX(dom,binOp); x^.bop := bop; x^.b1 := b1; x^.b2 := b2;
    consBinOp := x
    end {consBinOp};



function consAlterExp(t1,t2,t3: expression): expression;
    var x: expression; dom,range: domain;
    begin
    checkFunction(t3^.dom,dom,range);
    checkDoms(t1^.dom, dom); checkDoms(t2^.dom, range);
    x := consX(t3^.dom,alterExp); x^.t1 := t1; x^.t2 := t2; x^.t3 := t3;
    consAlterExp := x
    end {consAlterExp};



function consInject(si: selIndex; exp: expression): expression;
    {construct an injection into a sum domain.}
    var x: expression;
    begin
    checkDoms(exp^.dom, selector[si].summand);
    x := consX(selector[si].sum,inject); x^.si := si;  x^.exp := exp;
    x^.silent := false;
    consInject := x
    end {consInject};



function consProject(si: selIndex; silent: boolean; exp: expression)
    : expression;
    {construct a projection (projection) from a sum domain to a summand.}
    var x: expression;
    begin
    checkDoms(exp^.dom, selector[si].sum);
    x := consX(selector[si].summand,project); x^.si := si; x^.exp := exp;
    x^.silent := silent;
    consProject := x
    end {consProject};



function consIsExp(si: selIndex; exp: expression): expression;
    {construct a test that 'exp' belongs to summand 'si'}
    var x: expression;
    begin
    checkDoms(exp^.dom, selector[si].sum);
    x := consX(boolDom,isExp); x^.si := si; x^.exp := exp;
    x^.silent := false;
    consIsExp := x
    end {consIsExp};



function consCaseList
    (si: selIndex; bv: boundVar; body: expression; next: caseList)
    : caseList;
    {'cons' a new element to the front of the case-list 'next'}
    var c: caseList;
    begin
    new(c); c^.next := next; c^.si := si; c^.bv := bv; c^.body := body;
    consCaseList := c
    end {consCaseList};



function consAtList(dom: domain; inher: boolean; next: attrList): attrList;
    var a: attrList;
    begin
    new(a); a^.dom := dom; a^.inher := inher; a^.next := next;
    consAtList := a
    end {consAtList};



    { *******************************
      *    n a m e     t r e e s    *
      *******************************}



function consNtLeaf(name: alfa): nameTree;
    var t: nameTree;
    begin
    new(t);  t^.leaf := true;  t^.name := name;
    consNtLeaf := t
    end {consNtLeaf};



function consNtPair(l,r: nameTree): nameTree;
    var t: nameTree;
    begin
    new(t);  t^.leaf := false;  t^.l := l;  t^.r := r;
    consNtPair := t
    end {consNtPair};



procedure enterDom(name: alfa; dom: domain; p: boolean);
    {enter a new domain definition.  if an (automatically generated) forward
      definition exists, patch it with the new 'dom'.  recursive definitions
      result in circular list structures from this patch.  'p' indicates that
      a redefinition is 'pending.'}
    var di: integer;    {domain index}
    begin
    checkNoDigits(name);
    treeSearch(domTree,name,di);
    if di=0 then begin  {not already declared}
        domCount := domCount+1;
        domn[domCount].name := name;
        domn[domCount].propagate := false;
        treeInsert(domTree,name,domCount);
        di := domCount
        end
    else if not domn[di].pending then
        begin err.name := name; error(redefinition) end;
    domn[di].value := dom;
    domn[di].pending := p
    end {enterDom};



procedure enterDef(dom: domain; name: alfa; x: expression; p: boolean);
    {enter a new expression definition; similar to enterDom}
    var di: integer;	{index to definitions array}
    begin
    checkNoDigits(name);
    treeSearch(defTree,name,di);
    if di=0 then begin   {not already declared}
        defCount := defCount+1;
        def[defCount].name := name;
        def[defCount].dom := dom;
        treeInsert(defTree,name,defCount);
        di := defCount
        end
    else begin
        if p or not def[di].pending then
            begin err.name := name; error(redefinition) end;
        checkDoms(dom, def[di].dom)
        end;
    def[di].value := x;
    def[di].pending := p
    end {enterDef};



    {*****************************************************}
    {*                  p a r s i n g                    *}
    {*****************************************************}



procedure parseDomain(var dom: domain);
    {factor = name ! "[" summand (: "+" summand :) "]" ! "(" domain ")".
      summand = name [ "[" domain "]" ].
      domain = factor ! factor "->" domain ! factor "x" domain.
      note that x (product) and -> (function) are right-associative.}
    var rdom: domain;



    procedure factor(var dom: domain);



        procedure parseName(var dom: domain);
            {read a domain name.  with the domain definition part,
              undeclared identifiers generate forward definitions
              that must eventually be resolved.}
            var i: integer;
            begin
            treeSearch(domTree,varName,i);
            if i=0 then {no such domain}
                if inDoms then begin {create a new domain}
                    enterDom(varName,nil,true);
                    i := domCount
                    end
                else begin {forward reference not allowed here}
                    err.name := varName; error(noSuchDomain);
                    i := 1  {prevent index error below}
                    end;
            dom := consNDom(i);
            nextSy
            end {parseName};



        procedure parseSum(var dom: domain);
            {parse a sum domain and enter its selectors into their table.}
            var s: summandList;



            procedure parseSummandList(var s: summandList);
                var name: alfa;  summand: domain;
                begin
                name := varName;  {get next selector name}
                checkNextSy(nameSy);
                checkNoDigits(name);
                if sy = lBrack then begin
                    checkNextSy(lBrack); parseDomain(summand);
                    checkNextSy(rBrack)
                    end
                else summand := voidDom;
                {enter the new selector}
                selectCount := selectCount+1;
                selector[selectCount].name := name;
                selector[selectCount].sum := dom;
                selector[selectCount].summand := summand;
                treeEnter(selectTree,name,selectCount);
                new(s);
                s^.si := selectCount; s^.summand := summand;
                if sy=plus then
                    begin nextSy; parseSummandList(s^.next) end
                else s^.next := nil
                end {parseSummandList};

            begin
            dom := consSum(nil);
            checkNextSy(lBrack);
            parseSummandList(s);
            dom^.s := s;
            checkNextSy(rBrack)
            end {parseSum};

        begin
        if sy=nameSy then parseName(dom)
        else if sy=lBrack then parseSum(dom)
        else if sy=lParen then
            begin nextSy; parseDomain(dom); checkNextSy(rParen) end
        else begin error(wrongSymbol); dom := nil end
        end {factor};

    begin
    factor(dom);
    if sy = arrow then
        begin nextSy; parseDomain(rdom); dom := consFunc(dom,rdom) end
    else if sy = cross then
        begin nextSy; parseDomain(rdom); dom := consProd(dom,rdom) end
    end {parseDomain};



procedure parseExp(var x: expression);
    const elemMax = 40;   {limit of components of structured bound vars}
    type
        {left/right chain needed to access a variable;  left=true
          the access of left right x is (2, (false,true))
          opposite of access in l.pas!   }
        bvAccess = record
                        depth: 0..accessMax;
                        left: packed array [1..accessMax] of boolean
                    end;
    var
        factorSy: set of symbol;
        f: symbol;


        {bound variables of enclosing lambda-expressions}
        bVarDepth: integer;
        bVar: array [1..maxLambdaDepth] of
        record dom: domain; ecount: integer end;


        {named components of structured bound variables}
        elemCount: integer;
        elem: array [0..elemMax] of {subscript 0 needed for searchBound}
        record
            name: alfa;             {name of component (search key) }
            access: bvAccess;      {how to access component}
            index: integer      {bound var containing component}
        end;



    procedure exp(var x: expression);
        {expression = term | term 'is' selector-name
          -         | term infix-operator expression
          -         | prefix-operator expression | alter-expression
          -         | lambda-expression | fixedpoint-expression
          -         | conditional-expression | case-expression
          -         | let-expression | letrec-expression.
          term = factor (: factor | "!" selectorName :).
          selectorName = name.
          infix-operator = ':' | '+' | '-' | '*' | 'div' | 'mod'
          -         | 'and' | 'or'
          -         | 'lt' | 'le' | 'gt' | 'ge' | 'eq' | 'ne'
          prefix-operator = "left" | "right" | "not" | "-".}
        {note that 'f:x' means the same as 'f(x)' but is right-associative}
        var rand: expression;  op: symbol;




        procedure pushBoundVar(bv: boundVar);
            {enter a new bound variable and its components}
            var ac: bvAccess;



            procedure enterElems(nt: nameTree);
                {scans the name tree to enter all its components
                  with their 'access';  builds up access in 'ac'}
                begin
                if nt^.leaf then begin
                    elemCount := elemCount+1;
                    with elem[elemCount] do begin
                        name := nt^.name; index := bVarDepth;
                        access := ac
                        end
                    end
                else with ac do begin
                    depth := depth+1;
                    left[depth] := true;  enterElems(nt^.l);
                    left[depth] := false; enterElems(nt^.r);
                    depth := depth-1
                    end
                end {enterElems};

            begin
            bVarDepth := bVarDepth+1;
            bVar[bVarDepth].ecount := elemCount;
            bVar[bVarDepth].dom := bv.dom;
            ac.depth := 0; enterElems(bv.name)
            end {pushBoundVar};



        procedure popBoundVar;
            begin
            elemCount := bVar[bVarDepth].ecount;
            bVarDepth := bVarDepth-1
            end {popBoundVar};



        procedure getDom(domName: alfa; var dom: domain;
                          msg: errorMessage);
            {get the domain of the var from its name}
            var di,		{index to domain}
		i: integer;
            begin
            for i := 1 to alfaleng do {strip off trailing digits}
                if domName[i] in ['0'..'9']
                then domName[i] := ' ';
            treeLookup(domTree,domName,di,msg);
            dom := consNDom(di)
            end {getDom};



        procedure parseBvs(var bv: boundVar);
            {bound-vars = bv ["," bound-vars].
              bv = "(" bound-vars ")" ! name.}
            var bv2: boundVar;   name: alfa;   dom: domain;
            begin
            if sy = lParen then
                begin nextSy; parseBvs(bv); checkNextSy(rParen) end
            else if sy = nameSy then begin
                name := varName;  nextSy;
                if sy = colon then  {read explicit domain}
                    begin nextSy; parseDomain(dom) end
                else getDom(name,dom,noSuchDomain);
                bv.name := consNtLeaf(name);  bv.dom := dom
                end
            else error(wrongSymbol);
            if sy = comma then begin
                nextSy; parseBvs(bv2);
                bv.dom := consProd(bv.dom,bv2.dom);
                bv.name := consNtPair(bv.name,bv2.name)
                end
            end {parseBvs};



        procedure parsePushBvs(var bv: boundVar);
            begin
            parseBvs(bv); pushBoundVar(bv)
            end {parsePushBvs};



        procedure parseCond(var x: expression);
            {conditional-expression =
              "if" expression "then" expression "else" expression "fi".}
            var i,t,e: expression;
            begin
            nextSy; exp(i);
            checkNextSy(thenSy); exp(t);
            checkNextSy(elseSy); exp(e);
            checkNextSy(fiSy);
            x := consCond(i,t,e)
            end {parseCond};



        procedure parseCase(var x: expression);
            {case-expression = "case" expression "of" case-list "esac".
              case-list = case ! case "," case-list.
              case = selector [ "[" bound-vars "]" ] "." expression.
              selector = name.}
            var i: expression;  iDom,bodyDom: domain;
                cases: caseList;



            procedure pCases(s: summandList; var cases: caseList;
                              var dom: domain);
                var si: integer;  
		    nextDom: domain;  
		    name: alfa;
                    bv: boundVar;  body: expression;  next: caseList;
                begin
                cases := nil;
                dom := boolDom; {a non-nil value returned if error}
                name := varName;  checkNextSy(nameSy);
                treeLookup(selectTree,name,si,notASelector);
                if s = nil then error(wrongSelector)
                else if si <> s^.si then error(wrongSelector)
                else begin
                    if sy = lBrack then begin
                        checkNextSy(lBrack); parseBvs(bv);
                        checkNextSy(rBrack)
                        end
                    else bv := voidBv;
                    pushBoundVar(bv);
                    checkNextSy(dot);
                    exp(body);  dom := body^.dom;
                    popBoundVar;
                    checkDoms(bv.dom, selector[si].summand);
                    if sy=comma then begin
                        nextSy;
                        pCases(s^.next,next,nextDom);
                        checkDoms(dom,nextDom)
                        end
                    else begin
                        next := nil;
                        if s^.next <> nil then error(wrongSymbol)
                        end;
                    cases := consCaseList(si,bv,body,next)
                    end
                end {pCases};

            begin
            nextSy;
            exp(i);
            checkNextSy(ofSy);
            iDom := dNoname(i^.dom);
            x := errorX;  {in case of error}
            if iDom^.kind = sum then begin
                pCases(iDom^.s,cases,bodyDom);
                checkNextSy(esacSy);
                if ok then x := consCase(bodyDom,i,cases)
                end
            else begin err.dom1 := iDom; error(notASum) end
            end {parseCase};



        procedure parseFix(var x: expression);
            {fixedpoint-expression = "fix" "\" bound-vars "." expression.}
            var bv: boundVar; body: expression;
            begin
            checkNextSy(fixSy); checkNextSy(lambda); parsePushBvs(bv);
            checkNextSy(dot); exp(body);
            popBoundVar;
            x := consFix(bv,body)
            end {parseFix};



        procedure parseLambda(var x: expression);
            {lambda-expression = "\" bvsbound-vars (: bound-vars :) "." expression.}
            var bv: boundVar;  body: expression;
            begin
            if ok then begin
                parsePushBvs(bv);
                if sy = dot then begin nextSy; exp(body) end
                else parseLambda(body);
                x := consLambda(bv,body);
                popBoundVar
                end
            else x := errorX    {avoid looping on syntax error}
            end {parseLambda};



        procedure parseLet(var x: expression);
            {let-clause = "let" bound-vars "=" expression "in" expression.
              let var=exp1 in exp2    denotes    (\var.exp2)exp1  }
            var bv: boundVar; exp1,exp2: expression;
            begin
            checkNextSy(letSy); parseBvs(bv);
            checkNextSy(equals);  exp(exp1);
            checkDoms(bv.dom, exp1^.dom);
            checkNextSy(inSy);
            pushBoundVar(bv);  exp(exp2);  popBoundVar;
            x := consApplic(consLambda(bv,exp2), exp1)
            end {parseLet};



        procedure parseLetrec(var x: expression);
            {letrec-clause =
             .       "letrec" bound-vars "=" expression "in" expression.
              the clause    letrec var=exp1 in exp2
              denotes       (\var.exp2)(fix var.exp1)  }
            var bv: boundVar; exp1,exp2: expression;
            begin
            checkNextSy(letrecSy);
            parsePushBvs(bv);
            checkNextSy(equals); exp(exp1);
            checkDoms(bv.dom, exp1^.dom);
            checkNextSy(inSy);  exp(exp2);
            popBoundVar;
            x := consApplic(consLambda(bv,exp2), consFix(bv,exp1))
            end {parseLetrec};



        procedure parseAlter(var x: expression);
            {alter-expression =
             .       "[" expression "->" expression "]" expression.
             an expression [a->b]f denotes the function f modified
             to map a to b, namely
                \x.if a eq x then b else f(x) fi  }
            var a,b,f: expression;
            begin
            checkNextSy(lBrack); exp(a);
            checkNextSy(arrow); exp(b);
            checkNextSy(rBrack); exp(f);
            x := consAlterExp(a,b,f)
            end {parseAlter};



        procedure factor(var x: expression);
            {factor = variable | number | string
              | selectorName [ "[" tuple "]" ]
              | "(" tuple ")"
              | atom | "true" | "false".
             tuple = expression | expression "," tuple.}
            {the comma cannot be a regular infix operator because it is needed
             to separate attributes.}



            procedure parseTuple(var x: expression);
                {parse a tuple of expressions, separated by commas.}
                var y: expression;
                begin
                exp(x);
                if sy = comma then
                    begin nextSy; parseTuple(y); x := consPair(x,y) end
                end {parseTuple};



            procedure parseVar(var x: expression);
                {parse a name, which may be a variable, selector, etc.}
                var name: alfa;



                procedure searchBound;
                    {see if the name is a local bound var}
                    var i: integer;



                    function consAccess(ac: bvAccess; x: expression)
                        : expression;
                        var i: integer;
                        begin
                        for i := 1 to ac.depth do
                            if ac.left[i] then x := consUnOp(leftSy,x)
                            else x := consUnOp(rightSy,x);
                        consAccess := x
                        end {consAccess};

                    begin
                    {search backwards to get most recent name}
                    elem[0].name := name;
                    i := elemCount;
                    while elem[i].name <> name do i := i-1;
                    if i=0 then x := nil  {no such element}
                    else with elem[i] do  {generate access to the component}
                        x := consAccess(access,
                                         consVar(bVar[index].dom,
                                                  bVarDepth-index));
                    end {searchBound};



                procedure searchFree;
                    {see if the name is one of the defined expressions}
                    var i: integer;
                    begin
                    treeSearch(defTree,name,i);
                    if i=0 then x := nil
                    else x := consNExp(i)
                    end {searchFree};



                procedure searchSel;
                    {see if the name is a selector of a sum domain;
                      if so, parse "[" tuple "]" for the injection.}
                    var si: integer;
                    begin
                    treeSearch(selectTree,name,si);
                    if si=0 then x := nil
                    else begin
                        if sy = lBrack then begin
                            checkNextSy(lBrack); parseTuple(x);
                            checkNextSy(rBrack)
                            end
                        else x := voidExp;
                        x := consInject(si,x)
                        end
                    end {searchSel};



                procedure searchAttr;
                    {see if the name is that of an attribute of this rule;
                      if not, assume it is a forward reference to an attr}
                    var i: integer;
                    begin
                    lookupAttr(name,i);
                    if i>attrCount then
                        if forwAttrs then begin {forward ref to attribute}
                            attrCount := i;
                            attr[i].name := name;
                            attr[i].value := nil;
                            getDom(name,attr[i].dom,undeclIdent)
                            end
                        else i := 0;
                    {forward refs not allowed}
                    if i=0 then x := nil
                    else x := consVar(attr[i].dom,bVarDepth+i)
                    end {searchAttr};

                begin
                name := varName;
                nextSy;
                searchBound;
                if x = nil then searchFree;
                if x = nil then searchSel;
                if x = nil then searchAttr;
                if x = nil then begin
                    err.name := name; error(undeclIdent); x := errorX end
                end {parseVar};



            procedure parseAtom(var x: expression);
                {atom = "bot" "[" domain "]".  }
                var dom: domain;
                begin
                checkNextSy(botSy);
                checkNextSy(lBrack); parseDomain(dom);
                checkNextSy(rBrack);
                x := consConst(dom,bot)
                end {parseAtom};

            begin
            if sy in factorSy then
                case sy of
                    nameSy: parseVar(x);
                    botSy: parseAtom(x);
                    trueSy,falseSy:
                        begin x := boolExp[sy = trueSy]; nextSy end;
                    number: begin x := consIntConst(numVal); nextSy end;
                    stringSy:
                        begin
                        x := consConst(stringDom,string);
                        x^.v.s := stringVal;
                        nextSy
                        end;
                    lParen:
                        begin
                        nextSy;
                        parseTuple(x);
                        checkNextSy(rParen)
                        end
                    end {case}
            else begin x := errorX;  error(factorExpected) end;
            end {factor};



        procedure doSelOp;
            {do selector operations "!" and "is".  lookup selector name and
              check that its domain matches the expression's.}
            var si: integer; 	{selector index}
		name: alfa;   	{selector name}
		s: symbol;	{operation using selector}
            begin
            s := sy; nextSy; name := varName;
            checkNextSy(nameSy);
            treeLookup(selectTree,name,si,notASelector);
            checkDoms(x^.dom, selector[si].sum);
            if s=bar then x := consProject(si,false,x)
            else x := consIsExp(si,x)
            end {doSelOp};

        begin
        if sy in [ifSy,caseSy,letrecSy,letSy,fixSy,lambda,lBrack,
                  leftSy,rightSy,notSy,minus]  then
            case sy of
                ifSy: parseCond(x);
                caseSy: parseCase(x);
                minus:
                    begin
                    nextSy;
                    exp(x);
                    x := consBinOp(minus, consIntConst(0), x)
                    end;
                leftSy,rightSy,notSy:
                    begin f := sy; nextSy; exp(x); x := consUnOp(f,x) end;
                lBrack: parseAlter(x);
                fixSy: parseFix(x);
                lambda: begin nextSy; parseLambda(x) end;
                letSy: parseLet(x);
                letrecSy: parseLetrec(x)
                end {case}
        else begin
            factor(x);
            while sy in (factorSy + [bar]) do
                if sy = bar then doSelOp
                else begin factor(rand);  x := consApplic(x,rand) end;
            if sy = isSy then doSelOp
            else if sy in
                [colon,plus,minus,star,divSy,modSy,andSy,orSy,
                 ltSy,leSy,gtSy,geSy,eqSy,neSy]
            then begin
                {operator transformations:
                  a and b  ->  if a then b else false fi   (conditional and)
                  a or b   ->  if a then true else b fi
                  a <= b   ->  not (b<a)
                  a > b    ->  b < a
                  a >= b   ->  not (a < b)
                  a <> b   ->  not (a = b)        }
                op := sy; nextSy; exp(rand);
                case op of
                    colon: x := consApplic(x,rand);
                    andSy: x := consCond(x,rand,boolExp[false]);
                    orSy: x := consCond(x,boolExp[true],rand);
                    leSy: x := consUnOp(notSy,consBinOp(ltSy,rand,x));
                    gtSy: x := consBinOp(ltSy,rand,x);
                    geSy: x := consUnOp(notSy,consBinOp(ltSy,x,rand));
                    neSy: x := consUnOp(notSy,consBinOp(eqSy,x,rand));
                    ltSy,eqSy,
                    divSy,modSy,star,plus,minus: x := consBinOp(op,x,rand)
                    end {case}
                end
            end
        end {exp};

    begin
    factorSy := [nameSy,botSy,trueSy,falseSy,number,stringSy,lParen];
    bVarDepth := 0; elemCount := 0; exp(x)
    end {parseExp};



procedure printName(var f: text; name: alfa);
    var len: integer;
    begin
    len := alfaleng;
    while name[len] = ' ' do len := len-1;
    write(f, name:len)
    end {printName};



procedure printDom{  (var f: text; dom: domain)  };
    var di: integer;  dname: alfa;



    procedure printSum(s: summandList);



        procedure printNode(var s: summandList);
            begin
            printName(f, selector[s^.si].name);
            if s^.summand <> voidDom then begin
                write(f, '['); printDom(f, s^.summand); write(f, ']')
                end;
            s := s^.next
            end {printNode};
        begin
        write(f, '['); printNode(s);
        while s <> nil do begin write(f, ' + '); printNode(s) end;
        write(f, ']')
        end {printSum};



    procedure printProd(dom: domain);
        var d: domain;
        begin
        write(f, '(');
        d := dom;
        while d^.kind = prod do
            begin printDom(f, d^.l); write(f, ' x '); d := d^.r end;
        printDom(f, d);
        write(f, ')')
        end {printProd};



    procedure printFunc(dom: domain);
        begin
        write(f, '(');
        printDom(f, dom^.dom); write(f,' -> ');
        printDom(f,dom^.range); write(f,')')
        end {printFunc};

    begin
    if dom=nil then write(f,'nil')
    else begin
        {attempt to find a named domain matching the one to be printed.}
        if dom^.kind = namedDom then dname := domn[dom^.di].name
        else dname := '               ';
        di := 0;
        while (di < domCount) and (dname = '               ') do
            begin
            di := di+1;
            with domn[di] do if compDoms(dom,value) then dname := name
            end;
        if dname <> '               ' then printName(f,dname)
        else case dom^.kind of
            namedDom: printName(f, domn[dom^.di].name);
            sum: printSum(dom^.s);
            prod: printProd(dom);
            func: printFunc(dom)
            end {case}
        end
    end {printDom};



procedure printExp(var f: text; x: expression);
    var bVarDepth: integer;
        bVar: array [1..maxLambdaDepth] of boundVar;
        attrAlfa: array [attrKind] of alfa;



    procedure print(x: expression);



        procedure printNt(t: nameTree);
            begin
            if t^.leaf then printName(f,t^.name)
            else begin
                write(f,'(');
                repeat printNt(t^.l); write(f,','); t := t^.r until t^.leaf;
                printName(f,t^.name);  write(f,')')
                end
            end {printNt};

        begin
        if x=nil then write(f,'nil')
        else with x^ do case kind of
            namedExp: printName(f,def[di].name);
            attribute: begin
                printName(f,attrAlfa[atKind]);
                write(f,' ',offset:1)
                end;
            variable: if bVarDepth<depth then
                          print(attr[depth - bVarDepth].value)
                      else printNt(bVar[bVarDepth - depth].name);
            constant:
                case v.kind of
                    bot: write(f,'bot');
                    int: write(f,v.i:1);
                    bool: write(f,v.b:5);
                    string: begin
                        write(f,'"'); printName(f,v.s);write(f,'"')
                        end
                    end {case};
            fixExp,lambdaExp:
                begin
                bVarDepth := bVarDepth+1;
                bVar[bVarDepth] := bv;
                write(f,'(');
                if kind = lambdaExp then write(f,'\')
                else write(f,'fix ');
                printNt(bv.name);
                write(f,'.'); print(body); write(f,')');
                bVarDepth := bVarDepth-1
                end;
            applic:  begin
                write(f,'('); print(rator); write(f, ' ');
                print(rand); write(f,')')
                end;
            cond:
                begin
                write(f,'if '); print(ifExp);
                write(f,' then '); print(thenExp);
                write(f,' else '); print(elseExp); write(f,' fi')
                end;
            caseExp:
                begin
                write(f,'case '); print(x^.index); write(f,' of ... esac')
                end;
            pair: begin
                write(f,'('); print(l);
                write(f,','); print(r); write(f,')')
                end;
            unOp:   begin
                write(f,'(');
                printName(f,syName[uop]); write(f,' '); print(u1);
                write(f,')')
                end;
            binOp:
                begin
                write(f,'('); print(b1); write(f,' ');
                if bop < nameSy then printName(f,syName[bop])
                else write(f,'?');
                write(f,' '); print(b2); write(f,')')
                end;
            alterExp:
                begin
                write(f,'(['); print(t1); write(f,'->'); print(t2);
                write(f,']'); print(t3); write(f,')')
                end;
            inject:
                begin
                printName(f,selector[si].name);
                if exp <> voidExp then
                    begin write(f,'['); print(exp); write(f,']') end
                end;
            project,isExp:
                begin
                write(f,'('); print(exp);
                if kind = project then write(f,'!')
                else write(f,' is ');
                printName(f,selector[si].name); write(f,')')
                end
            end {case}
        end {print};

    begin
    attrAlfa[lhsAttr]    := 'lhs attr       ';
    attrAlfa[rhsAttr]    := 'rhs attr       ';
    attrAlfa[pseudoAttr] := 'pseudo attr    ';
    bVarDepth := 0; print(x)
    end {printExp};



procedure go;
    const firstOp = leftSy;  lastOp = minus;
    type
        shortInt = 0..777777b;         {halfword on dec-10 and 20}
        termIndex = 0..maxTerms;
        nontermIndex = 0..maxNonterms;
        ruleIndex = 0..maxRules;
        rcIndex = 0..maxRuleContent;
        resolution = (leftR,rightR,nonassocR,noneR);

        gramSym = packed record term: boolean; idx: shortInt end;

        ruleRec = packed record
                              rci: rcIndex;          {index of lhs of rule}
                              length,                 {length of rhs}
                              userNum: 0..999        {order before sorting}
                          end;

        fileName = packed array [1..20] of char;
        fileExt = packed array [1..3] of char;

    var domSys,                {symbols beginning domains}
        comSys: set of symbol; {symbols beginning commands}
        opMap: array [firstOp..lastOp] of xKind;



        {nonterminals in the grammar}
        nontermTree: symbolTree;
        goalSymbol,                    {index to 'start$'}
        nontermCount: nontermIndex;   {total number of nonterminals}
        nonterm: array [1..maxNonterms] of
        packed record
                   name: alfa;      {name of the nonterminal}
                   lhs: ruleIndex; {first rule rewriting this nt}
                   attr: attrList  {attributes of the nonterminal}
               end;


        {terminal symbols}
        termTree: symbolTree;
        eofTerm,nameTerm,numberTerm,
        termCount: termIndex;
        term: array [1..maxTerms] of
        packed record
                   name: alfa;             {string denoting the terminal}
                   priority: shortInt;    {priority given in resolution part}
                   resol: resolution
               end;

        {syntax rules;  rule[0] is needed only in sortRules}
        ruleCount,goalRule: ruleIndex;
        rule: array [0..maxRules] of ruleRec;

        {'heap' storing the contents of each rule}
        rcCount: rcIndex;
        rc: array [1..maxRuleContent] of gramSym;


        {attribute lists for 'name' and 'number'}
        nameAttr,numberAttr: attrList;

        resolGiven: boolean;           {resolution part present in grammar}

	ldfFileName,			{name of language description file}
        listFileName: fileName;		{name of listing file}



    procedure heading(var f: text);
        var  datetxt,timetxt: packed array[1..10] of char;
        begin
        date(datetxt);
	time(timetxt);
        page(f);
        writeln(f, 'From file  ', listFileName, '  on  ',datetxt,'  ',timetxt)
        end {heading};



    procedure enterTerm(name: alfa; var ti: termIndex);
        {enter the terminal if new and return its index}
	var idx: integer;
        begin
        treeSearch(termTree,name,idx);  
	ti := idx;		{check subrange bounds}
        if ti=0 then begin   	{new nonterminal}
            termCount := termCount+1;
            term[termCount].name := name;
            term[termCount].priority := maxTerms;
            term[termCount].resol := noneR;
            treeInsert(termTree,name,termCount);
            ti := termCount
            end
        end {enterTerm};



    procedure enterNt(na: alfa; at: attrList);
        {enter the nonterminal symbol of name 'na' and attributes 'at'.}
        begin
        nontermCount := nontermCount+1;
        with nonterm[nontermCount] do
            begin name := na; attr := at; lhs := 0 end;
        treeEnter(nontermTree,na,nontermCount);
        end {enterNt};



    procedure putInt(kind: xKind; int: integer);
        begin ldf^.kind := kind; ldf^.int := int; put(ldf) end;



    procedure putInt2(kind: xKind; int1,int2: integer);
        begin
        ldf^.kind := kind; ldf^.int1 := int1; ldf^.int2 := int2;
        put(ldf)
        end {putInt2};



    procedure putName(kind: xKind; name: alfa);
        {put alfa names out four chars at a time until blank found}
        var i: integer;
            na: array [1..30] of char;  {2 times alfaleng}
        begin
        for i := 1 to alfaleng do
            begin na[i] := name[i]; na[i+alfaleng] := ' ' end;
        i := 0;
        repeat
            i := i+4;
            ldf^.kind := kind;
            ldf^.ch1 := na[i-3];
            ldf^.ch2 := na[i-2];
            ldf^.ch3 := na[i-1];
            ldf^.ch4 := na[i];
            put(ldf);
        until na[i] = ' '
        end {putName};



    procedure put0(kind: xKind);
        begin ldf^.kind := kind; put(ldf) end;



    procedure putExp(x: expression; pseudo: boolean);
        {output the expression onto the LDF in postfix, followed by the index
          of its domain and a list of the attributes referenced.  'pseudo'
          indicates that the expression is the value of a pseudo-attribute.
          it may not depend on other pseudo-attribute since their order of
          evaluation is not guaranteed.}
        var bVarDepth: integer;  

            {attributes referenced by the expression}
            refAttrCount: integer;
            refAttr: array [1..20] of
            record
                atKind: attrKind;
                offset: integer
            end;



        procedure putAttr(at: attrKind;  off: integer);
            {output a reference to the given attribute.  if not seen before,
              put it into the attribute table.}
            var i: integer;
            begin
            if pseudo and (at = pseudoAttr) then error(illegalWith);
            refAttr[refAttrCount+1].atKind := at;
            refAttr[refAttrCount+1].offset := off;
            i := 1;
            while (refAttr[i].atKind <> at) or (refAttr[i].offset <> off)
            do i := i+1;
            if i>refAttrCount then refAttrCount := i;
            putInt(varX, bVarDepth + i - 1)
            end {putAttr};



        procedure putAttrList;
            {output final list of attributes referenced (as variables)
              in the expression.}
            var i: integer;
            begin
            for i := refAttrCount downto 1 do
                with refAttr[i] do
                    putInt2(attrX, ord(atKind), offset)
            end {putAttrList};



        procedure getBvInfo
            (bv: boundVar; var bvName: alfa; var propagate: boolean);
            {return an alfa name and 'propagate' flag for the bound var}
            begin
            if bv.dom^.kind = namedDom
            then propagate := domn[bv.dom^.di].propagate
            else propagate := false;
            with bv.name^ do if leaf then bvName := name
                             else bvName := 'a              '
            end {getBvInfo};



        procedure putx(x: expression);
            {dump the subexpression 'x'.}
            var name: alfa;             {name of bound variable}
                propagate: boolean;     {propagate flag of bound var}



            procedure putCase(index: expression;  cases: caseList);
                {output a case-expression as a list of lambda-expressions
                  followed by the index.}
                var name: alfa;         {name of the current bound variable}
                    c: caseList;
                    nc: integer;        {number of cases}
                begin
                assert(cases<>nil);
                nc := 0;  c := cases;
                bVarDepth := bVarDepth+1;
                while c<>nil do
                    with c^ do begin
                        putx(body); getBvInfo(bv,name,propagate);
                        if propagate then putName(propX,name)
                        else putName(lambdaX,name);
                        nc := nc+1; c := next
                        end;
                bVarDepth := bVarDepth-1;
                putx(index);  putInt2(caseX, nc, cases^.si)
                end;

            begin
            if x=nil then put0(nilX)
            else with x^ do
                case kind of
                    namedExp: putInt(namedX,di);
                    attribute: putAttr(atKind,offset);
                    variable: if bVarDepth<depth
                              then putx(attr[depth-bVarDepth].value)
                              else putInt(varX,depth);
                    constant: case v.kind of
                        bot: put0(botX);
                        int: putInt(intX,v.i);
                        bool: putInt(boolX,ord(v.b));
                        string: putName(stringX,v.s)
                        end;
                    fixExp,lambdaExp:
                        begin
                        bVarDepth := bVarDepth+1;
                        putx(body);
                        getBvInfo(bv,name,propagate);
                        if kind = lambdaExp then
                            if propagate then putName(propX,name)
                            else putName(lambdaX,name)
                        else putName(fixX,name);
                        bVarDepth := bVarDepth-1
                        end;
                    applic: begin putx(rator); putx(rand); put0(applicX) end;
                    cond: begin putx(ifExp); putx(thenExp); putx(elseExp);
                        put0(condX) end;
                    caseExp: putCase(index,cases);
                    pair: begin putx(l); putx(r); put0(pairX) end;
                    unOp: begin putx(u1); put0(opMap[uop]) end;
                    binOp: begin putx(b1); putx(b2); put0(opMap[bop]) end;
                    alterExp:
                        begin putx(t1); putx(t2); putx(t3); put0(alterX) end;
                    inject: begin putx(exp); putInt(injX,si) end;
                    project:
                        begin putx(exp); putInt2(projX,si,ord(silent)) end;
                    isExp: begin putx(exp); putInt(isX,si) end
                    end
            end {putx};

        begin
        bVarDepth := 0;  refAttrCount := 0;
        putx(x); put0(stopX);
        if x=nil then putInt(intX, 0)
        else begin
            if x^.dom^.kind = namedDom
            then putInt(intX, x^.dom^.di)
            else putInt(intX, 0)
            end;
        putAttrList
        end {putExp};



    procedure putTables;
        {output selectors, definitions, and nonterminals}
        var i: integer;



        procedure putAttrNos(a: attrList);
            {put out the number of inherited, synthesized attributes}
            var ni,ns: integer;
            begin
            ni := 0; ns := 0;
            while a<>nil do begin
                if a^.inher then ni := ni+1
                else ns := ns+1;
                a := a^.next
                end;
            putInt2(int2X,ni,ns);
            end {putAttrNos};

        begin
        putInt(intX,domCount);
        for i := 1 to domCount do putName(stringX,domn[i].name);
        putInt(intX,selectCount);
        for i := 1 to selectCount do putName(stringX,selector[i].name);
        putInt(intX,forwCount); putInt(intX,defCount);
        for i := 1 to defCount do
            with def[i] do begin
                putName(stringX,name);
                putExp(value,false)
                end;
        putInt(intX,nontermCount);
        for i := 1 to nontermCount do begin
            putName(stringX,nonterm[i].name);
            putAttrNos(nonterm[i].attr)
            end
        end {putTables};



    procedure putTerminals;
        {put out the terminals of the grammar}
        var i: integer;
        begin
        putInt(intX,termCount);
        for i := 1 to termCount do putName(stringX,term[i].name)
        end {putTerminals};



    procedure checkSemicolon;
        {check that command is properly terminated; skip symbols if not}
        begin
        if sy <> semicolon then begin
            err.sy := sy; error(noSemicolon);
            while not (sy in [semicolon] + comSys) do nextSy
            end;
        if sy=semicolon then nextSy
        end {checkSemicolon};



    procedure domCom;
        {domains = "domain" (: name "=" domain ";" :).  }
        var i: integer;  domName: alfa;  dom: domain;
        begin
        checkNextSy(domSy); inDoms := true;
        repeat
            ok := true;
            domName := varName;
            checkNextSy(nameSy); checkNextSy(equals);
            if sy = unspecSy then begin nextSy; dom := nil end
            else parseDomain(dom);
            checkSemicolon;
            if ok then enterDom(domName,dom,false)
            else enterDom(domName,errorDom,false)
        until sy in comSys;
        for i := 1 to domCount do
            if domn[i].pending
            then begin err.name := domn[i].name; error(forwRef) end;
        inDoms := false
        end {domCom};



    procedure propagCom;
        {cause arguments of the listed domains to always be expanded into
          lambda-abstractions, presumably to be simplified rather than
          leading to multiple copies of the argument.
          propagates = "propagate" domain-name (: "," domain-name:).  }
        var i: integer;  name: alfa;
        begin
        repeat
            ok := true; nextSy;  name := varName;
            checkNextSy(nameSy);
            treeLookup(domTree,name,i,noSuchDomain);
            domn[i].propagate := true
        until sy <> comma;
        checkSemicolon
        end {propagCom};



    procedure forwCom;
        {forward-decls = "forward" (: name ":" domain ";" :).   }
        var defName: alfa;  dom: domain;
        begin
        checkNextSy(forwSy);
        repeat
            ok := true;
            defName := varName;
            checkNextSy(nameSy);
            checkNextSy(colon);
            parseDomain(dom);
            checkSemicolon;
            if ok then enterDef(dom,defName,nil,true)
            else enterDef(errorDom,defName,nil,true)
        until sy in comSys
        end {forwCom};



    procedure defCom;
        {definitions = "define" (: name "=" def ";" :).
          def = expression ! "unspec" ":" domain.}
        var i: integer;  defName: alfa;
            x: expression;  dom: domain;
        begin
        checkNextSy(defSy);
        repeat
            ok := true;
            defName := varName;
            checkNextSy(nameSy);
            checkNextSy(equals);
            if sy = unspecSy then begin
                nextSy;  checkNextSy(colon);  parseDomain(dom);
                x := nil
                end
            else begin parseExp(x); dom := x^.dom end;
            checkSemicolon;
            if ok then begin
                enterDef(dom,defName,x,false);
                printName(listing,defName); write(listing, ' : ');
                printDom(listing,dom); writeln(listing)
                end
            else enterDef(errorDom,defName,nil,false)
        until sy in comSys;
        for i := 1 to defCount do
            if def[i].pending then
                begin err.name := def[i].name; error(forwRef) end;
        writeln(output, 'definitions processed.')
        end {defCom};



    procedure resolCom;
        {resolution-part = "resolution" (: resolution-kind (:string:) ";" :).
          resolution-kind = "left" ! "right" | "nonassoc".}
        var ti: integer; 		{index to terminal symbol}
	    priority: integer; 
	    resol: resolution;
        begin
        checkNextSy(resolSy); priority := 0;
        while sy in [leftSy,rightSy,nonassocSy] do begin
            if sy = leftSy then resol := leftR
            else if sy = rightSy then resol := rightR
            else resol := nonassocR;
            ok := true; nextSy;
            while sy = stringSy do begin
                treeLookup(termTree,stringVal,ti,noSuchSym);
                term[ti].resol := resol;
                term[ti].priority := priority;
                nextSy
                end;
            priority := priority+1;     {lowest priority is most binding}
            checkSemicolon
            end
        end {resolCom};



    procedure attrCom;
        {attribute-part = "attribute"
          .      (: name "<" attribute-list "." attribute-list ">" ";" :).
          attribute-list = [domain  (: "," domain :) ] .
          accept a declaration of all the nonterminals in the grammar,
          with the domains and directions of the attributes of each.
          inherited attributes go before the dot, synthesized after it.}
        var name: alfa; attr: attrList;



        procedure parseAttrs(inher: boolean);
            {parse a list of attributes}



            procedure pAttr;
                var dom: domain;
                begin parseDomain(dom); attr := consAtList(dom,inher,attr)
                end;

            begin
            if sy in domSys then begin
                pAttr;
                while sy=comma do begin nextSy; pAttr end
                end
            end {parseAttrs};



        procedure reverse;
            var next,last: attrList;
            begin
            last := nil;
            while attr<>nil do begin
                next := attr^.next;
                attr^.next := last;
                last := attr;
                attr := next
                end;
            attr := last
            end {reverse};

        begin
        checkNextSy(attrSy);
        repeat
            ok := true;
            name := varName;
            checkNextSy(nameSy);
            checkNextSy(lAngle);
            attr := nil;
            parseAttrs(true); checkNextSy(dot);
            parseAttrs(false); checkNextSy(rAngle);
            reverse; checkSemicolon;
            if ok then enterNt(name,attr)
        until sy in comSys
        end {attrCom};



    procedure printTerm(t: termIndex);
        begin
        write(listing,'"'); printName(listing,term[t].name); write(listing,'"')
        end {printTerm};



    procedure printSym(s: gramSym);
        begin
        write(listing,' ');
        if s.term then printTerm(s.idx)
        else printName(listing,nonterm[s.idx].name)
        end {printSym};



    procedure ruleCom;
        {read in semantic rules; write tables and rules onto semantic file.
          rule-part = "rule" name (: symbol "=" (:symbol:) ";" :).
          symbol = terminal | nonterminal.
          terminal = """" string of characters """".
          nonterminal = name "<" expression-list ">". }
        const maxCons = 20;    {limit of constraints}

        type
            semantics = record
                            exp: expression;        {attribute value}
                            pos: integer            {position in rule}
                        end;

        var
            leftRci: rcIndex;         {index of lhs of rule}
            termIdx: termIndex;       {terminal being processed}


            {constraints in the current rule}
            conCount: integer;
            con: array [1..maxCons] of semantics;


            {applied attribute expressions in the current rule}
            appliedCount: integer;
            applied: array [1..maxAttrs] of semantics;


            {defining attributes in the current rule}
            lhsCount,                  {left-hand-side inherited}
            rhsCount,                  {right-hand-side synthesized}
            pseudoCount: integer;      {pseudo}
            pseudo: array [1..maxAttrs] of expression;



        procedure extendRule(term: boolean; idx: integer);
            {extend the current rule with a grammar symbol}
            begin
            rcCount := rcCount+1;
            rc[rcCount].term := term;
            rc[rcCount].idx := idx
            end {extendRule};



        procedure addRule(leftRci: rcIndex);
            {add a syntax rule to the table 'rule'.  leftRci points to the
              rewritten symbol in 'rc'.}
            begin
            ruleCount := ruleCount+1;
            with rule[ruleCount] do begin
                rci := leftRci;
                length := rcCount-leftRci;
                userNum := ruleCount
                end
            end {addRule};



        procedure parseStartSymbol;
            {read in and process the start symbol of the grammar.
              augment the grammar for lr processing with the rule
              start = start$  "*eof"  }
            var name: alfa;  i,start: integer;
            begin
            name := varName;
            checkNextSy(nameSy);
            treeLookup(nontermTree,name,start,noSuchNonterm);
            {insert augmented start symbol "start$"}
            i := alfaleng-1;
            while name[i]=' ' do i := i-1;
            name[i+1] := '$';
            enterNt(name,nil);
            {augment grammar with rule "start$ = start ' eof'"}
            goalSymbol := nontermCount;
            extendRule(false,goalSymbol);
            extendRule(false,start);
            extendRule(true,eofTerm);
            addRule(1)
            end {parseStartSymbol};



        procedure constraint(x: expression);
            {add x as a constraint on the current rule.}
            begin
            conCount := conCount+1;
            con[conCount].exp := x;  con[conCount].pos := rcCount
            end;



        procedure defineAttrs(form,path: expression);
            {process the attributes of a defining position, which must
              be a variable, constant, or inverible function of such.
              'form' holds the attribute expression.  'path' is an
              expression to access the component represented by 'form'.}
            begin
            with form^ do
                case kind of
                    namedExp: if di<=forwCount then error(notDefining)
                               else defineAttrs(def[di].value,path);
                    variable: with attr[depth] do
                        if value=nil then value := path
                        else {multiply defined attribute variable}
                            constraint(consBinOp(eqSy,value,path));
                    constant: constraint(consBinOp(eqSy,form,path));
                    fixExp,lambdaExp,applic,cond,caseExp,unOp,binOp,
                    alterExp,project,isExp: error(notDefining);
                    pair: begin
                        defineAttrs(l, consUnOp(leftSy,path));
                        if ok then defineAttrs
                            (r, consUnOp(rightSy,path))
                        end;
                    inject: begin
                        {set silence flag on projection to prevent duplicate
                         error messages if constraint does not hold.}
                        constraint(consIsExp(si,path));
                        if exp<>voidExp
                        then defineAttrs(exp, consProject(si,true,path))
                        end
                    end {case}
            end {defineAttrs};



        procedure addPseudoAttr(def,value: expression);
            {define 'def' to have the 'value' by means of a pseudo-attr}
            begin
            pseudoCount := pseudoCount+1;
            pseudo[pseudoCount] := value;
            defineAttrs
            (def, consAttr(value^.dom,pseudoAttr,pseudoCount))
            end {pseudoAttr};



        procedure parseNonterm(atKind: attrKind; var definingCount: integer);
            {parse an attributed symbol.  atKind is lhs if on the left
              side of a rule, rhs for right side;
              definingCount is current 'lhsCount' or 'rhsCount'}
            var name: alfa;  i: integer;  x: expression;



            procedure parseAttrs(al: attrList);
                {parse an attribute list enclosed in < and >.}



                procedure parseAt;
                    {parse an attribute expression and check its domain.
                      if it is in a defining position, check its form. }
                    var x: expression;
                    begin
                    parseExp(x);
                    if al = nil then error(attrNum)
                    else begin
                        checkDoms(x^.dom,al^.dom);
                        {see if a defining or applied position}
                        if al^.inher and (atKind=lhsAttr)
                            or not al^.inher and (atKind=rhsAttr)
                        then begin
                            definingCount := definingCount+1;
                            defineAttrs
                            (x, consAttr(al^.dom,atKind,definingCount))
                            end
                        else begin
                            appliedCount := appliedCount+1;
                            applied[appliedCount].exp := x;
                            applied[appliedCount].pos := rcCount
                            end;
                        al := al^.next
                        end
                    end {parseAt};

                begin
                checkNextSy(lAngle);
                if sy <> rAngle then begin
                    parseAt;
                    while sy = comma do begin nextSy; parseAt end
                    end;
                checkNextSy(rAngle);
                if al<>nil then error(attrNum)
                end {parseAttrs};

            begin
            name := varName;
            checkNextSy(nameSy);
            treeSearch(nontermTree,name,i);
            err.name := name;
            if i<>0 then begin
                extendRule(false,i);
                parseAttrs(nonterm[i].attr)
                end
            else if atKind = lhsAttr then
                error(noSuchNonterm)    {predefined nonterms allowed only on rhs}
            else if name = 'ident          ' then begin
                extendRule(true,nameTerm);
                parseAttrs(nameAttr)
                end
            else if name = 'number         ' then begin
                extendRule(true,numberTerm);
                parseAttrs(numberAttr)
                end
            else if name = 'where          ' then begin
                checkNextSy(lAngle);
                parseExp(x);
                checkDoms(x^.dom,boolDom);
                constraint(x);
                checkNextSy(rAngle)
                end
            else if name = 'uniquename     ' then begin
                checkNextSy(lAngle);
                parseExp(x);
                checkDoms(x^.dom, stringDom);
                addPseudoAttr(x, consNExp(defUname));
                checkNextSy(rAngle)
                end
            else error(noSuchNonterm)
            end {parseNonterm};



        procedure listAttrs;
            {list the constraints and values of the attributes}
            var i: integer;
            begin
            for i := 1 to conCount do begin
                write(listing, '    constraint: ');
                printExp(listing, con[i].exp);
                writeln(listing)
                end;
            for i := 1 to attrCount do with attr[i] do begin
                write(listing, '    '); printName(listing,name);
                write(listing, '='); printExp(listing,value);
                writeln(listing)
                end;
            writeln(listing)
            end {listAttrs};



        procedure dumpAttrs;
            {dump applied attribute expressions and constraints}
            var i: integer;



            procedure putSem(s: semantics);
                {output a semantic formula, plus its position in the rule and
                  the index of the nonterminal generating it.}
                var nt: nontermIndex;
                begin
                putExp(s.exp, false);
                with rc[s.pos] do
                    if term then nt := 0    {terminal: name or number}
                    else nt := idx;
                {for ut to print error messages}
                putInt2(int2X, s.pos - leftRci, nt)
                end {putSem};

            begin
            putInt(intX,appliedCount);
            for i := 1 to appliedCount do putSem(applied[i]);
            putInt(intX,pseudoCount);
            for i := 1 to pseudoCount do begin
                putExp(pseudo[i],true); putInt2(int2X,0,0)
                end;
            putInt(intX,conCount);
            for i := 1 to conCount do putSem(con[i])
            end {dumpAttrs};



        procedure checkForward;
            {check that all forward references to attributes have been
              resolved.}
            var i: integer;
            begin
            for i := 1 to attrCount do
                if attr[i].value=nil then begin   {still undefined}
                    err.name := attr[i].name; error(forwRef)
                    end;
            end {checkForward};



        procedure parseWith;
            {parse the with part of a rule, defining attributes}
            var def,value: expression;
            begin
            while sy=withSy do begin
                nextSy; parseExp(def);
                checkNextSy(equals); parseExp(value);
                checkDoms(def^.dom, value^.dom);
                addPseudoAttr(def,value)
                end
            end {parseWith};



        procedure checkTerm(name: alfa);
            {check that a terminal symbol is well-formed:
              not blank, no embedded blanks, doesn't begin with digit,
              doesn't have both alphamerics and delimeters.  Trailing blanks 
	      are OK because the scanner pads the symbol with them.}
            var i,last: integer;   delim,blank,alphamer: boolean;
                ch: char;
            begin
            if name[1] in [' ','0'..'9'] then error(badTerminal)
            else begin
                delim := false;  alphamer := false;  blank := false; 
		last := alfaleng;  while name[last] = ' ' do last := last-1;
                for i := 1 to last do begin
                    ch := name[i];
                    if ch = ' ' then blank := true
		    else if ch in ['a'..'z', '0'..'9'] then alphamer := true
		    else delim := true
                    end {for};
                if blank or (delim and alphamer) then error(badTerminal)
                end {if}
            end {checkTerm};



        procedure printRules;
            var r: ruleIndex;  rci: rcIndex;  i: integer;
            begin
            heading(listing); writeln(listing, 'context-free syntax');
            for r := 1 to ruleCount do begin
                write(listing,r:3,' ');
                rci := rule[r].rci;
                printSym(rc[rci]); write(listing, ' =');
                for i := 1 to rule[r].length do printSym(rc[rci+i]);
                writeln(listing)
                end {for};
            writeln(listing)
            end {printRules};



        procedure sortRules;
            {sort the rules by their lhs nonterminal.  the nonterminals
              are ordered as given in the grammar.  sorting is necessary
              to group all rules of a nonterminal together.}
            var i,j: integer;  rj: ruleRec;  ntj: nontermIndex;
            begin
            rule[0].rci := 1;   {prevent error when i=1 below}
            for j := 2 to ruleCount do begin
                i := j;  rj := rule[j];  ntj := rc[rj.rci].idx;
                while (i>=2) and (rc[rule[i-1].rci].idx > ntj) do
                    begin rule[i] := rule[i-1];  i := i-1 end;
                rule[i] := rj
                end {for}
            end {sortRules};

        begin
        ruleCount := 0;  listSource := optListAttrs;
        checkNextSy(ruleSy); parseStartSymbol;
        if err.count = 0 then putTables;
        forwAttrs := true;
        repeat
            ok := true;
            lhsCount := 0; rhsCount := 0; pseudoCount := 0;
            appliedCount := 0; conCount := 0;
            attrCount := 0;
            parseNonterm(lhsAttr,lhsCount);
            checkNextSy(equals);
            leftRci := rcCount;
            while sy in [nameSy,stringSy] do begin
                if sy = nameSy then parseNonterm(rhsAttr,rhsCount)
                else begin {terminal}
                    checkTerm(stringVal);
                    if ok then begin
                        enterTerm(stringVal,termIdx);
                        extendRule(true,termIdx)
                        end;
                    nextSy
                    end
                end;
            parseWith;
            addRule(leftRci);
            if ok then checkForward;
            if err.count = 0 then dumpAttrs;
            if ok and optListAttrs then listAttrs;
            checkSemicolon
        until sy in comSys;
        put0(stopX); putInt(intX,ruleCount);
        printRules; sortRules;
        listSource := false;
        writeln(output, 'rules processed.')
        end {ruleCom};



    procedure processSyntax;
        {produce lalr(1) tables for the underlying context-free syntax}
        {references:
          a. v. aho and j. d. ullman, "principles of compiler design",
          -  addison-wesley, 1977, chapter 6  (table compression, etc.);
          david gries, "compiler construction for digital computers",
          -  john wiley, 1971, section 2.8 (grammar checks);
          w. r. lalonde, "an efficient lalr parser generator",
          -  university of toronto, computer systems research group
          -  technical report csrg-2, 1971  (lalr algorithm)}

        const hashLimit = 196;         {size of hash table for lr(0) states}
        type
            parseActions = (errAct,shift,reduce,accept);
            kernelIndex = 0..maxKernels;
            itemIndex = 0..maxItems;
            hashIndex = 0..hashLimit;


            {kernel items}
            itemList = ^itemNode;
            itemNode =
            packed record
                       r: ruleIndex;      {rule of the item}
                       dot: rcIndex;      {position of the dot}
                       dotSym: gramSym;  {symbol after dot if any}
                       next: itemList;    {next item}
                   end;


            {list to hold lookahead symbols}
            lookList = ^lookNode;
            lookNode = packed record t: termIndex; next: lookList  end;


            actionList = ^actionNode;
            actionNode = packed
            record
                next: actionList;
                case kind: parseActions of
                     shift: (idx: 0..999;             {symbol to shift}
                             state: kernelIndex);    {next state}
                     reduce: (ruleNo: ruleIndex;    {rule to reduce by}
                              looks: lookList)       {lookahead symbols}
            end;

            {list to hold predecessor states}
            predList = ^predNode;
            predNode = record
                            accessState: kernelIndex; {previous kernel}
                            next: predList;
                        end;

            {array of items for forming closures}
            stateType = array[1..maxItems] of itemNode;

        var
            kernelCount: kernelIndex;      {number of kernels in existence}
            kernel: array[1..maxKernels] of
            packed record
                       predSymbol: gramSym;   {access symbol of kernel}
                       preds: predList;        {predecessor kernels}
                       items: itemList;        {items of the kernel}
                       actions,                 {terminal transitions}
                       nshifts: actionList;    {nonterminal transitions}
                       next: kernelIndex       {next in hash-table list}
                   end;

            nullSym: gramSym;         {nonexistent symbol}
            lastConflict: kernelIndex;



        procedure scanNonterm;
            {find the first rule rewriting each nonterminal.}
            var r: ruleIndex;  nt: nontermIndex;
            begin
            r := 1;
            for nt := 1 to nontermCount do begin
                {skip rules rewriting earlier nt's}
                while rc[rule[r].rci].idx < nt do r := r+1;
                nonterm[nt].lhs := r
                end;
            {set up dummy nt for getting rule-range of last nt}
            with nonterm[nontermCount+1] do begin
                name := '               ';
                lhs := ruleCount+1;
                attr := nil
                end
            end {scanNonterm};



        procedure checkSentence;
            {checks that all rules derive sentences}
            var marked: array[nontermIndex] of boolean;
                hung: boolean;
                nt: nontermIndex;  r,r1: ruleIndex;



            function checkRule(r: ruleIndex): boolean;
                {checks a rule for terminality}
                var start,stop: rcIndex;   good: boolean;   s: gramSym;
                begin
                start := rule[r].rci;
                stop := start + rule[r].length;
                good := true;
                {check that rhs is all terminals or good nonterminals}
                while good and (start < stop) do begin
                    start := start+1;
                    s := rc[start];
                    if not s.term then good := marked[s.idx]
                    end;
                checkRule := good
                end {checkRule};

            begin
            for nt := 0 to nontermCount do marked[nt] := false;
            repeat
                hung := true;           {check that this pass does something}
                for nt := 1 to nontermCount do begin
                    r := nonterm[nt].lhs; r1 := nonterm[nt+1].lhs;
                    {check all rules rewriting this nonterminal}
                    while not marked[nt] and (r<>r1) do begin
                        if checkRule(r) then
                            begin marked[nt] := true; hung := false end;
                        r := r+1
                        end
                    end {for}
            until hung;
            for nt := 1 to nontermCount do
                if not marked[nt] then begin
                    err.name := nonterm[nt].name;
                    error(noStrings)
                    end
            end {checkSentence};



        procedure checkDerive;
            {check that all symbols may be derived from start symbol}
            var marked: array[nontermIndex] of boolean;
                nt: nontermIndex;  r,r1: ruleIndex;
                hung: boolean;  s: gramSym;
                rci,start,stop: rcIndex;
            begin
            for nt := 0 to nontermCount do marked[nt] := false;
            marked[goalSymbol] := true;
            repeat
                hung := true;
                for nt := 1 to nontermCount do
                    if marked[nt] then begin
                        r1 := nonterm[nt+1].lhs;
                        {scan every rule rewriting this nonterminal}
                        for r := nonterm[nt].lhs to r1-1 do begin
                            start := rule[r].rci;
                            stop := start + rule[r].length;
                            for rci := start+1 to stop do begin
                                s := rc[rci];
                                if not s.term then begin
                                    hung := hung and marked[s.idx];
                                    marked[s.idx] := true
                                    end
                                end
                            end
                        end
            until hung;
            for nt := 1 to nontermCount do
                if not marked[nt] then
                    begin err.name := nonterm[nt].name; error(unreachable) end
            end {checkDerive};



        procedure printSymbols;
            {list the terminal and nonterminal symbols in the grammar}
            var oneLine,i: integer;
            begin
            {items to print per line}
            oneLine := maxLineLen div (alfaleng+1);
            heading(listing);
            write(listing, termCount:1, ' terminal symbols:');
            for i := 1 to termCount do begin
                if i mod oneLine = 1 then writeln(listing);
                write(listing,term[i].name,' ')
                end;
            writeln(listing); writeln(listing);
            write(listing, nontermCount:1, ' nonterminal symbols:');
            for i := 1 to nontermCount do begin
                if i mod oneLine = 1 then writeln(listing);
                write(listing,nonterm[i].name,' ')
                end;
            writeln(listing); writeln(listing)
            end {printSymbols};



        procedure copyKernel(k: kernelIndex; var state: stateType;
                              var itemCount: itemIndex);
            {copies the current kernel into the state }
            var il: itemList;
            begin
            il := kernel[k].items;
            itemCount := 0;
            while il <> nil do begin
                itemCount := itemCount + 1;
                state[itemCount] := il^;
                il := il^.next
                end
            end {copyKernel};



        procedure closeKernel(k: kernelIndex; var state: stateType;
                               var itemCount: itemIndex);
            { closes the current kernel into 'state'}
            var nextItem: itemIndex;  r,r1: ruleIndex;
                itemSymbol: gramSym;  nt: nontermIndex;



            procedure addItem(r: ruleIndex);
                {adds an item to the state, whose rule }
                {index is r, and marker position is 1       }
                begin
                itemCount := itemCount + 1;
                state[itemCount].r := r;
                state[itemCount].dot := 1;
                if rule[r].length=0 then state[itemCount].dotSym := nullSym
                else state[itemCount].dotSym := rc[rule[r].rci+1]
                end {addItem};



            function search(r: ruleIndex): boolean;
                {searches the state for an item x -> .w
                  where r is the index into the rule information table}
                var found: boolean;    i: itemIndex;
                begin
                i := 0;
                repeat
                    i := i + 1;
                    found := (state[i].r = r) and (state[i].dot = 1)
                until (i >= itemCount) or found;
                search := found
                end {search};

            begin
            {to close a kernel, for each item a -> x .b y add items
              b -> .u | .v | etc. that are not already in the closure.
              if at least one rule b -> .w is already in the closure,
              then all rules for b are.  }
            nextItem := 1;
            copyKernel(k,state,itemCount);
            repeat
                itemSymbol := state[nextItem].dotSym;
                if not itemSymbol.term then begin
                    nt := itemSymbol.idx;
                    if not search(nonterm[nt].lhs) then begin
                        r1 := nonterm[nt+1].lhs;
                        for r := nonterm[nt].lhs to r1-1 do addItem(r)
                        end
                    end;
                nextItem := nextItem + 1
            until nextItem > itemCount
            end {closeKernel};



        function consPred(k: kernelIndex; next: predList): predList;
            var p: predList;
            begin
            new(p); p^.accessState := k; p^.next := next; consPred := p
            end {consPred};



        function consLook(t: termIndex; next: lookList): lookList;
            var l: lookList;
            begin
            new(l); l^.t := t; l^.next := next; consLook := l
            end {consLook};



        procedure makeLr0;
            {produces the lr(0) set of items using the knuth-early algorithm}
            var itemCount,     {last item in state}
                it,it1: itemIndex;
                state: stateType;
                dotSym: gramSym;
                curKernel,k: kernelIndex;

                hashTab: array [0..hashLimit] of kernelIndex;
                h: hashIndex;



            function hash(r: ruleIndex; dot: integer): hashIndex;
                {hash function for looking up kernels}
                begin
                hash := (8*r + dot) mod (hashLimit+1)
                end {hash};



            function consItem(r: ruleIndex; dot: integer; next: itemList)
                : itemList;
                {'cons' a new item onto an item list}
                var i: itemList;
                begin
                new(i);
                i^.r := r;  i^.dot := dot; i^.next := next;
                if dot > rule[r].length then i^.dotSym := nullSym
                else i^.dotSym := rc[rule[r].rci + dot];
                consItem := i
                end {consItem};



            function consItemList(start,stop: itemIndex): itemList;
                {assemble the items in state[start..stop] into a new
                  item list, moving the dot to the right}
                var i: integer;   lastItem: itemList;
                begin
                lastItem := nil;
                for i := stop downto start do
                    lastItem :=
                    consItem(state[i].r,state[i].dot+1,lastItem);
                consItemList := lastItem
                end {consItemList};



            procedure addKernel(items: itemList; dotSym: gramSym);
                {adds a new kernel to the lr(0) set
                  returning the index to that kernel as the kernel number}
                var h: hashIndex;
                begin
                h := hash(items^.r, items^.dot);
                kernelCount := kernelCount + 1;
                kernel[kernelCount].next := hashTab[h];
                kernel[kernelCount].items := items;
                kernel[kernelCount].predSymbol := dotSym;
                kernel[kernelCount].actions := nil;
                kernel[kernelCount].nshifts := nil;
                kernel[kernelCount].preds := nil;
                hashTab[h] := kernelCount
                end {addKernel};



            procedure addReduce(r: ruleIndex);
                {adds a reduce action to the current kernel}
                var a: actionList;
                begin
                new(a); a^.kind := reduce; a^.looks := nil; a^.ruleNo := r;
                with kernel[curKernel] do
                    begin a^.next := actions; actions := a end
                end {addReduce};



            procedure addShift(nextState: kernelIndex; sym: gramSym);
                {adds a shift action to the current kernel}
                var a: actionList;
                begin
                new(a); a^.kind := shift; a^.idx := sym.idx;
                a^.state := nextState;
                with kernel[nextState] do
                    preds := consPred(curKernel,preds);
                with kernel[curKernel] do
                    if sym.term
                    then begin a^.next := actions; actions := a end
                    else begin a^.next := nshifts; nshifts := a end
                end {addShift};



            function matchKernel(start,last: itemIndex): integer;
                {will look for a kernel which matches
                  the sequence of items passed to it
                  returning the indx into the set of lr(0) kernels if
                  found, 0 otherwise}
                var k,match: kernelIndex;      same: boolean;
                    i: itemIndex;    il: itemList;
                begin
                with state[start] do k := hashTab[hash(r,dot+1)];
                match := 0;
                while (k<>0) and (match=0) do begin
                    i := start;    il := kernel[k].items;
                    same := true;
                    repeat
                        same := (state[i].r = il^.r)
                        and (state[i].dot+1 = il^.dot);
                        i := i + 1;    il := il^.next
                    until not same or (i > last) or (il = nil);
                    if same and (i>last) and (il=nil) then match := k;
                    k := kernel[k].next
                    end;
                matchKernel := match
                end {matchKernel};



            procedure orderKernel;
                {will order the items in a state using the}
                {marker symbol as the key, using a bubble sort !gasp!    }
                var i,j: itemIndex;    x: itemNode;



                function greater(a,b: itemNode): boolean;
                    begin
                    if a.dotSym.term = b.dotSym.term then
                        if a.dotSym.idx = b.dotSym.idx
                        then greater := a.r > b.r
                        else greater := a.dotSym.idx > b.dotSym.idx
                    else     greater := a.dotSym.term > b.dotSym.term
                    end {greater};

                begin
                for i := 2 to itemCount do begin
                    for j := itemCount downto i do
                        if greater(state[j-1], state[j]) then begin
                            x := state[j-1];   state[j-1] := state[j];
                            state[j] := x
                            end
                    end
                end {orderKernel};


            begin
            for h := 0 to hashLimit do hashTab[h] := 0;
            curKernel := 1;
            kernelCount := 0;
            {initialize kernel to <goal> -> . <start> $  }
            addKernel(consItem(goalRule,1,nil), nullSym);
            {loop to construct the lr(0) set}
            repeat
                closeKernel(curKernel,state,itemCount);
                orderKernel;
                it := 1;
                while (it <= itemCount) do begin
                    {find all items with the same marker symbol  }
                    dotSym := state[it].dotSym;
                    it1 := it;
                    if dotSym.idx = 0 then addReduce(state[it].r)
                    else begin
                        while (state[it1].dotSym.term=dotSym.term) and
                        (state[it1].dotSym.idx =dotSym.idx) and
                        (it1 <= itemCount)
                        do it1 := it1 + 1;
                        it1 := it1 - 1;
                        k := matchKernel(it,it1);
                        if k = 0 then begin
                            addKernel(consItemList(it,it1), dotSym);
                            k := kernelCount
                            end;
                        addShift(k,dotSym)
                        end;
                    it := it1 + 1
                    end;
                curKernel := curKernel + 1
            until curKernel > kernelCount
            end {makeLr0};



        procedure makeLalr1;
            {converts the lr(0) machine into the lalr(1)
              machine by adding the lookahead to each reduce action}
            type
                kernelSet = packed array [1..maxKernels] of boolean;

                {set of pred states -- size limit is arbitrary}
                predArray = array [1..100] of kernelIndex;
            var k: kernelIndex;        unresolvable: boolean;
                a: actionList;         nt: nontermIndex;
                used: array [1..maxNonterms] of kernelSet;
                empty: kernelSet;


                {count of actions for each terminal; >1 means conflict}
                lookCount: array [termIndex] of integer;


                {list of predecessor states}
                predCount: integer;
                predSt: predArray;


                {stack of reductions to propagate}
                {size is arbitrary but should approach the number of kernels}
                rdepth: integer;
                rstack: array[1..200] of
                packed record
                           lhs: nontermIndex;      {nonterminal being rewritten}
                           k: kernelIndex;         {state to look back from}
                           length: 0..999           {distance to look back}
                       end;



            procedure makePredSet(firstK: kernelIndex; n: integer);
                {takes a kernel k, the number of sets n
                  and returns the nth predecessor set p }
                var temp: array[boolean] of predArray; {intermediate preds}
                    cnt: array[boolean] of integer;     {counts of preds}
                    curSet,nextSet: boolean;
                    i,j,c: integer;   p: predList;
                begin
                curSet := false;
                temp[curSet][1] := firstK;
                cnt[curSet] := 1;
                for i := 1 to n do begin
                    nextSet := not curSet;
                    c := 0;
                    for j := 1 to cnt[curSet] do begin
                        p := kernel[temp[curSet][j]].preds;
                        while p <> nil do begin
                            c := c+1;
                            temp[nextSet][c] := p^.accessState;
                            p := p^.next
                            end
                        end;
                    cnt[nextSet] := c;
                    curSet := nextSet
                    end;
                predCount := cnt[curSet]; predSt := temp[curSet]
                end {makePredSet};



            procedure pushReduce(prevK,k: kernelIndex; a: actionList);
                {stack extra reduce actions for later processing.
                  prevK = 0 at initial call.  ignore reduction of goal rule.}
                var n: ruleIndex;
                begin
                if a^.ruleNo<>goalRule then begin
                    n := rule[a^.ruleNo].length;
                    rdepth := rdepth + 1;
                    rstack[rdepth].lhs := rc[rule[a^.ruleNo].rci].idx;
                    if (n = 0) or (prevK = 0) then begin
                        rstack[rdepth].k := k; rstack[rdepth].length := n
                        end
                    else begin
                        rstack[rdepth].k := prevK;
                        rstack[rdepth].length := n-1
                        end
                    end
                end {pushReduce};



            procedure extendLalr1(act: actionList);
                {computes the lookahead for an action
                  'act' in kernel 'k', given that the initial pred set
                  has already been found}
                var lhs: nontermIndex;         ti: termIndex;
                    shiftSt: kernelIndex;     a: actionList;
                    i: integer;
                    useSymb: array[termIndex] of boolean;
                begin
                for ti := 1 to termCount do useSymb[ti] := false;
                while rdepth <> 0 do begin
                    {propagate this reduce}
                    makePredSet(rstack[rdepth].k, rstack[rdepth].length);
                    lhs := rstack[rdepth].lhs;
                    rdepth := rdepth-1;
                    for i := 1 to predCount do
                        if not used[lhs][predSt[i]] then begin
                            used[lhs][predSt[i]] := true;
                            a := kernel[predSt[i]].nshifts;
                            {find out state parser will goto after reduce}
                            shiftSt := 0;
                            while shiftSt=0 do begin
                                if a^.idx = lhs then shiftSt := a^.state;
                                a := a^.next
                                end;
                            a := kernel[shiftSt].actions;
                            while a <> nil do begin
                                if a^.kind = shift then
                                    useSymb[a^.idx] := true
                                else if a^.kind = reduce then
                                    pushReduce(predSt[i],shiftSt,a);
                                a := a^.next
                                end
                            end
                    end;
                for ti := 1 to termCount do
                    if useSymb[ti] then act^.looks := consLook(ti,act^.looks)
                end {extendLalr1};



            procedure useResolution(k: kernelIndex;
                                     var unresolvable: boolean);
                {tries to resolve conflicts in kernel k;
                 sets 'unresolvable' accordingly}
                var
                    a: actionList;     {actions in kernel k}
                    l: lookList;       {lookahead of reduce action}
                    t: integer;

                    {maps each terminal to an action taken for it}
                    symAct: array[termIndex] of actionList;



                procedure checkSymbol(newAction: actionList;
                                       lookSymbol: termIndex);
                    {accept a new action and symbol.  if this is the first
                     action for the symbol, record it.  if there already
                     exists an action, resolve the conflict, delete the
                     losing action and record the winning action.}
                    var
                        oldAction: actionList;
                        choice: (old,new,neither,unresolved);



                    procedure resolveConflict;
                        {compare the old and new actions and set 'choice'
                         to the outcome.  don't resolve reduce-reduce
                         conflicts, or shift-reduce conflicts where the
                         reduce has no terminals on the rhs.}
                        var oldPrio,newPrio: integer;



                        function precedence(a: actionList): integer;
                            {get the precedence of action 'a'.
                             if action is shift x, then return precedence
                             of x.  if action is reduce a->rhs, then return
                             precedence of the rightmost terminal in rhs,
                             -1 if there is none.}
                            var start,stop: integer;  sym: gramSym;
                            begin
                            if a^.kind = shift
                            then precedence := term[a^.idx].priority
                            else begin
                                start := rule[a^.ruleNo].rci
                                +rule[a^.ruleNo].length;
                                stop := rule[a^.ruleNo].rci+1;
                                while (start>=stop) and not rc[start].term do
                                    start := start - 1;
                                sym := rc[start];
                                if not sym.term then {no terminals}
                                    precedence := -1
                                else precedence := term[sym.idx].priority
                                end;
                            end {precedence};

                        begin
                        oldPrio := precedence(symAct[lookSymbol]);
                        newPrio := precedence(newAction);
                        choice := unresolved;
                        {do not handle reduce/reduce conflicts.}
                        if ((oldAction^.kind<>reduce)
                            or (newAction^.kind<>reduce))
                            and (oldPrio<>-1) and (newPrio<>-1) then
                            begin
                            if newPrio < oldPrio then choice := new
                            else if newPrio > oldPrio then choice := old
                            else {equal precedence, use associativity}
                                case term[lookSymbol].resol of
                                    leftR:  {reduce}
                                        if newAction^.kind = reduce then
                                            choice := new
                                        else choice := old;
                                    rightR: {shift}
                                        if newAction^.kind = reduce then
                                            choice := old
                                        else choice := new;
                                    nonassocR: choice := neither;
                                    noneR: choice := unresolved
                                    end {case}
                            end
                        end {resolveConflict};



                    procedure remove(loser: actionList; t: termIndex);
                        {remove 't' from the action list 'loser'}
                        var l: lookList;
                        begin
                        lookCount[t] := lookCount[t] - 1;
                        if loser^.kind=shift then loser^.kind := errAct
                        else begin
                            l := loser^.looks;
                            if l^.t = t then loser^.looks := l^.next
                            else begin
                                while l^.next^.t <> t do l := l^.next;
                                l^.next := l^.next^.next
                                end
                            end
                        end {remove};



                    procedure printResolution(t: termIndex; a: actionList);
                        {report a successful resolution}
                        begin
                        write(listing, 'conflict on ');
                        printTerm(t);
                        write(listing,' resolved: ');
                        if a=nil then               writeln(listing,'error')
                        else if a^.kind=shift then  writeln(listing,'shift')
                        else                        writeln(listing,'reduce')
                        end {printResolution};

                    begin
                    oldAction := symAct[lookSymbol];
                    if oldAction = nil then symAct[lookSymbol] := newAction
                    else begin
                        resolveConflict;
                        case choice of
                            old: remove(newAction,lookSymbol);
                            new: begin
                                remove(oldAction,lookSymbol);
                                symAct[lookSymbol] := newAction
                                end;
                            neither:
                                begin
                                remove(oldAction,lookSymbol);
                                remove(newAction,lookSymbol);
                                symAct[lookSymbol] := nil
                                end;
                            unresolved: unresolvable := true
                            end {case};
                        if listStates and (choice <> unresolved) then
                            printResolution(lookSymbol,symAct[lookSymbol])
                        end;
                    end {checkSymbol};

                begin
                unresolvable := false;
                for t := 1 to termCount do symAct[t] := nil;
                a := kernel[k].actions;
                while a <> nil do begin
                    if a^.kind=shift then checkSymbol(a,a^.idx)
                    else if a^.kind = reduce then begin
                        l := a^.looks;
                        while l <> nil do
                            begin checkSymbol(a,l^.t); l := l^.next end;
                        end;
                    a := a^.next
                    end
                end {useResolution};



            procedure printState(k: kernelIndex);
                {prints out a kernel in the lalr set}
                var state: stateType;      itemCount,i: itemIndex;



                procedure printRule(r: ruleIndex; dot: integer);
                    {prints rule indexed by r, with marker before symbol 'dot'}
                    var i: rcIndex;
                    begin
                    with rule[r] do begin
                        write(listing, userNum:6, ' ');
                        printSym(rc[rci]);
                        write(listing,' =');
                        for i := rci+1   to rci+dot-1  do printSym(rc[i]);
                        write(listing,' .');
                        for i := rci+dot to rci+length do printSym(rc[i])
                        end;
                    writeln(listing)
                    end {printRule};



                procedure printActions(a: actionList; term: boolean);
                    {print terminal or nonterminal actions}
                    var sym: gramSym;



                    procedure printLooks(l: lookList);
                        {print the lookahead symbols of a reduce action.}
                        var cnt: integer;
                        begin
                        cnt := 0;
                        while l <> nil do begin
                            cnt := cnt+1;
                            if cnt mod 10=0 then begin {break up long lines}
                                writeln(listing); write(listing,' ':13)
                                end;
                            write(listing, '  ');
                            printTerm(l^.t);
                            l := l^.next
                            end
                        end {printLooks};

                    begin
                    while a<>nil do begin
                        if a^.kind=shift then begin
                            write(listing,'    shift ', a^.state:3, '  ');
                            sym.term := term;  sym.idx := a^.idx;
                            printSym(sym); writeln(listing)
                            end
                        else if a^.kind=reduce then begin
                            write(listing,'    reduce ',
                                  rule[a^.ruleNo].userNum:3);
                            printLooks(a^.looks);
                            writeln(listing)
                            end;
                        a := a^.next
                        end
                    end {printActions};



                procedure printPreds(p: predList);
                    {print the list of predecessor states: states that can
                      shift to this one}
                    begin
                    write(listing, ' ':10, 'access states');
                    while p<>nil do begin
                        write(listing, p^.accessState:4);
                        p := p^.next
                        end;
                    writeln(listing)
                    end {printPreds};

                begin
                writeln(listing); writeln(listing);
                write(listing,'kernel ',k:3);
                if k>1 then begin  {first kernel has no access symbol}
                    write(listing,'    access symbol: ');
                    printSym(kernel[k].predSymbol)
                    end;
                writeln(listing);
                printPreds(kernel[k].preds);
                copyKernel(k,state,itemCount);
                for i := 1 to itemCount do
                    printRule(state[i].r,state[i].dot);
                writeln(listing);
                printActions(kernel[k].actions,true);
                printActions(kernel[k].nshifts,false)
                end {printState};



            procedure previousConflict;
                {print the number of the previous conflict state so that
                 the user can find all of them.}
                begin
                if lastConflict <> 0 then
                    writeln(listing,'last conflict state ',lastConflict:1)
                end {previousConflict};



            procedure reportConflict;
                var t: termIndex;
                begin
                if not listStates then printState(k);
                write(listing, 'unresolved conflicts for: ');
                for t := 1 to termCount do
                    if lookCount[t] > 1 then
                        begin write(listing, '  '); printTerm(t) end;
                writeln(listing);
                previousConflict;
                lastConflict := k;
                writeln(listing);
                err.int := k; error(conflict)
                end {reportConflict};



            procedure checkConflict(k: kernelIndex; var conflict: boolean);
                {checks kernel k's action for any
                  conflict among their lookahead symbols   }
                var a: actionList;   l: lookList;
                    t: termIndex;



                procedure count(t: termIndex);
                    {count another use of this terminal in the state}
                    begin
                    lookCount[t] := lookCount[t] + 1;
                    conflict := conflict or (lookCount[t] > 1)
                    end {count};

                begin
                for t := 1 to termCount do lookCount[t] := 0;
                conflict := false;
                a := kernel[k].actions;
                while a <> nil do begin
                    if a^.kind = shift then count(a^.idx)
                    else if a^.kind=reduce then begin
                        l := a^.looks;
                        while l <> nil do begin count(l^.t); l := l^.next end
                        end;
                    a := a^.next
                    end
                end {checkConflict};

            begin
            lastConflict := 0;
            for k := 1 to maxKernels do empty[k] := false;
            for k := 1 to kernelCount do begin
                a := kernel[k].actions;
                while a <> nil do begin {add lookahead to each reduce}
                    if a^.kind = reduce then begin
                        for nt := 1 to nontermCount do used[nt] := empty;
                        rdepth := 0;
                        pushReduce(0,k,a);
                        extendLalr1(a)
                        end;
                    a := a^.next
                    end;
                if listStates then printState(k);
                checkConflict(k,unresolvable);
                if unresolvable and resolGiven then
                    useResolution(k,unresolvable);
                if unresolvable then reportConflict
                end;
            previousConflict
            end {makeLalr1};



        procedure makeTables;
            var firstTime: boolean;    {signals first  elem for putShortInt}
                firstInt: integer;     {value of first element}

                {rows already constructed}
                tab: packed array [0..8000] of shortInt;

                {mapping from states to rows of table (allows row folding)}
                map: array [1..maxKernels] of integer;

                {non-zero range of each row}
                range: array [0..maxKernels]
                of record low,high: integer end;

                tableSize: integer;            {total size of all tables}



            procedure putShortInt(s: shortInt);
                {pack halfwords onto the output file.
                  'firstTime' begins each pair.}
                begin
                if firstTime then firstInt := s
                else putInt2(int2X,firstInt,s);
                firstTime := not firstTime
                end {putShortInt};



            procedure beginShort;
                {initiate a stream of short integers}
                begin firstTime := true end;



            procedure endShort;
                {terminate a stream of short integers, emptying the buffer}
                begin putShortInt(0) end;



            procedure putParseTable(rowCnt,rowWidth: integer);
                {put the completed table onto the output file}
                var k: kernelIndex;  i,size: integer;
                begin
                putInt2(int2X,rowWidth,rowCnt);
                beginShort;
                {output the state->row map}
                for k := 1 to kernelCount do putShortInt(map[k]);
                {output the rows themselves}
                size := rowCnt*rowWidth;
                for i := 0 to size-1 do putShortInt(tab[i]);
                endShort;
                tableSize := tableSize + size;
                writeln(listing,' table: ', rowCnt:1, ' rows; ',
                        size:1, ' elements.')
                end {putParseTable};



            procedure makeActionTable;
                var i,rowWidth,rowCnt,rowk: integer;
                    match: boolean;
                    k: kernelIndex;   a: actionList;   l: lookList;



                function compare(i: integer): boolean;
                    {see if row i matches the current row}
                    var match: boolean; j,rowi: integer;
                    begin
                    j := 0;
                    match := true;
                    rowi := rowWidth*i;
                    while (j < rowWidth) and match do begin
                        match := tab[rowi+j] = tab[rowk+j];
                        j := j + 1
                        end;
                    compare := match
                    end {compare};



                procedure setAction(p: parseActions; t: termIndex);
                    {pack an action into two bits of a byte}
                    var q: integer;
                    begin
                    case t mod 4 of
                        0: q := ord(p)*64;
                        1: q := ord(p)*16;
                        2: q := ord(p)*4;
                        3: q := ord(p)
                        end {case};
                    tab[rowk + t div 4] := tab[rowk + t div 4] + q
                    end {setAction};

                begin
                {initialize indexes to table, state map}
                rowWidth := 1 + termCount div 4;
                rowCnt := 0;  rowk := 0;
                for k := 1 to kernelCount do begin
                    {fill in action row for current kernel}
                    for i := 0 to rowWidth-1 do tab[rowk+i] := 0;
                    a := kernel[k].actions;
                    while a <> nil do begin
                        case a^.kind of
                            shift: if a^.idx=eofTerm
                                   then setAction(accept,eofTerm)
                                   else setAction(shift,a^.idx);
                            reduce:
                                begin
                                l := a^.looks;
                                while l <> nil do begin
                                    setAction(a^.kind,l^.t); l := l^.next
                                    end
                                end;
                            errAct,accept: {  }
                            end {case};
                        a := a^.next
                        end;
                    {check for row redundancy; fold if duplicated   }
                    i := 0;
                    match := false;
                    while (i < rowCnt) and not match do begin
                        match := compare(i);
                        i := i + 1;
                        end;
                    if match then map[k] := i-1
                    else begin
                        map[k] := rowCnt;
                        rowCnt := rowCnt+1;  rowk := rowk+rowWidth
                        end
                    end;
                write(listing, 'action');
                putParseTable(rowCnt,rowWidth)
                end {makeActionTable};



            procedure makeGotoTable(term:boolean; rowWidth: integer);
                {make terminal or nonterminal goto table depending on term.
                  rowWidth is the number of (non)terminals.}
                var i: integer;  k: kernelIndex;
                    rowCnt,rowk: integer;



                procedure makeRow(a: actionList);
                    var l: lookList;
                    begin
                    while a <> nil do begin
                        case a^.kind of
                            shift: tab[rowk+a^.idx] := a^.state;
                            reduce:
                                begin
                                l := a^.looks;
                                while l <> nil do begin
                                    tab[rowk+l^.t] := a^.ruleNo; l := l^.next
                                    end
                                end;
                            errAct,accept: {  }
                            end {case};
                        a := a^.next
                        end
                    end {makeRow};



                procedure foldRow(k: kernelIndex);
                    {see if current row matches any previous row;
                      zeroes are "don't care" entries}
                    var low,high,start,stop,
                        i,j,rowi,eli,elk: integer;
                        match: boolean;
                    begin
                    low := 1;
                    while (low<rowWidth) and (tab[rowk+low]=0) do
                        low := low+1;
                    high := rowWidth;
                    while (high>1) and (tab[rowk+high]=0) do high := high-1;
                    i := -1;  match := false;
                    while (i < rowCnt-1) and not match do begin
                        i := i+1;
                        start := max(range[i].low, low);
                        stop  := min(range[i].high,high);
                        rowi := rowWidth*i - 1;
                        match := true;  j := start-1;
                        while match and (j < stop) do begin
                            j := j+1;
                            eli := tab[rowi+j];
                            elk := tab[rowk+j];
                            match := (eli=0) or (elk=0) or (eli=elk);
                            end
                        end;
                    if match then begin
                        map[k] := i;
                        for j := low to high do
                            if tab[rowi+j]=0 then tab[rowi+j] := tab[rowk+j];
                        range[i].low  := min(range[i].low ,low);
                        range[i].high := max(range[i].high,high);
                        end
                    else begin
                        map[k] := rowCnt;
                        range[rowCnt].low  := low;
                        range[rowCnt].high := high;
                        rowCnt := rowCnt+1;  rowk := rowk+rowWidth
                        end
                    end {foldRow};

                begin
                rowCnt := 0;  rowk := -1;
                for k := 1 to kernelCount do begin
                    for i := 1 to rowWidth do tab[rowk+i] := 0;
                    if term then makeRow(kernel[k].actions)
                    else makeRow(kernel[k].nshifts);
                    foldRow(k)
                    end;
                if term then write(listing,'terminal')
                else write(listing,'non-terminal');
                putParseTable(rowCnt,rowWidth)
                end {makeGotoTable};



            procedure makeRuleTable;
                {for each rule store length, original number, goal symbol}
                var r: ruleIndex;
                begin
                beginShort;
                for r := 1 to ruleCount do begin
                    putShortInt(rule[r].length);
                    putShortInt(rule[r].userNum);
                    putShortInt(rc[rule[r].rci].idx)
                    end;
                endShort
                end {makeRuleTable};

            begin
            tableSize := 0;
            writeln(listing); writeln(listing);   {space before table listings}
            makeRuleTable;
            putInt(intX,kernelCount);
            makeActionTable;
            makeGotoTable(true,termCount);
            makeGotoTable(false,nontermCount);
            writeln(listing, 'total table size: ', tableSize:1)
            end {makeTables};



        procedure init;
            begin nullSym.term := true;  nullSym.idx := 0 end;

        begin
        goalRule := ruleCount;        {sorting puts goal rule last}
        ok := true;
        scanNonterm; checkSentence; checkDerive;
        printSymbols;
        if ok then begin
            init;    makeLr0;
            heading(listing);
            makeLalr1;
            writeln(listing);
            writeln(listing,'number of states: ',kernelCount: 1);
            writeln(listing);
            if err.count=0 then makeTables
            end
        end {processSyntax};



    procedure openFiles;
        var fn: fileName;  len: integer;



        procedure setExtension(var fn: fileName; ext: fileExt);
            begin
            fn[len+1] := '.';
            fn[len+2] := ext[1]; fn[len+3] := ext[2]; fn[len+4] := ext[3]
            end {setExtension};

        begin
        writeln(output, 'Semantic grammar analyzer');
        write(output, 'language: '); 
  	len := 0;   fn := '                    ';
	while not eoln(input) do 
	    begin  len := len+1;  read(input, fn[len])  end;
        setExtension(fn,'sg '); reset(grammar, fn);
        setExtension(fn, 'lst'); rewrite(listing, fn); listFileName := fn;
        setExtension(fn, 'ldf'); rewrite(ldf, fn);  ldfFileName := fn
        end {openFiles};



    procedure initNextSy;
        {initialize lexical analysis}
        begin
        with line do begin
            count := 0; prevLen := 0; col := 1; len := 0
            end;
        nextChar; nextSy
        end {initNextSy};



    procedure initOpMap;
        var sy: symbol;
        begin
        for sy := firstOp to lastOp do opMap[sy] := stopX;
        opMap[leftSy] := leftX;
        opMap[rightSy] := rightX;
        opMap[notSy] := notX;
        opMap[plus] := plusX;
        opMap[minus] := minusX;
        opMap[star] := timesX;
        opMap[divSy] := divX;
        opMap[modSy] := modX;
        opMap[ltSy] := ltX;
        opMap[eqSy] := eqX
        end {initOpMap};



    procedure initSyntax;
        {initialze variables concerning processing of the syntax}
        begin
        termCount := 0;  termTree := nil;
        enterTerm('*eof           ',eofTerm);
        enterTerm('*name          ',nameTerm);
        enterTerm('*number        ',numberTerm);
        nontermCount := 0; nontermTree := nil;
        nameAttr := consAtList(stringDom,false,nil);
        numberAttr := consAtList(intDom,false,nil);
        ruleCount := 0; rcCount := 0
        end {initSyntax};

    begin
    comSys := [eofSy,endSy,domSy,propagSy,forwSy,defSy,resolSy,
                attrSy,ruleSy];
    domSys := [nameSy,lBrack,lParen];
    initOpMap; openFiles; initNextSy; initSyntax;
    heading(listing);
    if sy = domSy then domCom;
    if sy = propagSy then propagCom;
    if sy = forwSy then forwCom;
    forwCount := defCount;           {note number of forward decls}
    if sy = defSy then defCom;
    if sy = attrSy then attrCom;
    if sy = ruleSy then ruleCom;
    resolGiven := sy = resolSy;       {note presence of resolution part}
    if sy = resolSy then resolCom;
    if sy <> endSy then error(noEndToken);
    if err.count = 0 then processSyntax;
    if err.count=0 then putTerminals;
    writeln(listing, 'total runtime: ',(clock-firstRuntime) div 1000:1,
            ' seconds');
    {delete language description file unless input was perfect}
    if err.count<>0 then rewrite(ldf,ldfFileName);
    writeln(output, err.count:1, ' errors in grammar');
    writeln(listing, err.count:1, ' errors in grammar')
    end {go};



procedure init;



    procedure initResword;



        procedure res(sy: symbol; name: alfa);
            {enter a keyword}
            begin
            reswordCount := reswordCount+1;
            resword[reswordCount].name := name;
            resword[reswordCount].sy := sy;
            syName[sy] := name;
            treeEnter(reswordTree,name,reswordCount)
            end {res};

        begin
        reswordCount := 0;  reswordTree := nil;
        res(ifSy,      'if             ');
        res(thenSy,    'then           ');
        res(elseSy,    'else           ');
        res(fiSy,      'fi             ');
        res(caseSy,    'case           ');
        res(ofSy,      'of             ');
        res(esacSy,    'esac           ');
        res(letSy,     'let            ');
        res(letrecSy,  'letrec         ');
        res(inSy,      'in             ');
        res(fixSy,     'fix            ');
        res(botSy,     'bot            ');
        res(trueSy,    'true           ');
        res(falseSy,   'false          ');
        res(isSy,      'is             ');
        res(leftSy,    'left           ');
        res(rightSy,   'right          ');
        res(divSy,     'div            ');
        res(modSy,     'mod            ');
        res(andSy,     'and            ');
        res(orSy,      'or             ');
        res(ltSy,      'lt             ');
        res(gtSy,      'gt             ');
        res(eqSy,      'eq             ');
        res(leSy,      'le             ');
        res(geSy,      'ge             ');
        res(neSy,      'ne             ');
        res(notSy,     'not            ');
        res(cross,      'x              ');
        res(defSy,     'define         ');
        res(domSy,     'domain         ');
        res(propagSy,  'propagate      ');
        res(forwSy,    'forward        ');
        res(resolSy,   'resolution     ');
        res(attrSy,    'attribute      ');
        res(ruleSy,    'rule           ');
        res(nonassocSy,'nonassoc       ');
        res(unspecSy,  'unspec         ');
        res(withSy,    'with           ');
        res(endSy,     'end            ')
        end {initResword};



    procedure initDom;
        begin
        domCount := 0; domTree := nil;
        enterDom('int            ', nil, false);
        enterDom('bool           ', nil, false);
        enterDom('name           ', nil, false);
        enterDom('void           ', nil, false);
        enterDom('$error         ', nil, false);
        intDom    := consNDom(1);
        boolDom   := consNDom(2);
        stringDom := consNDom(3);
        voidDom   := consNDom(4);
        errorDom  := consNDom(5);
        preDomCount := domCount
        end {initDom};



    procedure initBool;
        var b: boolean;
        begin
        for b := false to true do begin
            boolExp[b] := consConst(boolDom,bool);  boolExp[b]^.v.b := b
            end;
        end {initBool};

    begin
    with err do begin count := 0; dom1 := nil; dom2 := nil end;
    initResword; initDom; initBool;
    defCount := 0;  defTree := nil;
    enterDef(stringDom,'$uniquename    ',nil,false);
    selectCount := 0;  selectTree := nil;
    attrCount := 0;
    voidBv.name := consNtLeaf('void           ');  voidBv.dom := voidDom;
    voidExp := consConst(voidDom,bot);
    errorX := consConst(boolDom,bot);
    forwAttrs := false; inDoms := false; listSource := false
    end {init};

begin
lastRuntime := clock;  firstRuntime := lastRuntime;
optListAttrs := false;        {option to list the attributes of each rule}
listStates := false;           {option to list parser states}
init;go
end.
