(*  Title:      HOL/Induct/Mutil
    ID:         $Id: Mutil.thy,v 1.9 2000/09/12 08:27:16 paulson Exp $
    Author:     Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1996  University of Cambridge

The Mutilated Chess Board Problem, formalized inductively
  Originator is Max Black, according to J A Robinson.
  Popularized as the Mutilated Checkerboard Problem by J McCarthy
*)

Mutil = Main +

consts     tiling :: "'a set set => 'a set set"
inductive "tiling A"
  intrs
    empty  "{} : tiling A"
    Un     "[| a: A;  t: tiling A;  a Int t = {} |] ==> a Un t : tiling A"

consts    domino :: "(nat*nat)set set"
inductive domino
  intrs
    horiz  "{(i, j), (i, Suc j)} : domino"
    vertl  "{(i, j), (Suc i, j)} : domino"

constdefs
  coloured  :: "nat => (nat*nat)set"
   "coloured b == {(i,j). (i+j) mod #2 = b}"

end
