(*  Title:      Pure/NJ
    ID:         $Id: NJ.ML,v 1.11 1996/02/06 11:44:32 clasohm Exp $
    Author:     Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1993  University of Cambridge

Compatibility file for Standard ML of New Jersey.
*)


(*Determine if we are running under 0.93 or a newer version of SML/NJ
  This is based on the variable "version" defined in 0.93's System structure
  which is no longer present in 1.09.*)

local val version = ""; open System in
  val smlversion = if version <> "" then 93 else 109
end;

use (if smlversion = 93 then "NJ093.ML" else "NJ1xx.ML");


(** Other functions which are not specific to 0.93 or 1.xx*)

(*redefine to flush its output immediately -- temporary patch suggested
  by Kim Dam Petersen*)
val output = fn(s, t) => (output(s, t); flush_out s);

(*Dummy version of the Poly/ML function*)
fun commit() = ();
