(*  Title: 	ROOT
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1990  University of Cambridge

Root file for pure Isabelle: all modules in proper order for loading
Loads pure Isabelle into an empty database.

To build system, use Makefile (Poly/ML) or Makefile.NJ (New Jersey ML)
*)

val version = "91/1";

open PolyML;  print_depth 1;  

(*I/O.  Defines separate identifier for terminal output channel.*)
fun prs s = output(std_out,s);
fun writeln s = prs (s ^ "\n");

use "library.ML";
use "term.ML";
use "symtab.ML";
use "queue.ML";
use "pretty.ML";

(*should belong to Pure???*)
print_depth 0;  
structure Symtab = SymtabFun();
structure Queue = QueueFun();
structure Pretty = PrettyFun(Queue);

cd "EARLEY";
use "ROOT.ML";
cd "..";

print_depth 1;  
use "sign.ML";
use "sequence.ML";
use "envir.ML";
use "unify.ML";
use "logic.ML";
use "thm.ML";
use "stringtree.ML";
use "tctical.ML";
use "tactic.ML";
use "conv.ML";
use "goals.ML";

use "pure.ML";		(*combines sign up to goals*)

use "simp.ML";		(*simplifier functor: used in object logics*)

(*Will be shared by all object-logics.*)
structure Pure = PureFun();
