(*  Title: 	LK/set/ex/prod
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1989  University of Cambridge

Cartesian Products: Example of making a new theory

Must be loaded after LK/set/ex/pairing (needs equal_pairs_left)
*)

local open Syntax
in  val mixfix = [ Infixr("*", [Aterm,Aterm]--->Aterm, 60) ];
    val prod_ext = {logical_types=[],
     		     mixfix=mixfix,
		     parse_translation=[],
		     print_translation=[]};

    val prod_const_decs = constants mixfix @ [(["Dom","Ran"], Aterm-->Aterm)];

    val prod_syn = Syntax.extend Set_Syntax.syn prod_ext;
end;

val prod_thy = enrich_theory Set_Rule.thy  "prod" 
    ([], prod_const_decs,  prod_syn)

  [ ("Prod_def", "A*B == [ x || x: Pow(Pow(A Un B)),   \
\	      		EX a. EX b. a:A & b:B & x= <a,b> ]"),
  
    ("Dom_def",
	  "Dom(C) ==  [ a || a: Union(Union(C)), EX b. <a,b> : C ]"),
  
    ("Ran_def",
	  "Ran(C)  ==  [ b || b: Union(Union(C)), EX a. <a,b> : C ]") ];

(*Bind axioms to ML identifiers*)

val ax = get_axiom prod_thy;

val Prod_def = ax"Prod_def";
val Dom_def = ax"Dom_def";
val Ran_def = ax"Ran_def";


val prod_defs = [Prod_def, Dom_def, Ran_def];


(**** Product operator ( * )   ****)

val prpack = ([setcons_right_s, Collect_right, Pow_right, Pow_left, 
	       Un_right, subset_null_right],        []);

val prod_right = prove_goal prod_thy
    "[| $H |- $E, $F, a : A;  $H |- $E, $F, b : B |] \
\    ==> $H |- $E, <a,b> : A * B, $F"
 (fn prems=>
  [ (cut_right_tac "a:A & b:B" 1),
    (rewrite_goals_tac [Pair_def, Prod_def]),
    (repeat_goal_tac [triv_pack, prpack, LK_pack] 2),
    (REPEAT (resolve_tac (prems@[conj_right]) 1)) ]);


val prlpack = ([Collect_left, equal_pairs_left], []);

val prod_left = prove_goal prod_thy
    "$H, $G, a:A, b:B |- $E ==> $H, <a,b> : A*B, $G |- $E"
 (fn prems=>
  [ (cut_left_tac "a:A & b:B" 1),
    (rewrite_goals_tac [Prod_def]),
    (repeat_goal_tac [triv_pack, prlpack, LK_pack]  1), (*5 secs*)
    (REPEAT (repeat_goal_tac [triv_pack, ([eqmem_left_thin],[])] 1)), 
    (REPEAT (resolve_tac (prems@[conj_left]) 1)) ]);


(*Domain of a relation*)

(*"b" is new variable. *)
val prems =
goal prod_thy
    "$H |- $E, $F, <a,b> : C ==> $H |- $E, a: Dom(C), $F";
by (resolve_tac [cut] 1);
by (thin_tac 1  THEN  resolve_tac prems 1);
by (rewrite_goals_tac [Pair_def, Dom_def]);
by (setpc_tac 1);
val Dom_right_thin = result();


val prems = goal prod_thy
    "(!x.$H, $G, <a,x> : C |- $E) ==> $H, a: Dom(C), $G |- $E";
by (cut_left_tac "EX b. <a,b> : C" 1);
by (rewrite_goals_tac [Dom_def]);
by (setpc_tac 1);
by (REPEAT (resolve_tac (prems@[exists_left]) 1));
val Dom_left = result();


(*Range of a relation*)

(*refl is delayed to allow setcons_right to be applied fully*)
val rrpack = ([basic, Collect_right, setcons_right], [refl, Union_right_thin]);

(*"a" is new variable. *)
val prems = goal prod_thy
    "$H |- $E, $F, <a,b> : C ==> $H |- $E, b: Ran(C), $F";
by (resolve_tac [cut] 1);
by (thin_tac 1  THEN  resolve_tac prems 1);
by (rewrite_goals_tac [Pair_def, Ran_def]);
by (DEPTH_SOLVE_1 (repeat_goal_tac [rrpack, LK_pack] 1)); 
val Ran_right_thin = result();


val prems = goal prod_thy
    "(!x.$H, $G, <x,b> : C |- $E) ==> $H, b: Ran(C), $G |- $E";
by (cut_left_tac "EX a. <a,b> : C" 1);
by (rewrite_goals_tac [Ran_def]);
by (setpc_tac 1);
by (REPEAT (resolve_tac (prems@[exists_left]) 1));
val Ran_left = result();


val prod_pack = ([prod_right, prod_left, Dom_left, Ran_left],
	         [Dom_right_thin, Ran_right_thin]);

goal prod_thy "$H |- $E, Dom(A*B) <= A, $F";
by (repeat_goal_tac [triv_pack, prod_pack, set_pack] 1); 
val Dom_subset = result();

goal prod_thy "$H |- $E, Ran(A*B) <= B, $F";
by (repeat_goal_tac [triv_pack, prod_pack, set_pack] 1); 
val Ran_subset = result();


(*Examples*)
goal prod_thy "$H |- ~ (B<=0)  -->  A <= Dom(A*B)";
by (repeat_goal_tac [triv_pack, prod_pack, set_pack, LK_pack] 1); 
result();

goal prod_thy "$H |- $E, <a,b> : A*B  <->  a:A & b:B, $F";
by (repeat_goal_tac [triv_pack, prod_pack, set_pack, LK_pack] 1); 
result();

writeln"Reached end of file.";
