(*  Title: 	FOL/ruleshell
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1989  University of Cambridge

Natural Deduction Rules for Intuitionistic first-order logic 

After updating, rebuild  ".rules.ML"  by calling   "make-rulenames"   
*)


signature INT_RULE =
  sig
  structure FOL_Syntax: FOL_SYNTAX and Pure: PURE
	sharing FOL_Syntax.Syntax = Pure.Sign.Syntax
  val sign: Pure.Sign.sg
  val thy: Pure.theory
(*INSERT-RULESIG -- file produced by make-rulenames*)
  end;


functor Int_RuleFun (structure FOL_Syntax: FOL_SYNTAX and Pure: PURE
	sharing FOL_Syntax.Syntax = Pure.Sign.Syntax) : INT_RULE = 
struct
structure FOL_Syntax = FOL_Syntax;
structure Pure = Pure;
local open Pure 
in

val thy = enrich_theory pure_thy "FOL"
    (["term","form","prop"],  FOL_Syntax.const_decs,  FOL_Syntax.syn) 
[
  (*Equality*)

  ("refl",   "a=a"  ),

  ("sym",  "a=b ==> b=a"  ),

  ("trans",  "[| a=b;  b=c |] ==> a=c"),


  (*Propositional logic*)

  ("conj_intr",  "[| P;  Q |] ==> P&Q"  ),

  ("conjunct1", "P&Q ==> P"),

  ("conjunct2", "P&Q ==> Q"),


  ("disj_intr1",   "P ==> P|Q"  ),

  ("disj_intr2",   "Q ==> P|Q"  ),

  ("disj_elim",    "[| P|Q;  P ==> R;  Q ==> R |] ==> R"),


  ("imp_intr",  "(P ==> Q) ==> P-->Q"),

  ("mp", "[| P-->Q;  P |] ==> Q"),


  ("False_elim",   "False ==> P" ),


  ("True_def",  "True == False-->False"),
  ("not_def", 	"~P == P-->False"),
  ("iff_def",  "P<->Q == (P-->Q) & (Q-->P)"),


  (*Quantifiers*)

  ("all_intr",  "(!y. P(y)) ==> ALL x.P(x)"  ),

  ("spec", "ALL x.P(x) ==> P(a)"),


  ("exists_intr",  "P(a) ==> EX x.P(x)"  ),

  ("exists_elim",  "[| EX x.P(x);  !y.P(y) ==> R |] ==> R")
];

val sign = sign_of thy;

val ax = get_axiom thy;

(*INSERT-RULENAMES -- file produced by make-rulenames*)

end;
end;
