(*  Title: 	Syntax Definition
    Author: 	Tobias Nipkow
*)

signature MISC_SYNTAX =
sig
  val id_list: typ
  val abs_list_tr: term * term * term -> term
  val abs_list_tr': term * (string*typ)list * term -> term
end;

signature PURE_EXT =
sig
  structure Syntax_Def:SYNTAX_DEF0
  val pureExt : {logical_types: typ list, mixfix: Syntax_Def.mixfix list,
	 	parse_translation: (string * (term list -> term)) list,
	 	print_translation: (string * (term -> term)) list}
  val abs_const: string
  val appl_const: string
  include MISC_SYNTAX
end;

functor Pure_Ext_Fun(Syntax_Def:SYNTAX_DEF) : PURE_EXT =
struct

structure Syntax_Def = Syntax_Def;

local open Syntax_Def in

val abs_const = "_Abs()";
val appl_const = "_$";

(* Basic Isabelle Syntax *)

fun list_to_bt const = let fun bt[e]= e | bt(e::l)= const$e$bt l in bt end;

(* Larry's code from module Syntax *)
fun add_boundname oldnames (vars, (a,T)) : (string*typ) list =
    (variant (map fst vars @ oldnames) a, T) :: vars;

val id_list = Ground "_Id list";
val IdListop = "_Id list";
val IdListsy = [SId,id_list]---> id_list;
val idListConst = Const(IdListop,IdListsy);

fun abs_list_tr(const,idl,body) =
    let fun tr(Free(id,ty), t) = const $ absfree(id,ty,t)
          | tr(_ $ free $ idl, t) = tr(free,tr(idl,t));
    in tr(idl,body) end;

fun abs_list_tr'(const,vars,body) = 
      let val oldnames = add_term_names(body,[]);
	  val newvars = itlist_left (add_boundname oldnames) ([], vars);
          val newFvars = map Free newvars;
	  val newbody = subst_bounds(newFvars,body)
      in const $ list_to_bt idListConst (rev newFvars) $ newbody end;

fun idlist_tr(Free id_ty) = [id_ty] |
    idlist_tr(Const("_Id list",_)$Free id_ty$idl) = id_ty::idlist_tr idl;

val SAbsOp = "_%";

fun abs_tr[idl,body] = list_abs_free(idlist_tr idl,body)
and abs_tr'(abs) =
    abs_list_tr'(Const(SAbsOp,Adummy),strip_abs_vars abs,strip_abs_body abs);

val argsop = "_Args";
val argssy = [Any,Args]--->Args;

fun args_tr(Const("_Args",_)$arg$args,f) = args_tr(args,f$arg) |
    args_tr(arg,f) = f$arg;

fun app_tr [f,args] = args_tr(args,f);
fun app_tr' tm = let val (f,args) = strip_comb tm
                 in Const(appl_const',[Afn,Args]--->Adummy)$
                    f$(list_to_bt (Const(argsop,argssy)) args) end;

val Asms = Ground "_asms";
val Asms' = Ground "_asms'";

fun semi_impl_tr [asms,concl] =
    let fun tr(Const("_asms",_)$a$al) = Const("==>",Adummy)$a$(tr al)
	  | tr(Const("_;",_)$asms) = tr asms
	  | tr(_) = concl
    in tr asms end;

fun semi_intr(asm,concl) =
	let val pref = Const("_asms",[Aprop,Asms']--->Asms) $ asm
	in case concl of
	     Const("==>",_)$asm'$concl' =>
		let val (asms,concl) = semi_intr(asm',concl')
		in (pref$(Const("_;",Asms-->Asms')$asms),concl) end
	   | _ => (pref$Const("_eoasms",Asms'),concl)
	end;

fun constrain_tr[t,ty] =
    let fun mk_typ(Free(s,_)) = Ground s
	  | mk_typ(_$dom$ran) = mk_typ(dom) --> mk_typ(ran);
	val typ = mk_typ ty
    in Const("_constrain", typ --> typ) $ t end;

fun meta_impl_tr'(_$asm$(concls as Const("==>",_)$_$_)) =
	let val (asms,concl) = semi_intr(asm,concls)
	in Const("_;==>",[Asms,Aprop]--->Aprop)$asms$concl end
  | meta_impl_tr'(_$asm$concl)= Const("_==>",[Aprop,Aprop]--->Aprop)$asm$concl;

fun meta_impl_tr[asm,concl] = Const("==>",Adummy)$asm$concl;

fun meta_all_tr [idl,body] = abs_list_tr(Const("all",Adummy), idl, body);

val meta_all_sy = [id_list,Aprop]--->Aprop;
fun meta_all_tr'(tm as _$Abs(_,_,_)) =
    abs_list_tr'(Const("_!",meta_all_sy),strip_all_vars tm,strip_all_body tm);

val pureExt = {logical_types = [Any,Afn,Aprop],
mixfix=
[Mixfix("(3%_./ _)", [id_list,Any]--->Afn, SAbsOp, [0],0),
 Delimfix("_",Any-->Args,""),
 Delimfix("_,/_", argssy, argsop),
 Delimfix("_",SId-->id_list,""),
 Delimfix("_/ _",IdListsy,IdListop),

 (* meta-types: *)
 Delimfix("_",SId-->STyp,""),
 Delimfix("(1'(_'))",STyp-->STyp,""),
 Mixfix("_ => _", [STyp,STyp] ---> STyp, "_=>", [1,0], 0),

 Delimfix("_ $$ prop", Afn --> Aprop, ""),

 Delimfix("__", [Aprop,Asms']--->Asms, "_asms"),
 Delimfix("", Asms', "_eoasms"),
 Delimfix(";/ _", Asms --> Asms', "_;"),

 Mixfix("((3[| _ |]) ==>/ _)", [Asms,Aprop]--->Aprop, "_;==>", [0,1], 1),

 Infixr("==", [Any,Any]--->Aprop, 2),
 Mixfix("(_ ==>/ _)", [Aprop,Aprop]--->Aprop, "_==>", [2,1], 1),
 Mixfix("(3!_./ _)", meta_all_sy, "_!", [0],0)],
parse_translation =
[(appl_const',app_tr), (SAbsOp, abs_tr), ("_!", meta_all_tr),
 ("_==>",meta_impl_tr), ("_;==>",semi_impl_tr),
 ("_constrain", constrain_tr)],
print_translation =
[(appl_const, app_tr'), (abs_const, abs_tr'),
 ("all", meta_all_tr'), ("==>",meta_impl_tr')]
};

end;

end;
