(*  Title: 	HOL/ex/higher
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1989  University of Cambridge

Classical HOL: higher-order examples. 

by (Pc.onestep_tac 1);
by (Pc.step_tac asms 1);
by (Pc.comp_step_tac asms);
by (REPEAT (Pc.comp_step_tac asms));
by (Pc.comp_tac asms);
by (Pc.fast_tac asms 1);
*)

val asms =
goal HOL_Rule.thy "P&Q  <->  (ALL r:bool. (P-->Q-->form(r)) --> form(r))";
by (Pc.fast_tac asms 1);
result();

val asms =
goal HOL_Rule.thy
    "(P|Q)  <->  (ALL r:bool. (P-->form(r)) --> (Q-->form(r)) --> form(r))";
by (Pc.fast_tac asms 1);
result();

val asms =
goal HOL_Rule.thy
    "(EX x:A. P(x))  <->  \
\       (ALL r:bool. (ALL x:A. P(x)-->form(r)) --> form(r))";
by (Pc.fast_tac asms 1);
result();


(*Towards Cantor's Theorem -- but we give the answer away!*)
goal HOL_Rule.thy
    "~ (EX g: A->A->bool. EX j: A. ALL x:A. form(g`j`x) <-> ~ form(g`x`x))";
by (Pc.fast_tac [] 1);
result();


(*Finding the abstraction for Cantor's theorem.
  The answer just pops out (thru search!) *)
goal HOL_Rule.thy
    "ALL g: A->A->bool. EX f: A->bool. ALL j: A. EX x:A.  \
\       f`x = term(~ form(g`j`x)) : bool";
by (REPEAT (Pc.step_tac [] 1));
by (DEPTH_FIRST (has_fewer_prems 1)
	(FIRSTGOAL (ares_tac ([beta_conv] @ type_rls))));
result();


(*Cantor's Theorem.  Needs help with equality reasoning, but finds the
  right instantiation.*)
goal HOL_Rule.thy
    "~ (EX g: A->A->bool. ALL f: A->bool. EX j: A. f = g`j : A->bool )";
by (REPEAT (Pc.step_tac [] 1));
by (eresolve_tac [apply_equal] 1);
by (resolve_tac [refl] 1);
by (resolve_tac [trans RS equal_contr] 2);
by (assume_tac 3);
by (resolve_tac [sym] 2);
by (DEPTH_FIRST (has_fewer_prems 1)
	(FIRSTGOAL (ares_tac ([beta_conv] @ type_rls))));
result();


(** Reduction methods for (object-level!) higher order unification *)

(*Imitiation with m arguments on left and n arguments on right*)

fun imit_tac asms =
    DEPTH_SOLVE_1 (ares_tac (asms@type_rls@[refl, trans RES beta_conv]) 1
	ORELSE  subst2_tac "op`" 1);


val imitate_1_0 = prove_goal HOL_Rule.thy
    "[| G: K;  t: L |] ==> (lam x:L.G)`t = G : K"  
 (fn asms =>  [ (imit_tac asms) ]);

val imitate_1_1 = prove_goal HOL_Rule.thy
    "[| h`t = u : A;  h: L->A;  G: A->K;  t: L |] ==> \
\    (lam x:L.G`(h`x))`t = G`u : K"  
 (fn asms =>  [ (imit_tac asms) ]);

val imitate_1_2 = prove_goal HOL_Rule.thy
    "[| ha`t = ua : A;  hb`t = ub : B;  \
\	ha: L->A;  hb: L->B;  G: A->B->K;  t: L |] ==> \
\    (lam x:L.G`(ha`x)`(hb`x))`t = (G`ua)`ub : K"  
 (fn asms =>  [ (imit_tac asms) ]);

val imitate_1_3 = prove_goal HOL_Rule.thy
    "[| ha`t = ua : A;  hb`t = ub : B;  hc`t = uc : C;  \
\	ha: L->A;  hb: L->B;  hc: L->C;  G: A->B->C->K;  t: L |] ==> \
\    (lam x:L.G`(ha`x)`(hb`x)`(hc`x))`t = ((G`ua)`ub)`uc : K"  
 (fn asms =>  [ (imit_tac asms) ]);


(***Proof requires simplification
val imitate_2_0 = prove_goal HOL_Rule.thy
  "[| G: K;  ta: LA;  tb: LB |] ==> ((lam xa:LA. lam xb:LB.G)`ta)`tb = G : K"  
 (fn asms =>  [ (imit_tac asms) ]);
************)


val imitate_1_1' = prove_goal HOL_Rule.thy
    "[| h`t = u : B;  t: A;  h: A->B;  !y.y: B ==> a(y): C |] ==> \
\    (lam x:A.a(h`x))`t = a(u) : C" 
 (fn asms => 
  [ (DEPTH_SOLVE_1 (ares_tac
	(asms@type_rls@[refl, 
			trans RES beta_conv,
			subst1 RESN (2,asms)]) 1
	ORELSE  subst2_tac "op`" 1)) ]);

(*Finding the abstraction for Cantor's theorem.
  Here neg is an object-function and we get object-level ho unification *)
goal HOL_Rule.thy
    "ALL neg: bool->bool. ALL g: A->A->bool.   \
\       EX f: A->bool. ALL j: A. EX x:A. f`x = neg`(g`j`x) : bool";
by (REPEAT (Pc.step_tac [] 1));
by (REPEAT (FIRSTGOAL (ares_tac
	([imitate_1_2, imitate_1_1, imitate_1_0, beta_conv] @ type_rls))));
result();


writeln"Reached end of file.";
(*11 September 1988: loaded this file in 35 seconds*)
