(*  Title: HOL/ruleshell
    Author: Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1989  University of Cambridge

Rules of Higher-order Logic (Type Theory)

!!!After updating, rebuild  ".rules.ML"  by calling make-rulenames!!! 
*)

signature HOL_RULE =
  sig
  structure HOL_Syntax: HOL_SYNTAX and Pure: PURE
	sharing HOL_Syntax.Syntax = Pure.Sign.Syntax
  val sign: Pure.Sign.sg
  val thy: Pure.theory
(*INSERT-RULESIG -- file produced by make-rulenames*)
  val refl: Pure.thm
  val sym: Pure.thm
  val eq_type1: Pure.thm
  val eq_type2: Pure.thm
  val subst: Pure.thm
  val Lambda_type: Pure.thm
  val Lambda_congr: Pure.thm
  val apply_type: Pure.thm
  val beta_conv: Pure.thm
  val eta_conv: Pure.thm
  val pair_type: Pure.thm
  val sigma_elim: Pure.thm
  val pair_inject: Pure.thm
  val fst_type: Pure.thm
  val snd_type: Pure.thm
  val fst_conv: Pure.thm
  val snd_conv: Pure.thm
  val split_def: Pure.thm
  val subtype_intr: Pure.thm
  val subtype_elim1: Pure.thm
  val subtype_elim2: Pure.thm
  val Zero_type: Pure.thm
  val Succ_type: Pure.thm
  val rec_type: Pure.thm
  val rec_congr: Pure.thm
  val rec_conv0: Pure.thm
  val rec_conv1: Pure.thm
  val nat_induct: Pure.thm
  val classical: Pure.thm
  val imp_intr: Pure.thm
  val mp: Pure.thm
  val all_intr: Pure.thm
  val spec: Pure.thm
  val term_type: Pure.thm
  val term_conv: Pure.thm
  val form_intr: Pure.thm
  val form_elim: Pure.thm
  val term_congr: Pure.thm
  val refl_red: Pure.thm
  val red_if_equal: Pure.thm
  val trans_red: Pure.thm
  val False_def: Pure.thm
  val True_def: Pure.thm
  val conj_def: Pure.thm
  val disj_def: Pure.thm
  val exists_def: Pure.thm
  val not_def: Pure.thm
  val iff_def: Pure.thm
  val cond_def: Pure.thm
  val Pick_type: Pure.thm
  val Pick_congr: Pure.thm
  val Pick_intr: Pure.thm
  val member_def: Pure.thm
  val subset_def: Pure.thm
  val un_def: Pure.thm
  val int_def: Pure.thm
  val union_def: Pure.thm
  val inter_def: Pure.thm
  val pow_def: Pure.thm
  val void_def: Pure.thm
  val unit_def: Pure.thm
  val plus_def: Pure.thm
  val Inl_def: Pure.thm
  val Inr_def: Pure.thm
  val when_def: Pure.thm
  end;


functor HOL_RuleFun (structure HOL_Syntax: HOL_SYNTAX and Pure: PURE
	sharing HOL_Syntax.Syntax = Pure.Sign.Syntax) : HOL_RULE = 
struct
structure HOL_Syntax = HOL_Syntax;
structure Pure = Pure;
local open Pure 
in

val thy = enrich_theory pure_thy "HOL"
    (["term","form","type"], HOL_Syntax.const_decs, HOL_Syntax.syn)
[ 
  (*** Equality ***)

  ("refl",  "a: A ==> a = a : A"),
  ("sym",  "a = b : A ==> b = a : A"),

  (*Equal terms are well typed -- all rules must enforce this! *)
  ("eq_type1",  "a = b : A ==> a: A"),
  ("eq_type2",  "a = b : A ==> b: A"),

  ("subst", 
    "[| a = c : A;  P(c) |] ==> P(a)"),


  (*** TYPES ***)

  (** Pi: cartesian product of a family of types **)

  ("Lambda_type",
    "(!x.x: A ==> b(x) : B(x)) ==> lam x:A. b(x) : PROD x:A.B(x)"),

  ("Lambda_congr",
    "(!x.x: A ==> b(x) = c(x) : B(x)) ==> \
\    (lam x:A. b(x)) = (lam x:A. c(x)) : (PROD x:A.B(x))"),

  ("apply_type",
    "[| f: PROD x:A.B(x);  a: A |] ==> f`a : B(a)"),

  ("beta_conv",
    "[| a : A;  !x.x: A ==> b(x):B(x) |] ==> (lam x:A.b(x)) ` a = b(a):B(a)"),

  ("eta_conv", "f: PROD x:A.B(x) ==> (lam x:A. f`x) = f : (PROD x:A.B(x))"),


  (** Sigma: sum of a family of types **)

  ("pair_type", "[| a: A;  b: B(a) |] ==> <a,b> : SUM x:A.B(x)"),

  ("sigma_elim", 
    "[| p: SUM x:A.B(x);  !x y.[| x: A; y: B(x) |] ==> Q(<x,y>) |] ==> Q(p)"),

  ("pair_inject", 
    "[| <a,b> = <c,d> : (SUM x:A.B(x)); \
\       [| a = c : A;  b = d : B(a) |] ==> R |]   ==>  R"),

  (*fst and snd, if defined using descriptions, would have type labels. *)

  ("fst_type",  "p: SUM x:A.B(x) ==> fst(p) : A"),
  ("snd_type",  "p: SUM x:A.B(x) ==> snd(p) : B(fst(p))"),

  ("fst_conv",  "[| a: A;  b: B(a) |] ==> fst(<a,b>) = a: A"),
  ("snd_conv",  "[| a: A;  b: B(a) |] ==> snd(<a,b>) = b: B(a)"),

  ("split_def", "split(p,f) == f(fst(p), snd(p))"),


  (** Subtypes **)

  ("subtype_intr",  "[| a: A;  P(a) |] ==> a : {x:A.P(x)}"),
  ("subtype_elim1",   "a: {x:A.P(x)} ==> a:A"),
  ("subtype_elim2",   "a: {x:A.P(x)} ==> P(a)"),


  (** Natural numbers **)

  ("Zero_type",  "0: nat"),
  ("Succ_type",  "a: nat ==> Succ(a) : nat"),

  ("rec_type", 
    "[| a : nat;  b : C;  !x y.[| x: nat;  y: C |] ==> c(x,y): C |] \
\    ==> rec(a,b,c) : C"),

  ("rec_congr", 
    "[| a = a' : nat;  b = b' : C;  \
\       !x y.[| x: nat;  y: C |] ==> c(x,y) = c'(x,y): C |] \
\    ==> rec(a,b,c) = rec(a',b',c') : C"),

  ("rec_conv0", 
    "[| b: C;  !x y.[| x: nat;  y: C |] ==> c(x,y): C |] \
\    ==> rec(0,b,c) = b : C"),

  ("rec_conv1", 
    "[| a : nat;  b : C;  !x y.[| x: nat;  y: C |] ==> c(x,y): C |] \
\    ==> rec(Succ(a),b,c) = c(a, rec(a,b,c)) : C"),

  ("nat_induct", 
    "[| a: nat;  Q(0);  !x.[| x: nat;  Q(x) |] ==> Q(Succ(x)) |] ==> Q(a)"),


  (*** Logic ***)

  (** Implication and quantification *)

  ("classical",  "(~P ==> P) ==> P"),
  ("imp_intr",   "(P ==> Q) ==> P-->Q"),
  ("mp",         "[| P-->Q;  P |] ==> Q"),
  ("all_intr",   "(!x.x: A ==> P(x)) ==> ALL x:A.P(x)"),
  ("spec",       "[| ALL x:A.P(x);  a : A |] ==> P(a)"),

  (** Reflection *)

  ("term_type", "term(P) : bool"),
  ("term_conv", "p: bool ==> term(form(p)) = p : bool"),
  ("form_intr", "P ==> form(term(P))"),
  ("form_elim", "form(term(P)) ==> P"),
  ("term_congr","[| P ==> Q;  Q ==> P |] ==> term(P) = term(Q) : bool"),


  (** Reduction predicate for simplification. *)

  (*does not verify a:A!  Sound because only trans_red uses a Reduce premise*)
  ("refl_red", "Reduce(a,a)"),
  ("red_if_equal", "a = b : A ==> Reduce(a,b)"),
  ("trans_red", "[| a = b : A;  Reduce(b,c) |] ==> a = c : A"),

  (** Definitions of other connectives*)

  ("False_def", "False == term(ALL p:bool.form(p))"),
  ("True_def", 	"True  == term(ALL p:bool.form(p)-->form(p))"),
  ("conj_def", 	"P&Q   == ALL r:bool. (P-->Q-->form(r)) --> form(r)"),

  ("disj_def",
   "P|Q == ALL r:bool. (P-->form(r)) --> (Q-->form(r)) --> form(r)"),

  ("exists_def",
   "(EX x:A. P(x)) ==  ALL r:bool. (ALL x:A. P(x)-->form(r)) --> form(r)"),

  ("not_def", 	"~P == (P-->form(False))"),
  ("iff_def", 	"P<->Q == (P-->Q) & (Q-->P)"),


  (** Conditionals *)

  ("cond_def", "cond(A,p,a,b) == PICK x:A.(form(p)  & (x=a:A)) | \
\                                         (~form(p) & (x=b:A))"),

  (** Descriptions *)

  ("Pick_type", "EX x:A.P(x) ==> (PICK x:A.P(x)) : A"),

  ("Pick_congr",
    "[| !x.x: A ==> P(x) <-> Q(x);  EX x:A.P(x) |] \ 
\    ==> (PICK x:A.P(x)) = (PICK x:A.Q(x)) : A"),

  ("Pick_intr", "EX x:A.P(x) ==> P(PICK x:A.P(x))"),


  (** Definitions of Classes*)
  ("member_def",	"a<:S == form(S`a)"),
  ("subset_def", 	"subset(A,S,T) == ALL z:A. z<:S --> z<:T"),
  ("un_def",    "un(A,S,T) == {|z:A. z<:S | z<:T|}"),
  ("int_def",   "int(A,S,T) == {|z:A. z<:S & z<:T|}"),
  ("union_def", "union(A,F) == {|z:A. EX S:A->bool. S<:F & z<:S|}"),
  ("inter_def", "inter(A,F) == {|z:A. ALL S:A->bool. S<:F --> z<:S|}"),
  ("pow_def",   "pow(A,S) == {|T:A->bool. subset(A,T,S)|}"),


  (** Definitions of types*)

  (*the types "void" and "unit"*)
  ("void_def",	"void == {p: bool. form(False)}"),
  ("unit_def",	"unit == {p: bool. (p=True:bool)}"),

  (*unions: the type A+B *)
  ("plus_def",
    "A+B == {w: (A->bool) * (B->bool). \
\		(EX x:A. w = Inl(A,B,x) : (A->bool) * (B->bool)) | \
\		(EX y:B. w = Inr(A,B,y) : (A->bool) * (B->bool)) }"),

  ("Inl_def",	"Inl(A,B,a) == <{|x:A.a=x:A|}, lam y:B.False>"),
  ("Inr_def",	"Inr(A,B,b) == <lam x:A.False, {|y:B.b=y:B|}>"),
  ("when_def", 
    "when(A,B,C,p,c,d) == PICK z:C.  \
\	(ALL x:A. (p = Inl(A,B,x) : A+B) --> (z = c(x) : C)) & \
\	(ALL y:B. (p = Inr(A,B,y) : A+B) --> (z = d(y) : C))")];

val sign = sign_of thy;
val ax = get_axiom thy;

(*INSERT-RULENAMES -- file produced by make-rulenames*)
val refl = ax"refl";
val sym = ax"sym";
val eq_type1 = ax"eq_type1";
val eq_type2 = ax"eq_type2";
val subst = ax"subst";
val Lambda_type = ax"Lambda_type";
val Lambda_congr = ax"Lambda_congr";
val apply_type = ax"apply_type";
val beta_conv = ax"beta_conv";
val eta_conv = ax"eta_conv";
val pair_type = ax"pair_type";
val sigma_elim = ax"sigma_elim";
val pair_inject = ax"pair_inject";
val fst_type = ax"fst_type";
val snd_type = ax"snd_type";
val fst_conv = ax"fst_conv";
val snd_conv = ax"snd_conv";
val split_def = ax"split_def";
val subtype_intr = ax"subtype_intr";
val subtype_elim1 = ax"subtype_elim1";
val subtype_elim2 = ax"subtype_elim2";
val Zero_type = ax"Zero_type";
val Succ_type = ax"Succ_type";
val rec_type = ax"rec_type";
val rec_congr = ax"rec_congr";
val rec_conv0 = ax"rec_conv0";
val rec_conv1 = ax"rec_conv1";
val nat_induct = ax"nat_induct";
val classical = ax"classical";
val imp_intr = ax"imp_intr";
val mp = ax"mp";
val all_intr = ax"all_intr";
val spec = ax"spec";
val term_type = ax"term_type";
val term_conv = ax"term_conv";
val form_intr = ax"form_intr";
val form_elim = ax"form_elim";
val term_congr = ax"term_congr";
val refl_red = ax"refl_red";
val red_if_equal = ax"red_if_equal";
val trans_red = ax"trans_red";
val False_def = ax"False_def";
val True_def = ax"True_def";
val conj_def = ax"conj_def";
val disj_def = ax"disj_def";
val exists_def = ax"exists_def";
val not_def = ax"not_def";
val iff_def = ax"iff_def";
val cond_def = ax"cond_def";
val Pick_type = ax"Pick_type";
val Pick_congr = ax"Pick_congr";
val Pick_intr = ax"Pick_intr";
val member_def = ax"member_def";
val subset_def = ax"subset_def";
val un_def = ax"un_def";
val int_def = ax"int_def";
val union_def = ax"union_def";
val inter_def = ax"inter_def";
val pow_def = ax"pow_def";
val void_def = ax"void_def";
val unit_def = ax"unit_def";
val plus_def = ax"plus_def";
val Inl_def = ax"Inl_def";
val Inr_def = ax"Inr_def";
val when_def = ax"when_def";
end;
end;

