(*  Title: 	PolyML
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1989  University of Cambridge

For NEW JERSEY compiler.  Defines a dummy structure PolyML.
*)


signature POLYML = 
  sig
  val timing: bool -> unit
  val commit: unit -> unit
  val cd: string -> unit
  val print_depth: int -> unit
  val profiling: int -> unit
  val make_database: string * string -> unit
  val use: string -> unit
  val quit: unit -> unit
  end;

 
structure PolyML : POLYML = 
struct

fun timing _ = print"PolyML.timing was called!\n";
fun commit() = print"PolyML.commit was called!\n";
fun quit() = print"PolyML.quit was called!\n";
fun make_database _ = print"PolyML.make_database was called!\n";
fun profiling _ = print"PolyML.profiling was called!\n";
val use = use;
val cd = System.cd;

fun print_depth n = (System.Control.Print.printDepth := n);

end;

