(*  Title: 	NEWROOT
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1989  University of Cambridge

For NEW JERSEY compiler.

Root file for pure Isabelle: all modules in proper order for loading
Loads pure Isabelle into an empty database.

Then load ROOT.ML on subdirectory to add a logic to the database.
*)

val version = "89/2";

(*I/O.  Defines separate identifier for terminal output channel.*)
fun prs s = output std_out s;
fun writeln s = prs (s ^ "\n");

use "library.ML";
use "term.ML";
use "symtab.ML";
use "queue.ML";
use "pretty.ML";
use "syntax.ML";
use "sign.ML";
use "sequence.ML";
use "envir.ML";
use "unify.ML";
use "logic.ML";
use "thm.ML";
use "stringtree.ML";
use "tactic.ML";
use "conv.ML";
use "goals.ML";
use "simp.ML";


structure Symtab = SymtabFun();
structure Queue = QueueFun();
structure Pretty = PrettyFun(Queue);
structure Syntax = SyntaxFun(structure Symtab=Symtab and Pretty=Pretty);
structure Sign = SignFun(Syntax); 
structure Sequence = SequenceFun();
structure Envir = EnvirFun();
structure Unify = UnifyFun(structure Envir=Envir and Sequence=Sequence
                                 and Pretty=Pretty);
structure Logic = LogicFun(Unify);
structure Thm = ThmFun(structure Logic=Logic and Unify=Unify and Sign=Sign); 
structure Stringtree = StringtreeFun();
structure Tactic = TacticFun(structure Logic=Logic and Thm=Thm 
                                   and Stringtree=Stringtree and Pretty=Pretty);
structure Conv = ConvFun(structure Logic=Logic and Tactic=Tactic);
structure Goals = GoalsFun(Tactic);
(*No structure for Simp...this is built in object-logics*)


(exportML"EXEC";  print "Pure Isabelle\n");
