(*  Title: 	LK/set/ex/power
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1988  University of Cambridge


Set Theory examples: Powersets

by (set_step_tac 1);
by (setpc_step_tac 1);
by (setpc_tac 1);
*)


goal Set_Rule.thy "[| |- Union(Pow(A)) = A |]";
by (repeat_goal_tac [triv_pack, set_pack, ext_pack] 1);
result();


(*Halmos, page 20*)
goal Set_Rule.thy "[| |- Pow(A) Int Pow(B)  =  Pow(A Int B) |]";
by (repeat_goal_tac [triv_pack, set_pack, ext_pack] 1);
(*4 secs;  NOW 8??*)
result();

goal Set_Rule.thy "[| |- Pow(A) Un Pow(B)  <=  Pow(A Un B) |]";
by (subset_tac 1);  (*2 secs*)
result();


(*The set consisting of Pow(B) for all B in C *)
goal Set_Rule.thy "[| B:C |-  Pow(B) :   \
\	[ y || y : Pow(Pow(Union(C))), EXISTS x. x:C & y=Pow(x) ]  |]";
by (repeat_goal_tac [triv_pack, set_pack, ext_pack, LK_pack] 1);  
(*2 secs;  NOW 4??*)
result();


val my_pack =  ([basic, Pow_eq_left], [eqmem_left_thin] );

goal Set_Rule.thy "[| |- B:C <-> Pow(B) :   \
\	[ y || y : Pow(Pow(Union(C))), EXISTS x. x:C & y=Pow(x) ]  |]";
by (repeat_goal_tac [my_pack, set_pack, ext_pack, LK_pack] 1); 
(*8 secs*)
result();


(*It's easier with Replace...*)

goal Set_Rule.thy "[| B:C |-  Pow(B) : Replace(Pow,C) |]";
by (set_tac 1);
result();


goal Set_Rule.thy "[| |- B:C  <->  Pow(B) : Replace(Pow,C) |]";
by (repeat_goal_tac [my_pack, set_pack, ext_pack, LK_pack] 1); 
result();


(*Singletons*)

goal Set_Rule.thy "[| |- a::a::B = a::B |]";
by (repeat_goal_tac [triv_pack, set_pack, ext_pack] 1);
(*2 secs*)
result();


goal Set_Rule.thy "[| |- a::b::C = b::a::C |]";
by (repeat_goal_tac [triv_pack, set_pack, ext_pack] 1);
(*4 secs*)
result();


goal Set_Rule.thy "[| |- { {a}, {a,a} } = { {a} } |]";
by (repeat_goal_tac [triv_pack, set_pack, ext_pack] 1);
result();



goal Set_Rule.thy "[| |- {a,b} <= {c} --> a=c & b=c |]";
by (setpc_tac 1);  (*5 secs*)
result();


writeln"Reached end of file.";
