(*  Title: 	LK/set/ex/big-un-int
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1988  University of Cambridge


Set Theory examples: Big Union and Intersection.

by (step_tac [triv_pack, set_pack, ext_pack, LK_pack] 1);
by (step_tac [triv_pack, set_pack, ext_pack] 1);
by (step_tac [triv_pack, subset_pack] 1);
by (set_step_tac 1);
by (setpc_step_tac 1);
by (setpc_tac 1);
*)



goal Set_Rule.thy "[| |- Union(A Un B) = Union(A) Un Union(B) |]";
by (repeat_goal_tac [triv_pack, set_pack, ext_pack] 1);  (*6 secs*)
result();

goal Set_Rule.thy "[| |- (ALL B. B:C --> B <= A) <-> Union(C) <= A |]";
by (repeat_goal_tac [triv_pack, set_pack, ext_pack, LK_pack] 1);
(*9 secs*)
result();


goal Set_Rule.thy
   "[| |- (ALL B. B:C --> B Int A = 0)  <->  Union(C) Int A = 0 |]";
by (repeat_goal_tac [triv_pack, set_pack, ext_pack, LK_pack] 1);
(*19 secs*)
result();


goal Set_Rule.thy "[| |- A:B --> A <= Union(B) & Inter(B) <= A |]";
by (setpc_tac 1);
result();


writeln"A good challenge: Inter is ill-behaved on the empty set";
goal Set_Rule.thy
    "[|  |- Inter(A Un B) = Inter(A) Int Inter(B), A<=0, B<=0 |]";
by (REPEAT(step_tac
    [triv_pack, subset_pack, ext_pack, ([Un_left,Un_right],[])] 1));
(*17 secs;  repeat_goal_tac does not work due to goal ordering. *)
result();


goal Set_Rule.thy "[| EXISTS B. B: C  &  A<=B |- A <= Union(C) |]";
by (setpc_tac 1);
(*3 secs*)
result();

writeln"The Union contained in a set";
goal Set_Rule.thy "[| ALL B. B: C  -->  B<=A |- Union(C) <= A |]";
by (setpc_tac 1);
(*4 secs*)
result();

goal Set_Rule.thy "[| ~(C<=0), ALL B. B:C --> A<=B |-  A <= Inter(C) |]";
by (repeat_goal_tac [triv_pack, subset_pack, LK_pack] 1);
(*4 secs*)
result();


writeln"The Intersection contained in a set";
goal Set_Rule.thy "[| EXISTS B. B: C  &  B <= A |- Inter(C) <= A |]";
by (pc_tac 1); 
by (set_tac 1);   (*2 secs*)
result();


writeln"Unions and Intersections of Families";

goal Set_Rule.thy
    "[| |- A Int Union(B) = Union([ A Int C || C:B]) |]";
by (repeat_goal_tac [triv_pack, set_pack, ext_pack] 1);
(*9 secs*)
result();


goal Set_Rule.thy
    "[| ~(B<=0) |- A Un Inter(B) = Inter([ A Un C || C:B]) |]";
by (safe_goal_tac [triv_pack, subset_pack, ext_pack, LK_pack] 1);
(*5 secs*)
by (REPEAT (DEPTH_SOLVE_1 (repeat_goal_tac [triv_pack, set_pack, ext_pack] 1)));
(*26 secs??*)
result();


writeln"Devlin, page 12: Union of a family of unions";
goal Set_Rule.thy
    "[| |- Union([ A(x) Un B(x) || x:C]) =        \
\          Union([ A(x) || x:C ])  Un  Union([ B(x) || x:C ]) |]";
by (repeat_goal_tac [triv_pack, set_pack, ext_pack] 1);
(*22 secs*)
result();


goal Set_Rule.thy
    "[| ~(C<=0) |- Inter([ A(x) Int B(x) || x:C ]) =        \
\      Inter([ A(x) || x:C ])  Int  Inter([ B(x) || x:C ]) |]";
by (safe_goal_tac [triv_pack, subset_pack, ext_pack, LK_pack] 1);
(*7 secs*)
by (REPEAT (repeat_goal_tac [triv_pack, set_pack, ext_pack] 1));
(*38 secs!!*)
result();


writeln"Reached end of file.";
