(*  Title: 	LK/ROOT
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1988  University of Cambridge

Adds Classical First Order Logic to a database containing pure Isabelle. 
Should be executed in the subdirectory LK.

To build system, enter Poly/ML and type
    PolyML.use "ROOT";
*)

writeln"Root file for Classical First Order Logic";

open PolyML;  (*essential when using make_database!*)

print_depth 1;  
use "syntax.ML";
use ".rules.ML";
use "resolve.ML";

print_depth 0;  
structure LK_Syntax = LK_SyntaxFun(structure Syntax=Syntax and Pretty=Pretty);
structure LK_Rule = LK_RuleFun(structure LK_Syntax=LK_Syntax and Thm=Thm);
structure LK_Resolve = LK_ResolveFun
    (structure LK_Syntax=LK_Syntax and LK_Rule=LK_Rule and Conv=Conv);

print_depth 0;  
open Thm Tactic Goals Conv;
open LK_Syntax LK_Rule LK_Resolve;

(*read/print functions*)
Unify.printer := Syntax.prin syn;

print_depth 8;  
