val tr_const_decs = 
  [ (["tranclose"],	[Atype,Aterm]--->Aterm) ];


val tr_thy = Thm.extend_theory tarski_thy  "tarski" 
    ([], tr_const_decs)
  [ ("tranclose_def",   
      "tranclose(A,R) == compose(A,A,A, R, idtranclose(A,R))") ];


val ax = Thm.get_axiom tr_thy;
val tranclose_def = ax"tranclose_def";

(**** The relation tranclose(A,R) ****)

(** Conversions between tranclose and idtranclose **)

val asms = goal tr_thy
    "[| <a,b> <: tranclose(A,R) |] ==> \
\    [| a: A |] ==> [| b: A |] ==> [| R: A*A->bool |] ==> \
\    [| <a,b> <: idtranclose(A,R) |]";
by (cut_facts_tac asms 1);
by (rewrite_goals_tac [tranclose_def]);
by (REPEAT (eresolve_tac [compose_elim] 1
	ORELSE  Class.step_tac ([idtranclose_intr2]@idtranclose_type_rls) 1));
val idtranclose_intr_tran = result();

val asms = goal tr_thy
    "[| <a,b> <: idtranclose(A,R) |] ==> [| <b,c> <: R |] ==> \
\    [| a: A |] ==> [| b: A |] ==> [| c: A |] ==> [| R: A*A->bool |] ==> \
\    [| <a,c> <: tranclose(A,R) |]";
by (rewrite_goals_tac [tranclose_def]);
by (Class.fast_tac ([compose_intr] @ idtranclose_type_rls @ asms) 1);
val tranclose_intr_id = result();


val asms = goal tr_thy
    "[| R: A*A->bool |] ==> \
\    [| tranclose(A,R) : A*A->bool |]";
by (rewrite_goals_tac [tranclose_def]);
by (Class.typechk_tac (asms @ [idtranclose_type,compose_type]));
val tranclose_type = result();


(*Transitive closure of R contains R*)
val asms = goal tr_thy
    "[| <a,b> <: R |] ==> \
\    [| a: A |] ==> [| b: A |] ==> [| R: A*A->bool |] ==> \
\    [| <a,b> <: tranclose(A,R) |]";
by (rewrite_goals_tac [tranclose_def]);
by (Class.fast_tac ([compose_intr,idtranclose_refl,
		     idtranclose_type,compose_type] @ asms) 1);
val tranclose_intr1 = result();


(*Closure under composition with R*)
val asms = goal tr_thy
    "[| <a,b> <: tranclose(A,R) |] ==> [| <b,c> <: R |] ==> \
\    [| a: A |] ==> [| b: A |] ==> [| c: A |] ==> [| R: A*A->bool |] ==> \
\    [| <a,c> <: tranclose(A,R) |]";
by (rewrite_goals_tac [tranclose_def]);
by (Class.fast_tac ([idtranclose_intr_tran,compose_intr] @
		    idtranclose_type_rls @ asms) 1);
val tranclose_intr2 = result();



val asms = goal tr_thy
    "[| <a,b> <: tranclose(A,R) |] ==> \
\    [| a: A |] ==> [| b: A |] ==> [| R: A*A->bool |] ==> \
\    [| <a,b> <: R | EXISTS y:A. <a,y> <: tranclose(A,R) & <y,b> <: R |]";
by (resolve_tac [compose_elim] 1);
by (resolve_tac (map (rewrite_rule [tranclose_def]) asms) 1);
by (REPEAT (eresolve_tac [idtranclose_elim RS disj_elim, subst] 1
            THEN  Class.typechk_tac asms));
by (REPEAT (Class.step_tac ([tranclose_intr_id]@asms) 1));
val tranclose_elim = result();



(*transitivity of transitive closure (!!!) -- by induction.*)
val asms = goal tr_thy
    "[| <a,b> <: tranclose(A,R) |] ==> [| <b,c> <: tranclose(A,R) |] ==> \
\    [| a: A |] ==> [| b: A |] ==> [| c: A |] ==> [| R: A*A->bool |] ==> \
\    [| <a,c> <: tranclose(A,R) |]";
by (cut_facts_tac asms 1);
by (rewrite_goals_tac [tranclose_def]);
by (REPEAT (eresolve_tac [compose_elim] 1));
by (resolve_tac ([compose_intr]) 1);
by (assume_tac 2);
by (resolve_tac ([idtranclose_trans]) 1);
by (assume_tac 2);
by (resolve_tac ([idtranclose_intr2]) 1);
by (REPEAT (assume_tac 1));
val tranclose_trans = result();



