(*  Title: 	HOL/pc
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1988  University of Cambridge

Classical Higher-order Logic:

Construction of the predicate calculus prover
*)


(*Propositional rules*)
val prop_rulepairs =  
  [ (True_intr,"safe_intr"),
    (asm_rl,"safe_elim"),	(*!solves goals by assumption!*)
    (conj_intr,"safe_intr"),
    (disj_cintr,"safe_intr"),
    (imp_intr,"safe_intr"),
    (not_intr,"safe_intr"),
    (iff_intr,"safe_intr"),
    (form_intr,"safe_intr"),
    (False_elim,"safe_elim"),
    (conj_elim,"safe_elim"),
    (disj_elim,"safe_elim"),
    (imp_celim,"safe_elim"),
    (iff_elim,"safe_elim"),
    (form_elim2,"safe_elim"),
    (split_intr,"safe_intr"),
    (split_elim,"safe_elim") ];


(*Quantifier rules*)
val quant_rulepairs =  
  [ (all_intr,"safe_intr"),
    (all_elim,"haz_elim"),
    (exists_intr,"haz_intr"), (exists_cintr,"haz_cintr"),
    (exists_elim,"safe_elim") ];


print_depth 1;  
structure Pc_Rule_tab = struct
    structure Thm = Thm
    val type_rls = type_rls
    val pairs = prop_rulepairs@quant_rulepairs
    end;

structure Pc = ProverFun
	(structure HOL_Rule=HOL_Rule and Logic=Logic
	       and HOL_Lemmas=HOL_Lemmas and Rule_tab=Pc_Rule_tab);
