(*  Title: 	HOL/ex/big-un-int
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1988  University of Cambridge


Class Theory examples: Big union and intersection.


by (Class.step_tac ([equal_intr]@asms) 1);
by (assume_tac 1);
*)



val asms =
goal HOL_Rule.thy
    "[| F: (A->bool)->bool |] ==> [| G: (A->bool)->bool |] ==> \
\    [| [ union(A, un(A->bool, F, G)) = \
\         un(A, union(A,F), union(A,G)) : A->bool ] |]";
by (Class.fast_tac ([equal_intr]@asms) 1);
result();


val asms =
goal HOL_Rule.thy
    "[| F: (A->bool)->bool |] ==> [| R: A->bool |] ==> \
\    [| (ALL S: A->bool. S<:F --> subset(A,S,R))   <->   \
\       subset(A, union(A,F), R) |]";
by (Class.fast_tac asms 1);
result();



val asms =
goal HOL_Rule.thy
    "[| F: (A->bool)->bool |] ==> [| S: A->bool |] ==> \
\    [| S<:F --> subset(A, S, union(A,F)) & subset(A, inter(A,F), S) |]";
by (Class.fast_tac asms 1);
result();


val asms =
goal HOL_Rule.thy
    "[| F: (A->bool)->bool |] ==> [| G: (A->bool)->bool |] ==> \
\    [| [ inter(A, un(A->bool,F,G)) = \
\	  int(A, inter(A,F), inter(A,G)) : A->bool ] |]";
by (Class.fast_tac ([equal_intr]@asms) 1);
result();


writeln"Big Union and containment";

val asms =
goal HOL_Rule.thy
    "[| F: (A->bool)->bool |] ==> [| R: A->bool |] ==> \
\    [| (EXISTS S: A->bool. S<:F  &  subset(A,R,S))  \
\  -->  subset(A, R, union(A,F)) |]";
by (Class.fast_tac asms 1);
result();

val asms =
goal HOL_Rule.thy
    "[| F: (A->bool)->bool |] ==> [| R: A->bool |] ==> \
\    [| (ALL S: A->bool. S<:F  -->  subset(A,S,R))  \
\  -->  subset(A, union(A,F), R) |]";
by (Class.fast_tac asms 1);
result();


writeln"Big Intersection and containment";

val asms =
goal HOL_Rule.thy
    "[| F: (A->bool)->bool |] ==> [| R: A->bool |] ==> \
\    [| (ALL S: A->bool. S<:F --> subset(A,R,S))  \
\  -->  subset(A, R, inter(A,F)) |]";
by (Class.fast_tac asms 1);
result();

val asms =
goal HOL_Rule.thy
    "[| F: (A->bool)->bool |] ==> [| R: A->bool |] ==> \
\    [| (EXISTS S: A->bool. S<:F  &  subset(A,S,R))  \
\  -->  subset(A, inter(A,F), R) |]";
by (Class.fast_tac asms 1);
result();


val asms =
goal HOL_Rule.thy
    "[| F: (A->bool)->bool |] ==> [| R: A->bool |] ==> \
\    [| (ALL S: A->bool. S<:F --> [ int(A,S,R) = lam x:A.False : A->bool ]) \
\  <->  [ int(A, union(A, F), R) = lam x:A.False : A->bool ] |]";
by (REPEAT (Class.step_tac ([equal_intr]@asms) 1
        ORELSE eresolve_tac [asm_rl, equal_elim] 1));
result();


writeln"Reached end of file.";

(*10 September 1988: loaded this file in 72 seconds*)
