(*  Title: 	HOL/arith
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1989  University of Cambridge

Natural numbers and Theory of Arithmetic
*)


(** Freeness of constructors (follows by virture of rec) *)

val nat_distinct = prove_goal HOL_Rule.thy
  "[| [ 0 = Succ(a) : nat ] |] ==> [| a: nat |] ==> [| P |]"
 (fn asms=>
  [ (resolve_tac [False_elim] 1),
    (resolve_tac [subst] 1),
    (resolve_tac [box_equals] 1),
    (subst1_tac "%(x)rec(x, False, %(y,z)True)" 1),
    (REPEAT (ares_tac (asms@type_rls@
		[True_intr, rec_type, rec_conv0, rec_conv1]) 1)) ]);


val Succ_inject1 = prove_goal HOL_Rule.thy
  "[| [ Succ(a) = Succ(b): nat ] |] ==> [| a: nat |] ==> [| b: nat |] ==> \
\  [| [ a = b : nat ] |]"
 (fn asms=>
  [ (resolve_tac [box_equals] 1),
    (subst1_tac "%(x)rec(x, x, %(y,z)y)" 1),
    (REPEAT (ares_tac (asms @ [Succ_type, rec_type, rec_conv1]) 1)) ]);


(*Version for using the assumption Succ(a) = Succ(b) *)
val Succ_inject = prove_goal HOL_Rule.thy
  "[| [ Succ(a) = Succ(b): nat ] |] ==> [| a: nat |] ==> [| b: nat |] ==> \
\  ([| [ a = b : nat ] |] ==> [| R |]) ==> \
\  [| R |]"
 (fn asms=>
  [ (REPEAT (resolve_tac (asms @ [Succ_inject1]) 1)) ]);


(*Induction on the expression "a"*)
fun nat_induct_tac (sp: string) i = 
  res_inst_tac [ ("a",sp,Aterm) ] nat_induct i;



(****Arithmetic operations [SHOULD USE WF RECURSION FOR DIVISION] *)

val arith_const_decs = 
  [ (["#+", "-", "|-|", "#*", "//", "/"],  [Aterm,Aterm]--->Aterm),
    (["prec"],  Aterm) ];

val arith_infix_decs = 
    [ (["#*","//","/"],		"right", 5),
      (["#+","-","|-|"],	"right", 3) ];

val arith_syn = Syntax.extend HOL_Syntax.syn
	([], arith_infix_decs, parser, printer); 

val arith_thy = Thm.enrich_theory wf_thy  "arith" 
    ([], arith_const_decs,  arith_syn)

  [ ("add_def",  "a#+b == rec(a, b, %(u,v)Succ(v))"),
  
    ("diff_def",  "a-b == rec(b, a, %(u,v)rec(v, 0, %(x,y)x))"),
  
    ("absdiff_def",  "a|-|b == (a-b) #+ (b-a)"),
  
    ("mult_def",  "a#*b == rec(a, 0, %(u,v) b #+ v)"),
  
    ("mod_def",  "a//b == rec(a, 0, %(u,v)   \
  \			rec(Succ(v) |-| b, 0, %(x,y)Succ(v)))"),
  
    ("quo_def",  "a/b == rec(a, 0, %(u,v)   \
  \			rec(Succ(u) // b, Succ(v), %(x,y)v))"),

    ("prec_def", 
     "prec == lam z:nat*nat. term \
\		(EXISTS y:nat. [ z = <y, Succ(y)> : nat*nat ])") ];


local val ax = Thm.get_axiom arith_thy
in  val add_def = ax"add_def"
    and diff_def = ax"diff_def"
    and absdiff_def = ax"absdiff_def"
    and mult_def = ax"mult_def"
    and mod_def = ax"mod_def"
    and quo_def = ax"quo_def"
    and prec_def = ax"prec_def"
end;

val arith_defs =
    [add_def, diff_def, absdiff_def, mult_def, mod_def, quo_def, prec_def];


(*'Preceding number' is a well-founded relation*)
val prec_wf_rel = prove_goal arith_thy
    "[| wf_rel(nat,prec) |]"
 (fn asms=>
  [ (rewrite_goals_tac [wf_rel_def, prec_def]),
    (REPEAT (resolve_tac [imp_intr, all_intr] 1)),
    (res_inst_tac [ ("a","kb",Aterm) ] nat_induct 1),
    (REPEAT_FIRST    ((eresolve_tac [all_elim] THEN' chain_tac)
	ORELSE' (eresolve_tac [nat_distinct, Succ_inject, pair_inject])
	ORELSE' Class.step_tac [])),
    (Class.typechk_tac []),
    (eresolve_tac [subst] 1),
    (eresolve_tac [sym RS subst] 1),
    (assume_tac 1) ]);
