

(***********************
  Remainder and Quotient
 ***********************)


(*typing of remainder (//): short and long versions*)

val mod_typing = prove_goal arith_thy
    "[| a:N |] ==> [| b:N |] ==> [| a//b : N |]"
 (fn asms=>
  [ (rewrite_goals_tac [mod_def]),
    (typechk_tac (absdiff_typing::asms)) ]);
 

val mod_typing_long = prove_goal arith_thy
    "[| a=c:N |] ==> [| b=d:N |] ==> [| a//b = c//d : N  |]"
 (fn asms=>
  [ (rewrite_goals_tac [mod_def]),
    (equal_tac (asms@[absdiff_typing_long])) ]);
 


(*computation for //: 0 and successor cases*)

val mod_comp0 = prove_goal arith_thy "[| b:N |] ==> [| 0//b = 0 : N  |]"
 (fn asms=>
  [ (rewrite_goals_tac [mod_def]),
    (rew_tac(absdiff_typing::asms)) ]);


val mod_comp_succ = prove_goal arith_thy "[| a:N |] ==> [| b:N |] ==> \
\               [| succ(a)//b = \
\    rec(succ(a//b) |-| b, 0, %(x,y)succ(a//b)) : N  |]"
 (fn asms=>
  [ (rewrite_goals_tac [mod_def]),
    (rew_tac(absdiff_typing::asms)) ]);


(*typing of quotient: short and long versions*)

val quo_typing = prove_goal arith_thy "[| a:N |] ==> [| b:N |] ==> \
\               [| a / b : N |]"
 (fn asms=>
  [ (rewrite_goals_tac [quo_def]),
    (typechk_tac ([absdiff_typing,mod_typing]@asms)) ]);


val quo_typing_long = prove_goal arith_thy "[| a=c:N |] ==> [| b=d:N |] ==> \
\               [| a / b = c / d : N  |]"
 (fn asms=>
  [ (rewrite_goals_tac [quo_def]),
    (equal_tac (asms @ [absdiff_typing_long, mod_typing_long])) ]);


val quo_typing_rls = [mod_typing, quo_typing, absdiff_typing];


(*computation for quotient: 0 and successor cases*)

val quo_comp0 = prove_goal arith_thy "[| b:N |] ==> [| 0 / b = 0 : N  |]"
 (fn asms=>
  [ (rewrite_goals_tac [quo_def]),
    (rew_tac([mod_typing, absdiff_typing] @ asms)) ]);


val quo_comp_succ =
prove_goal arith_thy "[| a:N |] ==> [| b:N |] ==> [| succ(a) / b = \
\    rec(succ(a)//b, succ(a / b), %(x,y) a / b) : N  |]"
 (fn asms=>
  [ (rewrite_goals_tac [quo_def]),
    (rew_tac([mod_typing]@asms)) ]);


(*Version of above with same condition as the // one*)
val quo_comp_succ2 = prove_goal arith_thy
    "[| a:N |] ==> [| b:N |] ==>  \
\    [| succ(a) / b =rec(succ(a//b) |-| b, succ(a / b), %(x,y) a / b) : N  |]"
 (fn asms=>
  [ (resolve_tac [ trans_elem RES quo_comp_succ ] 1),
    (rew_tac(quo_typing_rls @ asms @ [mod_comp_succ])),
    (N_elim_tac "succ(a//b)|-|b" 1),
    (rew_tac ([mod_typing, quo_typing, absdiff_typing] @asms)) ]);


(*for case analysis on whether a number is 0 or a successor*)
val iszero_decidable = prove_goal arith_thy
    "[| a:N |] ==> [| rec(a, inl(eq), %(ka,kb)inr(<ka, eq>)) : \
\		      Eq(N,a,0) + SUM x:N. Eq(N,a, succ(x)) |]"
 (fn asms=>
  [ (N_elim_tac "a" 1),
    (resolve_tac [Plus_intr_inr] 3),
    (resolve_tac [Plus_intr_inl] 2),
    eqintr_tac,
    (equal_tac asms) ]);



(*Main Result.  Holds when b is 0 since   a//0 = a     and    a/0 = 0  *)
val asms =
goal arith_thy "[| a:N |] ==> [| b:N |] ==>  \
\               [| a//b  #+  (a/b) #* b = a : N  |]";
by (N_elim_tac "a" 1);
by (arith_rew_tac (quo_typing_rls @ asms @
	[mod_comp0,mod_comp_succ, quo_comp0, quo_comp_succ2])); 
(*5 secs*)
by (resolve_tac [ Eq_elim ] 1);
(*case analysis on   succ(u//b)|-|b  *)
by (res_inst_tac [("a1", "succ(ka // b) |-| b", Aexp)]
	(Plus_elim RES iszero_decidable) 1);
by (biresolve_tac [(true,Sum_elim)] 3);
by (hyp_arith_rew_tac (asms @ quo_typing_rls @
	[mod_comp0,mod_comp_succ, quo_comp0, quo_comp_succ2])); 
(*36 secs*)
(*Replace one occurence of  b  by succ(ka//b).  Clumsy!*)
by (resolve_tac [ trans_elem RES add_typing_long ] 1);
by (biresolve_tac [(true, sym_elem RES absdiff_eq0 RES Eq_elim)] 1);
by (resolve_tac [refl_elem] 3);
by (hyp_arith_rew_tac (asms @ quo_typing_rls)); 
(*4 secs*)
val mod_quo_equality = result();


writeln"Reached end of file.";


(*21 August 88: loaded this file in 262 secs*)
(*2 September 1988: loaded this file in 290 seconds*)
