(*  Title: 	CTT/ex/equal
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1988  University of Cambridge

Equality reasoning by rewriting.
*)



val asms =
goal CTT_Rule.thy "[| p : Sum(A,B) |] ==> [| split(p,pair) = p : Sum(A,B) |]";
by (resolve_tac [Eq_elim]  1);
by (resolve_tac elim_rls 1  THEN  resolve_tac asms 1);
by (rew_tac asms);
val split_eq = result();


val asms =
goal CTT_Rule.thy "[| A type|] ==> [| B type |] ==> \
\                  [| p : A+B |] ==> [| when(p,inl,inr) = p : A + B |]";
by (resolve_tac [Eq_elim]  1);
by (resolve_tac elim_rls 1  THEN  resolve_tac asms 1);
by (rew_tac asms);
val when_eq = result();



(*in the "rec" formulation of addition, 0+n=n *)
val asms =
goal CTT_Rule.thy "[| p:N |] ==> [| rec(p,0, %(y,z)succ(y)) = p : N |]";
by (resolve_tac [Eq_elim]  1);
by (resolve_tac elim_rls 1  THEN  resolve_tac asms 1);
by (rew_tac asms);
result();


(*the harder version, n+0=n: recursive, uses induction hypothesis*)
val asms =
goal CTT_Rule.thy "[| p:N |] ==> [| rec(p,0, %(y,z)succ(z)) = p : N |]";
by (resolve_tac [Eq_elim]  1);
by (resolve_tac elim_rls 1  THEN  resolve_tac asms 1);
by (hyp_rew_tac asms);
result();


(*Associativity of addition*)
val asms =
goal CTT_Rule.thy "[| a:N|] ==> [| b:N|] ==> [| c:N|] ==>  \
\      [| rec(rec(a, b, %(x,y)succ(y)), c, %(x,y)succ(y)) = \
\         rec(a, rec(b, c, %(x,y)succ(y)), %(x,y)succ(y)) : N |]";
by (N_elim_tac "a" 1);
by (hyp_rew_tac asms);
result();



(*Martin-Lof (1984) page 62: pairing is surjective*)
val asms =
goal CTT_Rule.thy "[| p : Sum(A,B) |] ==> \
\                  [| <split(p,%(x,y)x), split(p,%(x,y)y)> = p : Sum(A,B)|]";
by (resolve_tac [Eq_elim]  1);
by (resolve_tac elim_rls 1  THEN  resolve_tac asms 1);
by (DEPTH_SOLVE_1 (rew_tac asms));   (*!!!!!!!*)
result();


val asms =
goal CTT_Rule.thy "[| a : A |] ==> [| b : B |] ==>  \
\           [| (lam u. split(u, %(v,w)<w,v>)) ` <a,b> = <b,a> : SUM x:B.A|]";
by (rew_tac asms);
result();



(*a contrived, complicated simplication, requires sum-elimination also*)
val asms =
goal CTT_Rule.thy
   "[| (lam f. lam x. f`(f`x)) ` (lam u. split(u, %(v,w)<w,v>)) =  \
\     lam x. x  :  PROD x:(SUM y:N.N). (SUM y:N.N)         |]";
by (resolve_tac reduction_rls 1);
by (resolve_tac intr_long_rls 3);
by (resolve_tac [Eq_elim]  4);
by (resolve_tac [Sum_elim] 4  THEN  assume_tac 4);
(*order of unifiers is essential here*)
by (rew_tac asms);

result();

writeln"Reached end of file.";
(*28 August 1988: loaded this file in 34 seconds*)
(*2 September 1988: loaded this file in 48 seconds*)
