(*  Title: 	CTT/ex/elim
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1988  University of Cambridge

Some examples taken from P. Martin-L\"of, Intuitionistic type theory
	(Bibliopolis, 1984).

by (safe_tac asms 1);
by (step_tac asms 1);
by (pc_tac asms 1);
*)

writeln"Examples with elimination rules";


writeln"fst and snd";
val asms = goal CTT_Rule.thy "[| A type |] ==> [| ?a : (A*A) --> A |]";
by (rewrite_tac basic_defs);
by (pc_tac asms 1  THEN  fold_tac basic_defs);
uresult();
back(); 
back() handle ERROR => writeln"And there are indeed no others";  


val asms = goal CTT_Rule.thy 
    "[| A type |] ==> [| B type |] ==> [| ?a : (A*B) --> (B*A) |]";
by (rewrite_tac basic_defs);
by (pc_tac asms 1  THEN  fold_tac basic_defs);
uresult();
(*The sequent version (ITT) could produce an interesting alternative
  by backtracking.  No longer.*)


writeln"Binary sums and products";
val asms = goal CTT_Rule.thy
    "[| A type |] ==> [| B type |] ==> [| C type |] ==> \
\    [| ?a : (A+B --> C) --> (A-->C) * (B-->C) |]";
by (rewrite_goals_tac basic_defs);
by (pc_tac asms 1);
uresult();


val asms = goal CTT_Rule.thy 
    "[| A type |] ==> [| B type |] ==> [| C type |] ==> \
\    [| ?a : A * (B+C)  -->  (A*B + A*C) |]";
by (rewrite_goals_tac basic_defs);
by (pc_tac asms 1);
uresult();


(*more general version, same proof*)
val asms = goal CTT_Rule.thy 
    "[| A type |] ==> (!(x)[| x:A |] ==> [| B(x) type |]) ==> \
\    (!(x)[| x:A |] ==> [| C(x) type |]) ==> \
\    [| ?a : (SUM x:A. B(x) + C(x)) --> (SUM x:A. B(x)) + (SUM x:A. C(x)) |]";
by (rewrite_goals_tac basic_defs);
by (pc_tac asms 1);
uresult();


writeln"Construction of the currying functional";
val asms = goal CTT_Rule.thy 
    "[| A type |] ==> [| B type |] ==> [| C type |] ==> \
\    [| ?a : (A*B --> C) --> (A--> (B-->C)) |]";
by (rewrite_goals_tac basic_defs);
by (pc_tac asms 1);
uresult();


(*more general goal with same proof*)
val asms = goal CTT_Rule.thy  
    "[| A type |] ==> (!(x)[| x:A |] ==> [| B(x) type |]) ==> \
\    (!(z)[| z : (SUM x:A . B(x)) |] ==> [| C(z) type |]) ==> \
\    [| ?a : (PROD z : (SUM x:A . B(x)) . C(z)) \
\                      --> (PROD x:A . PROD y:B(x) . C(<x,y>)) |]";
by (rewrite_goals_tac basic_defs);
by (pc_tac asms 1);
uresult();



writeln"Martin-Lof (1984), page 48: axiom of sum-elimination (uncurry)";
val asms = goal CTT_Rule.thy 
    "[| A type |] ==> [| B type |] ==> [| C type |] ==> \
\    [| ?a : (A --> (B-->C)) --> (A*B --> C) |]";
by (rewrite_goals_tac basic_defs);
by (pc_tac asms 1);
uresult();


(*more general goal with same proof*)
val asms = goal CTT_Rule.thy 
    "[| A type |] ==> (!(x)[| x:A |] ==> [| B(x) type |]) ==> \
\    (!(z)[| z : (SUM x:A . B(x)) |] ==> [| C(z) type |]) ==> \
\    [| ?a : (PROD x:A . PROD y:B(x) . C(<x,y>)) \
\                      --> (PROD z : (SUM x:A . B(x)) . C(z)) |]";
by (rewrite_goals_tac basic_defs);
by (pc_tac asms 1);
uresult();


writeln"Function application";
val asms = goal CTT_Rule.thy  
    "[| A type |] ==> [| B type |] ==> [| ?a : ((A --> B) * A) --> B |]";
by (rewrite_goals_tac basic_defs);
by (pc_tac asms 1);
uresult();



writeln"Basic test of quantifier reasoning";
(*Assumption should be !(x)[| x:A |] ==> !(y)[| y:B |] ==> ...
    but "standard" does not convert (y) to a Var.   ?????? *)
val asms = goal CTT_Rule.thy  
    "[| A type |] ==> [| B type |] ==> \
\    (!(x,y)[| x:A |] ==> [| y:B |] ==> [| C(x,y) type |]) ==> \
\    [| ?a : (SUM y:B . PROD x:A . C(x,y))  \
\                     -->  (PROD x:A . SUM y:B . C(x,y)) |]";
by (rewrite_goals_tac basic_defs);
by (pc_tac asms 1);
uresult();


(*faulty proof attempt, stripping the quantifiers in wrong sequence
by (rewrite_goals_tac basic_defs);
by (intr_tac[]);
by (pc_tac asms 1);
 ...fails!!  *)



writeln"Martin-Lof (1984) pages 36-7: the combinator S";
val asms = goal CTT_Rule.thy  
    "[| A type |] ==> (!(x)[| x:A |] ==> [| B(x) type |]) ==> \
\    (!(x,y)[| x:A |] ==> [| y:B(x) |] ==> [| C(x,y) type |]) ==> \
\    [| ?a : (PROD x:A. PROD y:B(x). C(x,y)) \
\            --> (PROD f: (PROD x:A. B(x)). PROD x:A. C(x, f`x)) |]";
by (rewrite_goals_tac basic_defs);
by (pc_tac asms 1);
uresult();


writeln"Martin-Lof (1984) page 58: the axiom of disjunction elimination";
val asms = goal CTT_Rule.thy
    "[| A type |] ==> [| B type |] ==> \
\    (!(z)[| z: A+B |] ==> [| C(z) type |]) ==> \
\    [| ?a : (PROD x:A. C(inl(x))) --> (PROD y:B. C(inr(y)))  \
\                      --> (PROD z: A+B. C(z)) |]";
by (rewrite_goals_tac basic_defs);
by (pc_tac asms 1);
uresult();




(*towards AXIOM OF CHOICE*)
val asms = goal CTT_Rule.thy  
    "[| A type |] ==> [| B type |] ==> [| C type |] ==> \
\    [| ?a : (A --> B*C) --> (A-->B) * (A-->C) |]";
by (rewrite_goals_tac basic_defs);
by (pc_tac asms 1);
by (fold_tac basic_defs);   (*puts in fst and snd*)
uresult();


(*Martin-Lof (1984) page 50*)
writeln"AXIOM OF CHOICE!!!  Delicate use of elimination rules";
val asms = goal CTT_Rule.thy   
    "[| A type |] ==> (!(x)[| x:A |] ==> [| B(x) type |]) ==> \
\    (!(x,y)[| x:A |] ==> [| y:B(x) |] ==> [| C(x,y) type |]) ==> \
\    [| ?a : (PROD x:A. SUM y:B(x). C(x,y)) \
\            --> (SUM f: (PROD x:A. B(x)). PROD x:A. C(x, f`x))  |]";
by (rewrite_goals_tac basic_defs);
by (intr_tac asms);
by (mp_tac 2);
by (mp_tac 1);
by (biresolve_tac [(true, Sum_elim_fst)] 1);
by (resolve_tac [replace_type] 1);
by (resolve_tac [subst_eqtyparg] 1);
by (resolve_tac comp_rls 1);
by (resolve_tac [Sum_elim_snd] 4);
by (typechk_tac (Sum_elim_fst::asms));
uresult();



writeln"Axiom of choice.  Proof without fst, snd.  Harder still!"; 
val asms = goal CTT_Rule.thy   
    "[| A type |] ==> (!(x)[| x:A |] ==> [| B(x) type |]) ==> \
\    (!(x,y)[| x:A |] ==> [| y:B(x) |] ==> [| C(x,y) type |]) ==> \
\    [| ?a : (PROD x:A. SUM y:B(x). C(x,y)) \
\            --> (SUM f: (PROD x:A. B(x)). PROD x:A. C(x, f`x))  |]";
by (rewrite_goals_tac basic_defs);
by (intr_tac asms);
(*Must not use mp_tac as subst_prod_elim hides the construction.*)
by (resolve_tac [Sum_elim RES Prod_elim] 1  THEN  assume_tac 1);
by (REPEAT_FIRST assume_tac);
by (resolve_tac [replace_type] 1);
by (resolve_tac [subst_eqtyparg] 1);
by (resolve_tac comp_rls 1);
by (biresolve_tac [(true, Sum_elim RES Prod_elim)] 4);
by (typechk_tac asms);
by (resolve_tac [replace_type] 1);
by (resolve_tac [subst_eqtyparg] 1);
by (resolve_tac comp_rls 1);
by (typechk_tac asms);
by (assume_tac 1);
by (fold_tac basic_defs);
uresult();



writeln"Example of sequent_style deduction"; 
(*When splitting z:A*B, the assumption C(z) is affected;  ?a becomes
    lam u. split(u,%(v,w)split(v,%(x,y)lam z. <x,<y,z>>) ` w)
*)
val asms = goal CTT_Rule.thy   
    "[| A type |] ==> [| B type |] ==> \
\    (!(z)[| z:A*B |] ==> [| C(z) type |]) ==> \
\   [| ?a : (SUM z:A*B. C(z)) --> SUM x:A. SUM y:B. C(<x,y>)  |]";
(*Unfold definitions in assumptions!!!!!*)
val rasms = map (rewrite_rule basic_defs) asms;
by (rewrite_goals_tac basic_defs);
by (resolve_tac intr_rls 1);
by (biresolve_tac safe_brls 2);
(*Now must convert assumption C(kb) into antecedent C(<kd,ke>) *)
by (res_inst_tac [ ("a","kc",Aexp) ] Prod_elim 2);
by (typechk_tac rasms);
by (resolve_tac [Sum_elim] 1  THEN  assume_tac 1);
by (intr_tac[]);
by (REPEAT_FIRST assume_tac);
by (typechk_tac rasms);
uresult();


writeln"Reached end of file.";
(*28 August 1988: loaded this file in 78 seconds*)
(*2 September 1988: loaded this file in 76 seconds*)
