(*  Title: 	CTT/arith
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1988  University of Cambridge

Arithmetic operators and their definitions
*)

(*Syntax*)
val arith_infix_decs = 
    [ (["#*","//","/"],		"right", 5),
      (["#+","-","|-|"],	"right", 3) ];

val arith_syn = Syntax.extend CTT_Syntax.syn
	([], arith_infix_decs, parser, printer); 


(*Types of constants*)
val arith_const_decs = 
  [ (["#+", "-", "|-|", "#*", "//", "/"],  [Aexp,Aexp]--->Aexp) ];

val arith_thy = Thm.enrich_theory CTT_Rule.thy  "arith" 
    ([], arith_const_decs,  arith_syn)

  [ ("add_def",  "a#+b == rec(a, b, %(u,v)succ(v))"),
  
    ("diff_def",  "a-b == rec(b, a, %(u,v)rec(v, 0, %(x,y)x))"),
  
    ("absdiff_def",  "a|-|b == (a-b) #+ (b-a)"),
  
    ("mult_def",  "a#*b == rec(a, 0, %(u,v) b #+ v)"),
  
    ("mod_def",  "a//b == rec(a, 0, %(u,v)   \
  \			rec(succ(v) |-| b, 0, %(x,y)succ(v)))"),
  
    ("quo_def",  "a/b == rec(a, 0, %(u,v)   \
  \			rec(succ(u) // b, succ(v), %(x,y)v))") ];


val ax = Thm.get_axiom arith_thy;

val add_def = ax"add_def";
val diff_def = ax"diff_def";
val absdiff_def = ax"absdiff_def";
val mult_def = ax"mult_def";
val mod_def = ax"mod_def";
val quo_def = ax"quo_def";

val arith_defs = [add_def, diff_def, absdiff_def, mult_def, mod_def, quo_def];

