(*  Title: 	CTT/ROOT
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1988  University of Cambridge

Adds Constructive Type Theory to a database containing pure Isabelle. 
Should be executed in the subdirectory CTT.

To build system, enter Poly/ML and type
    PolyML.use "ROOT";
*)

writeln"Root file for Constructive Type Theory";

open PolyML;  (*essential when using make_database!*)

print_depth 1;  
use "syntax.ML";
use ".rules.ML";
use "resolve.ML";

print_depth 1;  
structure CTT_Syntax = 
    CTT_SyntaxFun(structure Syntax=Syntax and Pretty=Pretty);
structure CTT_Rule = CTT_RuleFun(structure CTT_Syntax=CTT_Syntax and Thm=Thm);
structure CTT_Resolve = CTT_ResolveFun
    (structure CTT_Syntax=CTT_Syntax and CTT_Rule=CTT_Rule 
           and Logic=Logic and Conv=Conv);

print_depth 0;  
open Thm Tactic Conv Goals;
open CTT_Resolve CTT_Rule CTT_Syntax;

Unify.printer := Syntax.prin syn;


print_depth 8;  
use "arith.ML";
use "bool.ML";

use "rew.ML";
print_depth 8;  
