(*  Title: 	pcset-rules
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1986  University of Cambridge

Predicate Calculus and Set Theory rules

DEFINE (A Int B)  AS     {x:A| x:B} !  
*)



val SetSign =
  extend_sign (Signat{lextab=pcset_lextab,  defines=[],
		      parse_tm=parse_pcset_term,  parse_thm=parse_thm,
        	      print_tm=print_pcset_term,  print_thm=print_goal},
         [ ("T", ConstSy Aform,  "~ F"),
           ("<=>", InfixSy([Aform,Aform]--->Aform, 10, 9), (*right assoc*)
                   "%(P,Q) (P==>Q)&(Q==>P)"),
           ("reduce", ConstSy([Aexp,Aexp]--->Aform), "%(A,B)A=B"),
           ("<=", InfixSy([Aexp,Aexp]--->Aform, 40, 40), 
		"%(A,B)ALL x. x:A ==> x:B"),
	   ("Inter", ConstSy(Aexp-->Aexp),
		"%(C)Collect(Union(C), %(x)ALL y. y:C ==> x:y)"),
	   ("Un",  InfixSy([Aexp,Aexp]--->Aexp, 50, 49),  "%(a,b)Union({a,b})"),
	   ("Int", InfixSy([Aexp,Aexp]--->Aexp, 60, 59),  "%(a,b)Inter({a,b})"),
	   ("Pair",  ConstSy([Aexp,Aexp]--->Aexp), "%(a,b) { {a}, {a,b} }"),
	   ("*",  InfixSy([Aexp,Aexp]--->Aexp, 60, 59),
		"%(A,B)Collect(Pow(Pow(A Un B)),   \
	           \	%(x) EXISTS a. EXISTS b. a:A & b:B & x= <a,b>)"),
	   ("Domain",  ConstSy(Aexp-->Aexp),
		"%(C)Collect(Union(Union(C)), %(a) EXISTS b. <a,b> : C)"),
	   ("Range",  ConstSy(Aexp-->Aexp),
		"%(C)Collect(Union(Union(C)), %(b) EXISTS a. <a,b> : C)"),
	   ("succ", ConstSy(Aexp-->Aexp),  "%(a) a Un {a}") ]);


val rdset : string -> term  = read_term SetSign;
val prset : term -> unit  = print_term SetSign;


val SetThy = new_theory SetSign [

  ("assume",   [],
      [],  "?P  [ ?H, ?P, ?G ]"  ),

  ("thin",   [],
      [ "?P  [ ?H, ?G     ]" ] ,
    (*------------------------*)
	"?P  [ ?H, ?Q, ?G ]"  ),


  (*Equality rules*)

  ("refl",   [],
      [] ,  "?A = ?A  [ ?H ]"  ),


  ("sym",   [],
      [ "?A = ?B  [ ?H ]" ] ,
    (*------------------------*)
	"?B = ?A  [ ?H ]"  ),


  ("trans",   [],
      [ "?A = ?B  [ ?H ]",  "?B = ?C  [ ?H ]" ] ,
    (*-------------------------------------*)
		 "?A = ?C  [ ?H ]"),



  (*CAN BE DEFINED VIA     val cut = imp_elim RES imp_intr
    BUT PREMISES COME UP IN WRONG ORDER!*)
  ("cut",   [],
      [ "?P  [ ?H ]"  , "?Q [ ?H, ?P ]" ] ,
    (*-----------------------------------*)
		"?Q [ ?H ]"  ),


  ("all_intr",   ["x> ?H ?P'"],
         [ "?P'(x)  [ ?H ]" ] ,
    (*---------------------------*)
	"All(?P')  [ ?H ]"  ),

  ("all_elim",   [],
      [ "All(?P')  [ ?H ]" ] ,
    (*-------------------------*)
	"?P'(?a)  [ ?H ]"  ),


  ("exists_intr",   [],
       [ "?P'(?a)  [ ?H ]" ] ,
    (*-----------------------*)
      "Exists(?P')  [ ?H ]"  ),

  ("exists_elim",   ["y> ?H ?P' ?R"],
      [ "Exists(?P')  [ ?H ]",    "?R [ ?H, ?P'(y) ]" ],
    (*-----------------------------------------------------*)
                         "?R [ ?H ]"  ),


  ("conj_intr",   [],
      [ "?P  [ ?H ]",   "?Q  [ ?H ]" ] ,
    (*--------------------------------*)
   	   "?P & ?Q  [ ?H ]"  ),

  ("conj_elim",   [],
      [  "?P & ?Q  [ ?H ]",    "?R [ ?H, ?P, ?Q ]"  ] ,
    (*-----------------------------------------------*)
                      "?R  [ ?H ]" ),



  ("disj_intr1",   [],
      [   "?P  [ ?H ]"   ],
    (*---------------------*)
       "?P | ?Q  [ ?H ]"  ),

  ("disj_intr2",   [],
      [   "?Q  [ ?H ]"   ],
    (*---------------------*)
       "?P | ?Q  [ ?H ]"  ),

  ("disj_elim",   [],
      [ "?P | ?Q  [ ?H ]",    "?R  [ ?H, ?P ]",    "?R [ ?H, ?Q ]" ],
    (*--------------------------------------------------------------*)
		         "?R  [ ?H ]"  ),


  ("imp_intr",   [],
      [ "?Q  [ ?H, ?P ]" ],
    (*--------------------*)
       "?P==>?Q  [ ?H ]"  ),

  ("imp_elim",   [],
      [ "?P ==> ?Q  [ ?H ]",    "?P  [ ?H ]" ],
    (*----------------------------------------*)
                  "?Q  [ ?H ]"  ),


  ("F_elim",   [],
      [   "F [?H, ~ ?P ]" ],
    (*----------------------*)
           "?P [?H]"  ),


  ("member_cong",   [],
      [ "?a = ?b  [ ?H ]",  "?A = ?B  [ ?H ]",  "?b : ?B  [ ?H ]" ] ,
    (*-------------------------------------------------------------*)
		 "?a : ?A  [ ?H ]"),

  ("extensionality",   [],
      [ "?A <= ?B  [ ?H ]",  "?B <= ?A  [ ?H ]" ] ,
    (*-------------------------------------------*)
		 "?A = ?B  [ ?H ]"),

  ("nullset",   [],
      [ "?a : 0  [ ?H ]" ] ,
    (*------------------------*)
	   "F  [ ?H ]"  ),

  (*Collection*)
  ("Collect_iff",  [],
      [],  "?a : Collect(?A,?P')  <=>  ?a:?A & ?P'(?a)  [ ?H ]"  ),


  ("Pow_iff",  [],
      [],  "?A : Pow(?B)   <=>   ?A <= ?B  [ ?H ]"  ),


  ("Union_iff",  [],
      [],  "?A : Union(?C)   <=>   EXISTS B. ?A:B  &  B:?C  [ ?H ]"  ),


  (*Axiom of infinity: the set N*)
  ("N_intr0",   [],
      [] ,    "0 : N  [ ?H ]"  ),

  ("N_intr_succ",   [],
      [ "?a   :   N  [ ?H ]" ] ,
    (*------------------------------*)
	"succ(?a) : N  [ ?H ]"  ),

  (*Can be proved by defining N as intersection of succ-closed sets*)
  ("N_elim",   ["z> ?H ?P'"],
      [ "?a : N  [?H]",    "?P'(0) [?H]",   "?P'(succ(z))  [ ?H, ?P'(z) ]" ],
    (*----------------------------------------------------------------------*)
	"?P'(?a)  [ ?H ]"  ),


  (*Regularity via transfinite induction -- lazy again, I admit*)
  ("induction",   ["u> ?H ?P'"],
      [ "?P'(u)  [ ?H, ALL v. v:u ==> ?P'(v) ]" ],
    (*------------------------------------------*)
		"?P'(?a)  [ ?H ]"  ),


  ("setcons_iff",  [],
      [],  "?a : (?b::?B)   <=>   ?a=?b  |  ?a:?B  [ ?H ]"  )

  (*REPLACEMENT?  CHOICE?*)
 ];

val rule_named = get_rule SetThy;
